/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.index.impl;

import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.gwt.index.JpsGwtModule;
import org.jetbrains.jps.gwt.index.JpsGwtModuleIndex;
import org.jetbrains.jps.gwt.index.impl.JpsGwtModulesCache;
import org.jetbrains.jps.gwt.model.JpsGwtModuleExtension;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsGwtModuleIndexImpl
implements JpsGwtModuleIndex {
    private final MultiMap<JpsModule, JpsGwtModule> myModules = new MultiMap();
    private final MultiMap<String, JpsGwtModule> myModulesByName = new MultiMap();
    private final Map<JpsGwtModule, InheritedModulesInfo> myInheritanceMap = new HashMap<JpsGwtModule, InheritedModulesInfo>();

    public JpsGwtModuleIndexImpl(JpsModel model, BuildDataPaths buildDataPaths) {
        List<JpsGwtModule> gwtModules = new JpsGwtModulesCache(buildDataPaths).loadGwtModules(model);
        for (JpsGwtModule gwtModule : gwtModules) {
            this.myModules.putValue((Object)gwtModule.getModule(), (Object)gwtModule);
            this.myModulesByName.putValue((Object)gwtModule.getQualifiedName(), (Object)gwtModule);
        }
        for (JpsGwtModule module : this.myModules.values()) {
            this.processInherited(module);
        }
    }

    private InheritedModulesInfo processInherited(JpsGwtModule module) {
        InheritedModulesInfo old = this.myInheritanceMap.get(module);
        if (old != null) {
            return old;
        }
        InheritedModulesInfo info = new InheritedModulesInfo();
        this.myInheritanceMap.put(module, info);
        for (String name : module.getInheritedNames()) {
            Collection modules = this.myModulesByName.get((Object)name);
            if (modules.isEmpty()) {
                info.myMayHaveEntryPoints = true;
                continue;
            }
            for (JpsGwtModule inherited : modules) {
                InheritedModulesInfo inheritedInfo = this.processInherited(inherited);
                InheritedModulesInfo inheritedModulesInfo = info;
                inheritedModulesInfo.myMayHaveEntryPoints = inheritedModulesInfo.myMayHaveEntryPoints | inheritedInfo.myMayHaveEntryPoints;
                info.myInheritedModules.add(inherited);
                info.myInheritedModules.addAll(inheritedInfo.myInheritedModules);
            }
        }
        return info;
    }

    @Override
    public Collection<JpsGwtModule> getModulesByName(String qualifiedName) {
        return this.myModulesByName.get((Object)qualifiedName);
    }

    @Override
    @NotNull
    public Collection<JpsGwtModule> getModulesToCompile(@NotNull JpsGwtModuleExtension extension, boolean includeTests) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleIndexImpl", "getModulesToCompile"));
        }
        Collection<JpsGwtModule> collection = this.getModules(extension, includeTests, true);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleIndexImpl", "getModulesToCompile"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<JpsGwtModule> getModules(@NotNull JpsGwtModuleExtension extension, boolean includeTests, boolean compilableOnly) {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleIndexImpl", "getModules"));
        }
        Collection modules = this.myModules.get((Object)extension.getModule());
        ArrayList<JpsGwtModule> result = new ArrayList<JpsGwtModule>();
        for (JpsGwtModule module : modules) {
            if (!includeTests && module.isInTests() || compilableOnly && !this.isCompilable(module, extension)) continue;
            result.add(module);
        }
        ArrayList<JpsGwtModule> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleIndexImpl", "getModules"));
        }
        return arrayList;
    }

    @Override
    public boolean isCompilable(JpsGwtModule module, JpsGwtModuleExtension extension) {
        return !this.isLibraryModule(module) && extension.isModuleCompilationEnabled(module);
    }

    private boolean isLibraryModule(JpsGwtModule module) {
        if (module.hasEntryPoints()) {
            return false;
        }
        return !this.processInherited(module).myMayHaveEntryPoints;
    }

    @Override
    @NotNull
    public Collection<JpsGwtModule> getInheritedModules(@NotNull JpsGwtModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleIndexImpl", "getInheritedModules"));
        }
        Set set = this.processInherited(module).myInheritedModules;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleIndexImpl", "getInheritedModules"));
        }
        return set;
    }

    private static class InheritedModulesInfo {
        private boolean myMayHaveEntryPoints;
        private Set<JpsGwtModule> myInheritedModules = new LinkedHashSet<JpsGwtModule>();

        private InheritedModulesInfo() {
        }
    }
}

