/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsCompositeElement;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.impl.JpsNamedElementReferenceBase;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryRole;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;

public class JpsSdkReferenceImpl<P extends JpsElement>
extends JpsNamedElementReferenceBase<JpsLibrary, JpsTypedLibrary<JpsSdk<P>>, JpsSdkReferenceImpl<P>>
implements JpsSdkReference<P> {
    private final JpsSdkType<P> mySdkType;

    public JpsSdkReferenceImpl(@NotNull String elementName, @NotNull JpsSdkType<P> sdkType, @NotNull JpsElementReference<? extends JpsCompositeElement> parentReference) {
        if (elementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elementName", "org/jetbrains/jps/model/library/impl/JpsSdkReferenceImpl", "<init>"));
        }
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "org/jetbrains/jps/model/library/impl/JpsSdkReferenceImpl", "<init>"));
        }
        if (parentReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentReference", "org/jetbrains/jps/model/library/impl/JpsSdkReferenceImpl", "<init>"));
        }
        super(elementName, parentReference);
        this.mySdkType = sdkType;
    }

    private JpsSdkReferenceImpl(JpsSdkReferenceImpl<P> original) {
        super(original);
        this.mySdkType = original.mySdkType;
    }

    @Override
    @NotNull
    public String getSdkName() {
        String string = this.myElementName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsSdkReferenceImpl", "getSdkName"));
        }
        return string;
    }

    @Override
    protected JpsTypedLibrary<JpsSdk<P>> resolve(JpsLibrary element) {
        return element.asTyped(this.mySdkType);
    }

    @Override
    @NotNull
    public JpsSdkReferenceImpl<P> createCopy() {
        JpsSdkReferenceImpl<P> jpsSdkReferenceImpl = new JpsSdkReferenceImpl<P>(this);
        if (jpsSdkReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/library/impl/JpsSdkReferenceImpl", "createCopy"));
        }
        return jpsSdkReferenceImpl;
    }

    @Override
    @Nullable
    protected JpsElementCollection<? extends JpsLibrary> getCollection(@NotNull JpsCompositeElement parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/jps/model/library/impl/JpsSdkReferenceImpl", "getCollection"));
        }
        return (JpsElementCollection)((Object)parent.getContainer().getChild(JpsLibraryRole.LIBRARIES_COLLECTION_ROLE));
    }
}

