/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.model.impl;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.javaee.model.JpsApplicationServersTable;
import org.jetbrains.jps.javaee.model.JpsJavaeeExtensionReference;
import org.jetbrains.jps.javaee.model.JpsJavaeeExtensionService;
import org.jetbrains.jps.javaee.model.JpsJavaeeFacetClassesPackagingElement;
import org.jetbrains.jps.javaee.model.JpsJavaeeFacetResourcesPackagingElement;
import org.jetbrains.jps.javaee.model.JpsJavaeeModuleExtension;
import org.jetbrains.jps.javaee.model.app.impl.JpsJavaeeAppModuleExtensionImpl;
import org.jetbrains.jps.javaee.model.ejb.impl.JpsEjbModuleExtensionImpl;
import org.jetbrains.jps.javaee.model.impl.JpsApplicationServersTableImpl;
import org.jetbrains.jps.javaee.model.impl.JpsApplicationServersTableReference;
import org.jetbrains.jps.javaee.model.impl.JpsJavaeeExtensionReferenceImpl;
import org.jetbrains.jps.javaee.model.impl.JpsJavaeeFacetClassesPackagingElementImpl;
import org.jetbrains.jps.javaee.model.impl.JpsJavaeeFacetResourcesPackagingElementImpl;
import org.jetbrains.jps.javaee.model.web.JpsWebModuleExtension;
import org.jetbrains.jps.javaee.model.web.impl.JpsWebModuleExtensionImpl;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsGlobal;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.module.JpsModule;

public class JpsJavaeeExtensionServiceImpl
extends JpsJavaeeExtensionService {
    private static final String WEB_EXTENSION_ID = "web";
    private static final String EJB_EXTENSION_ID = "ejb";
    private static final String APPLICATION_EXTENSION_ID = "javaeeApplication";

    @Override
    @NotNull
    public JpsWebModuleExtension addWebExtension(@NotNull JpsModule module, String name) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "addWebExtension"));
        }
        JpsElementCollection collection = (JpsElementCollection)module.getContainer().getOrSetChild(JpsWebModuleExtensionImpl.COLLECTION_ROLE);
        JpsWebModuleExtension jpsWebModuleExtension = (JpsWebModuleExtension)collection.addChild((JpsElement)new JpsWebModuleExtensionImpl(name));
        if (jpsWebModuleExtension == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "addWebExtension"));
        }
        return jpsWebModuleExtension;
    }

    @Override
    public List<JpsWebModuleExtension> getWebExtensions(JpsModule module) {
        JpsElementCollection child = (JpsElementCollection)module.getContainer().getChild(JpsWebModuleExtensionImpl.COLLECTION_ROLE);
        return child != null ? child.getElements() : Collections.emptyList();
    }

    @Override
    @NotNull
    public JpsApplicationServersTable getOrCreateApplicationServersTable(@NotNull JpsGlobal global) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "getOrCreateApplicationServersTable"));
        }
        JpsApplicationServersTable jpsApplicationServersTable = (JpsApplicationServersTable)global.getContainer().getOrSetChild((JpsElementChildRole)JpsApplicationServersTableImpl.ROLE);
        if (jpsApplicationServersTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "getOrCreateApplicationServersTable"));
        }
        return jpsApplicationServersTable;
    }

    @Override
    @Nullable
    public JpsApplicationServersTable getApplicationServersTable(@NotNull JpsGlobal global) {
        if (global == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "global", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "getApplicationServersTable"));
        }
        return (JpsApplicationServersTable)global.getContainer().getChild((JpsElementChildRole)JpsApplicationServersTableImpl.ROLE);
    }

    @Override
    @NotNull
    public JpsJavaeeExtensionReference createReference(@NotNull String facetId) {
        if (facetId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facetId", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "createReference"));
        }
        int i = facetId.indexOf(47);
        int j = facetId.lastIndexOf(47);
        String moduleName = facetId.substring(0, i);
        String typeId = facetId.substring(i + 1, j);
        String extensionName = facetId.substring(j + 1);
        JpsJavaeeExtensionReferenceImpl jpsJavaeeExtensionReferenceImpl = new JpsJavaeeExtensionReferenceImpl(JpsJavaeeExtensionServiceImpl.getExtensionRole(typeId), moduleName, extensionName);
        if (jpsJavaeeExtensionReferenceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "createReference"));
        }
        return jpsJavaeeExtensionReferenceImpl;
    }

    @Override
    @NotNull
    public JpsJavaeeFacetResourcesPackagingElement createFacetResourcesPackagingElement(@NotNull JpsJavaeeExtensionReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "createFacetResourcesPackagingElement"));
        }
        JpsJavaeeFacetResourcesPackagingElementImpl jpsJavaeeFacetResourcesPackagingElementImpl = new JpsJavaeeFacetResourcesPackagingElementImpl(reference);
        if (jpsJavaeeFacetResourcesPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "createFacetResourcesPackagingElement"));
        }
        return jpsJavaeeFacetResourcesPackagingElementImpl;
    }

    @Override
    @NotNull
    public JpsJavaeeFacetClassesPackagingElement createFacetClassesPackagingElement(@NotNull JpsJavaeeExtensionReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "createFacetClassesPackagingElement"));
        }
        JpsJavaeeFacetClassesPackagingElementImpl jpsJavaeeFacetClassesPackagingElementImpl = new JpsJavaeeFacetClassesPackagingElementImpl(reference);
        if (jpsJavaeeFacetClassesPackagingElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "createFacetClassesPackagingElement"));
        }
        return jpsJavaeeFacetClassesPackagingElementImpl;
    }

    @Override
    @NotNull
    public String getReferenceString(@NotNull JpsJavaeeExtensionReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "getReferenceString"));
        }
        String string = reference.getParentReference().getModuleName() + "/" + JpsJavaeeExtensionServiceImpl.getRoleString(reference.getChildRole()) + "/" + reference.getExtensionName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javaee/model/impl/JpsJavaeeExtensionServiceImpl", "getReferenceString"));
        }
        return string;
    }

    private static String getRoleString(JpsElementCollectionRole<? extends JpsJavaeeModuleExtension> role) {
        if (role.equals(JpsWebModuleExtensionImpl.COLLECTION_ROLE)) {
            return WEB_EXTENSION_ID;
        }
        if (role.equals(JpsEjbModuleExtensionImpl.COLLECTION_ROLE)) {
            return EJB_EXTENSION_ID;
        }
        if (role.equals(JpsJavaeeAppModuleExtensionImpl.COLLECTION_ROLE)) {
            return APPLICATION_EXTENSION_ID;
        }
        throw new IllegalArgumentException(String.valueOf(role));
    }

    private static JpsElementCollectionRole<? extends JpsJavaeeModuleExtension> getExtensionRole(String id) {
        if (id.equals(WEB_EXTENSION_ID)) {
            return JpsWebModuleExtensionImpl.COLLECTION_ROLE;
        }
        if (id.equals(EJB_EXTENSION_ID)) {
            return JpsEjbModuleExtensionImpl.COLLECTION_ROLE;
        }
        if (id.equals(APPLICATION_EXTENSION_ID)) {
            return JpsJavaeeAppModuleExtensionImpl.COLLECTION_ROLE;
        }
        throw new IllegalArgumentException("Unknown JavaEE module extension id:" + id);
    }

    @Override
    public JpsElementReference<JpsApplicationServersTable> createApplicationServersTableReference() {
        return new JpsApplicationServersTableReference();
    }
}

