/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gant;

import com.intellij.openapi.diagnostic.Log4jBasedLogger;
import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;

public class Log4jFileLoggerFactory
implements Logger.Factory {
    private final RollingFileAppender myAppender;
    private final List<String> myCategoriesWithDebugLevel;

    public Log4jFileLoggerFactory(File logFile, String categoriesWithDebugLevel) throws IOException {
        this.myCategoriesWithDebugLevel = categoriesWithDebugLevel.isEmpty() ? Collections.emptyList() : Arrays.asList(categoriesWithDebugLevel.split(","));
        PatternLayout pattern = new PatternLayout("%d [%7r] %6p - %30.30c - %m\n");
        this.myAppender = new RollingFileAppender((Layout)pattern, logFile.getAbsolutePath());
        this.myAppender.setMaxFileSize("20MB");
        this.myAppender.setMaxBackupIndex(10);
    }

    public com.intellij.openapi.diagnostic.Logger getLoggerInstance(String category) {
        Logger logger = Logger.getLogger((String)category);
        logger.addAppender((Appender)this.myAppender);
        logger.setLevel(this.isDebugLevel(category) ? Level.DEBUG : Level.INFO);
        return new Log4jBasedLogger(logger);
    }

    private boolean isDebugLevel(String category) {
        for (String debug : this.myCategoriesWithDebugLevel) {
            if (!category.startsWith(debug)) continue;
            return true;
        }
        return false;
    }
}

