/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.SdkManager;
import com.android.sdklib.io.FileOp;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.google.common.base.Objects;
import java.io.File;
import java.util.Arrays;
import java.util.Locale;

public class SystemImage
implements ISystemImage {
    public static final IdDisplay DEFAULT_TAG = new IdDisplay("default", "Default");
    @Deprecated
    private final ISystemImage.LocationType mLocationtype;
    private final IdDisplay mTag;
    private final IdDisplay mAddonVendor;
    private final String mAbiType;
    private final File mLocation;
    private final File[] mSkins;

    public SystemImage(@NonNull File location, @NonNull ISystemImage.LocationType locationType, @NonNull IdDisplay tag, @NonNull String abiType, @NonNull File[] skins) {
        this(location, locationType, tag, null, abiType, skins);
    }

    public SystemImage(@NonNull File location, @NonNull ISystemImage.LocationType locationType, @NonNull IdDisplay tagName, @Nullable IdDisplay addonVendor, @NonNull String abiType, @NonNull File[] skins) {
        this.mLocation = location;
        this.mLocationtype = locationType;
        this.mTag = tagName;
        this.mAddonVendor = addonVendor;
        this.mAbiType = abiType;
        this.mSkins = skins;
    }

    public SystemImage(@NonNull SdkManager sdkManager, @NonNull IAndroidTarget target, @NonNull ISystemImage.LocationType locationType, @NonNull IdDisplay tag, @NonNull String abiType, @NonNull File[] skins) {
        this(sdkManager, target, locationType, tag, null, abiType, skins);
    }

    public SystemImage(@NonNull SdkManager sdkManager, @NonNull IAndroidTarget target, @NonNull ISystemImage.LocationType locationType, @NonNull IdDisplay tag, @Nullable IdDisplay addonVendor, @NonNull String abiType, @NonNull File[] skins) {
        this.mLocationtype = locationType;
        this.mTag = tag;
        this.mAddonVendor = addonVendor;
        this.mAbiType = abiType;
        this.mSkins = skins;
        File location = null;
        switch (locationType) {
            case IN_LEGACY_FOLDER: {
                location = new File(target.getLocation(), SdkConstants.OS_IMAGES_FOLDER);
                break;
            }
            case IN_IMAGES_SUBFOLDER: {
                location = FileOp.append(target.getLocation(), SdkConstants.OS_IMAGES_FOLDER, abiType);
                break;
            }
            case IN_SYSTEM_IMAGE: {
                location = SystemImage.getCanonicalFolder(sdkManager.getLocation(), target.getVersion(), tag.getId(), addonVendor == null ? null : addonVendor.getId(), abiType);
                break;
            }
            default: {
                assert (false) : "SystemImage used with an incorrect locationType";
                break;
            }
        }
        this.mLocation = location;
    }

    @NonNull
    private static File getCanonicalFolder(@NonNull String sdkOsPath, @NonNull AndroidVersion platformVersion, @Nullable String tagId, @Nullable String addonVendorId, @Nullable String abiType) {
        File root;
        if (addonVendorId == null) {
            root = FileOp.append(sdkOsPath, "system-images", AndroidTargetHash.getPlatformHashString(platformVersion));
            if (tagId != null) {
                root = FileOp.append(root, tagId);
            }
        } else {
            root = FileOp.append(sdkOsPath, "system-images", AndroidTargetHash.getAddonHashString(addonVendorId, tagId, platformVersion));
        }
        if (abiType == null) {
            return root;
        }
        return FileOp.append(root, abiType);
    }

    @Override
    @NonNull
    public File getLocation() {
        return this.mLocation;
    }

    @Override
    @NonNull
    public ISystemImage.LocationType getLocationType() {
        return this.mLocationtype;
    }

    @Override
    @NonNull
    public IdDisplay getTag() {
        return this.mTag;
    }

    @Override
    @Nullable
    public IdDisplay getAddonVendor() {
        return this.mAddonVendor;
    }

    @Override
    @NonNull
    public String getAbiType() {
        return this.mAbiType;
    }

    @Override
    @NonNull
    public File[] getSkins() {
        return this.mSkins;
    }

    @Override
    public int compareTo(ISystemImage other) {
        int t = this.getTag().compareTo(other.getTag());
        if (t != 0) {
            return t;
        }
        return this.getAbiType().compareToIgnoreCase(other.getAbiType());
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SystemImage");
        if (this.mAddonVendor != null) {
            sb.append(" addon-vendor=").append(this.mAddonVendor.getId()).append(',');
        }
        sb.append(" tag=").append(this.mTag.getId());
        sb.append(", ABI=").append(this.mAbiType);
        sb.append(", location ").append(this.mLocationtype.toString().replace('_', ' ').toLowerCase(Locale.US)).append("='").append(this.mLocation).append("'");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SystemImage)) {
            return false;
        }
        SystemImage other = (SystemImage)o;
        return this.mTag.equals(other.mTag) && this.mAbiType.equals(other.getAbiType()) && Objects.equal((Object)this.mAddonVendor, (Object)other.mAddonVendor) && this.mLocation.equals(other.mLocation) && Arrays.equals(this.mSkins, other.mSkins);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mTag, this.mAbiType, this.mAddonVendor, this.mLocation, this.mSkins});
    }
}

