/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee;

import com.intellij.openapi.util.io.FileUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.artifacts.builders.LayoutElementBuilderService;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactCompilerInstructionCreator;
import org.jetbrains.jps.incremental.artifacts.instructions.ArtifactInstructionsBuilderContext;
import org.jetbrains.jps.incremental.artifacts.instructions.SourceFileFilter;
import org.jetbrains.jps.javaee.model.JpsJavaeeFacetClassesPackagingElement;
import org.jetbrains.jps.javaee.model.JpsJavaeeModuleExtension;
import org.jetbrains.jps.javaee.model.ejb.JpsEjbModuleExtension;
import org.jetbrains.jps.javaee.model.web.JpsWebModuleExtension;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class JavaeeFacetClassesElementBuilder
extends LayoutElementBuilderService<JpsJavaeeFacetClassesPackagingElement> {
    public JavaeeFacetClassesElementBuilder() {
        super(JpsJavaeeFacetClassesPackagingElement.class);
    }

    public void generateInstructions(JpsJavaeeFacetClassesPackagingElement element, ArtifactCompilerInstructionCreator instructionCreator, ArtifactInstructionsBuilderContext context) {
        File outputDir;
        JpsJavaeeModuleExtension extension = (JpsJavaeeModuleExtension)element.getJavaeeExtensionReference().resolve();
        if (extension != null && (outputDir = JpsJavaExtensionService.getInstance().getOutputDirectory(extension.getModule(), false)) != null) {
            List sourceRootsUrls = extension instanceof JpsWebModuleExtension ? ((JpsWebModuleExtension)extension).getSourceRootsList().getUrls() : (extension instanceof JpsEjbModuleExtension ? ((JpsEjbModuleExtension)extension).getSourceRootsList().getUrls() : Collections.emptyList());
            THashSet roots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            for (String url : sourceRootsUrls) {
                roots.add(JpsPathUtil.urlToFile((String)url));
            }
            SourceRootFileFilter filter = new SourceRootFileFilter(extension.getModule(), (Set<File>)roots);
            instructionCreator.addDirectoryCopyInstructions(outputDir, (SourceFileFilter)filter, instructionCreator.getInstructionsBuilder().createCopyingHandler(outputDir, (JpsPackagingElement)element));
        }
    }

    public Collection<? extends BuildTarget<?>> getDependencies(@NotNull JpsJavaeeFacetClassesPackagingElement element, TargetOutputIndex outputIndex) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/jps/javaee/JavaeeFacetClassesElementBuilder", "getDependencies"));
        }
        JpsModule module = (JpsModule)element.getModuleReference().resolve();
        if (module != null) {
            return Collections.singletonList(new ModuleBuildTarget(module, JavaModuleBuildTargetType.PRODUCTION));
        }
        return Collections.emptyList();
    }

    private static class SourceRootFileFilter
    extends SourceFileFilter {
        private final JpsModule myModule;
        private final Set<File> mySourceRoots;
        private Set<String> myAcceptedOutputPaths;

        public SourceRootFileFilter(JpsModule module, Set<File> sourceRoots) {
            this.myModule = module;
            this.mySourceRoots = sourceRoots;
        }

        public boolean accept(@NotNull String fullFilePath) {
            if (fullFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFilePath", "org/jetbrains/jps/javaee/JavaeeFacetClassesElementBuilder$SourceRootFileFilter", "accept"));
            }
            return true;
        }

        public boolean shouldBeCopied(@NotNull String fullFilePath, ProjectDescriptor projectDescriptor) throws IOException {
            if (fullFilePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullFilePath", "org/jetbrains/jps/javaee/JavaeeFacetClassesElementBuilder$SourceRootFileFilter", "shouldBeCopied"));
            }
            if (new File(fullFilePath).isDirectory()) {
                return true;
            }
            return this.getOrComputeAcceptedOutputs(projectDescriptor).contains(FileUtil.toSystemIndependentName((String)fullFilePath));
        }

        private Set<String> getOrComputeAcceptedOutputs(ProjectDescriptor projectDescriptor) throws IOException {
            if (this.myAcceptedOutputPaths == null) {
                this.myAcceptedOutputPaths = new THashSet(FileUtil.PATH_HASHING_STRATEGY);
                for (BuildTarget target : projectDescriptor.getBuildTargetIndex().getModuleBasedTargets(this.myModule, BuildTargetRegistry.ModuleTargetSelector.PRODUCTION)) {
                    SourceToOutputMapping mapping = projectDescriptor.dataManager.getSourceToOutputMap(target);
                    for (String sourcePath : mapping.getSources()) {
                        if (!JpsPathUtil.isUnder(this.mySourceRoots, (File)new File(sourcePath))) continue;
                        this.myAcceptedOutputPaths.addAll(mapping.getOutputs(sourcePath));
                    }
                }
            }
            return this.myAcceptedOutputPaths;
        }
    }
}

