/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashSet;
import java.util.EventListener;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HeavyProcessLatch {
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);

    private HeavyProcessLatch() {
    }

    @Deprecated
    public void processStarted() {
        this.processStarted("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public AccessToken processStarted(final @NotNull String operationName) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "com/intellij/util/io/storage/HeavyProcessLatch", "processStarted"));
        }
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.add(operationName);
        }
        this.myEventDispatcher.getMulticaster().processStarted();
        AccessToken accessToken = new AccessToken(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finish() {
                Set set = HeavyProcessLatch.this.myHeavyProcesses;
                synchronized (set) {
                    HeavyProcessLatch.this.myHeavyProcesses.remove(operationName);
                }
            }
        };
        if (accessToken == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/io/storage/HeavyProcessLatch", "processStarted"));
        }
        return accessToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void processFinished() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.remove("");
        }
        this.myEventDispatcher.getMulticaster().processFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return !this.myHeavyProcesses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRunningOperationName() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return this.myHeavyProcesses.isEmpty() ? null : this.myHeavyProcesses.iterator().next();
        }
    }

    public void addListener(@NotNull Disposable parentDisposable, @NotNull HeavyProcessListener listener) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/util/io/storage/HeavyProcessLatch", "addListener"));
        }
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/util/io/storage/HeavyProcessLatch", "addListener"));
        }
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processStarted();

        public void processFinished();
    }
}

