/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.flex.build;

import com.intellij.flex.FlexCommonUtils;
import com.intellij.flex.build.FlexResourceBuildTarget;
import com.intellij.flex.build.FlexResourceBuildTargetType;
import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.bc.JpsFlexCompilerOptions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.PathUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.TargetBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.util.JpsPathUtil;

public class FlexResourceBuilder
extends TargetBuilder<BuildRootDescriptor, FlexResourceBuildTarget> {
    @NonNls
    private static final String BUILDER_NAME = "Flash Resource Builder";

    protected FlexResourceBuilder() {
        super(Arrays.asList(FlexResourceBuildTargetType.PRODUCTION, FlexResourceBuildTargetType.TEST));
    }

    @NotNull
    public String getPresentableName() {
        if (BUILDER_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jps/flex/build/FlexResourceBuilder", "getPresentableName"));
        }
        return BUILDER_NAME;
    }

    public void build(@NotNull FlexResourceBuildTarget target, @NotNull DirtyFilesHolder<BuildRootDescriptor, FlexResourceBuildTarget> holder, final @NotNull BuildOutputConsumer outputConsumer, final @NotNull CompileContext context) throws ProjectBuildException, IOException {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/jps/flex/build/FlexResourceBuilder", "build"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jps/flex/build/FlexResourceBuilder", "build"));
        }
        if (outputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputConsumer", "com/intellij/jps/flex/build/FlexResourceBuilder", "build"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/jps/flex/build/FlexResourceBuilder", "build"));
        }
        final JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(target.getModule().getProject());
        final JpsCompilerExcludes excludes = configuration.getCompilerExcludes();
        try {
            holder.processDirtyFiles((FileProcessor)new FileProcessor<BuildRootDescriptor, FlexResourceBuildTarget>(){

                public boolean apply(FlexResourceBuildTarget target, File file, BuildRootDescriptor root) throws IOException {
                    if (excludes.isExcluded(file)) {
                        return true;
                    }
                    String relativePath = FileUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)root.getRootFile(), (File)file));
                    if (target.isTests()) {
                        if (!FlexCommonUtils.isSourceFile(file.getName())) {
                            String outputRootUrl = JpsJavaExtensionService.getInstance().getOutputUrl(target.getModule(), target.isTests());
                            if (outputRootUrl == null) {
                                return true;
                            }
                            String targetPath = JpsPathUtil.urlToPath((String)outputRootUrl) + '/' + relativePath;
                            context.processMessage((BuildMessage)new ProgressMessage("Copying " + file.getPath()));
                            FlexResourceBuilder.copyResource(context, file, Collections.singleton(targetPath), outputConsumer);
                        }
                    } else {
                        ArrayList<String> targetPaths = new ArrayList<String>();
                        for (JpsFlexBuildConfiguration bc : ((JpsFlexBuildConfigurationManager)target.getModule().getProperties()).getBuildConfigurations()) {
                            JpsFlexCompilerOptions.ResourceFilesMode mode;
                            if (bc.isSkipCompile() || !FlexCommonUtils.canHaveResourceFiles(bc.getNature()) || bc.getCompilerOptions().getResourceFilesMode() == JpsFlexCompilerOptions.ResourceFilesMode.None || ((mode = bc.getCompilerOptions().getResourceFilesMode()) != JpsFlexCompilerOptions.ResourceFilesMode.All || FlexCommonUtils.isSourceFile(file.getName())) && (mode != JpsFlexCompilerOptions.ResourceFilesMode.ResourcePatterns || !configuration.isResourceFile(file, root.getRootFile()))) continue;
                            String outputFolder = PathUtilRt.getParentPath((String)bc.getActualOutputFilePath());
                            targetPaths.add(outputFolder + "/" + relativePath);
                        }
                        if (!targetPaths.isEmpty()) {
                            context.processMessage((BuildMessage)new ProgressMessage("Copying " + file.getPath()));
                            FlexResourceBuilder.copyResource(context, file, targetPaths, outputConsumer);
                        }
                    }
                    return true;
                }
            });
        }
        catch (Exception e) {
            throw new ProjectBuildException(e.getMessage(), (Throwable)e);
        }
    }

    private static void copyResource(CompileContext context, File file, Collection<String> targetPaths, BuildOutputConsumer outputConsumer) {
        try {
            for (String targetPath : targetPaths) {
                File targetFile = new File(targetPath);
                FileUtil.copyContent((File)file, (File)targetFile);
                outputConsumer.registerOutputFile(targetFile, Collections.singletonList(file.getPath()));
            }
        }
        catch (IOException e) {
            context.processMessage((BuildMessage)new CompilerMessage(BUILDER_NAME, BuildMessage.Kind.ERROR, e.getMessage(), FileUtil.toSystemIndependentName((String)file.getPath())));
        }
    }
}

