/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.internal.avd;

import com.android.SdkConstants;
import com.android.io.IAbstractFile;
import com.android.io.StreamException;
import com.android.prefs.AndroidLocation;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.io.FileOp;
import com.android.repository.io.FileOpUtils;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.FileOpFileWrapper;
import com.android.sdklib.ISystemImage;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.internal.avd.AvdInfo;
import com.android.sdklib.repositoryv2.AndroidSdkHandler;
import com.android.sdklib.repositoryv2.LoggerProgressIndicatorWrapper;
import com.android.utils.GrabProcessOutput;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AvdManager {
    private static final Pattern INI_LINE_PATTERN = Pattern.compile("^([a-zA-Z0-9._-]+)\\s*=\\s*(.*)\\s*$");
    public static final String AVD_FOLDER_EXTENSION = ".avd";
    public static final String AVD_INI_ENCODING = "avd.ini.encoding";
    public static final String AVD_INFO_ABS_PATH = "path";
    public static final String AVD_INFO_REL_PATH = "path.rel";
    public static final String AVD_INFO_TARGET = "target";
    public static final String AVD_INI_TAG_ID = "tag.id";
    public static final String AVD_INI_TAG_DISPLAY = "tag.display";
    public static final String AVD_INI_ABI_TYPE = "abi.type";
    public static final String AVD_INI_CPU_ARCH = "hw.cpu.arch";
    public static final String AVD_INI_CPU_MODEL = "hw.cpu.model";
    public static final String AVD_INI_CPU_CORES = "hw.cpu.ncore";
    public static final String AVD_INI_DEVICE_MANUFACTURER = "hw.device.manufacturer";
    public static final String AVD_INI_DEVICE_NAME = "hw.device.name";
    public static final String AVD_INI_SKIN_PATH = "skin.path";
    public static final String AVD_INI_BACKUP_SKIN_PATH = "skin.path.backup";
    public static final String AVD_INI_SKIN_NAME = "skin.name";
    public static final String AVD_INI_SKIN_DYNAMIC = "skin.dynamic";
    public static final String AVD_INI_SDCARD_PATH = "sdcard.path";
    public static final String AVD_INI_SDCARD_SIZE = "sdcard.size";
    public static final String AVD_INI_IMAGES_1 = "image.sysdir.1";
    public static final String AVD_INI_IMAGES_2 = "image.sysdir.2";
    public static final String AVD_INI_SNAPSHOT_PRESENT = "snapshot.present";
    public static final String AVD_INI_GPU_EMULATION = "hw.gpu.enabled";
    public static final String AVD_INI_GPU_MODE = "hw.gpu.mode";
    public static final String AVD_INI_CAMERA_FRONT = "hw.camera.front";
    public static final String AVD_INI_CAMERA_BACK = "hw.camera.back";
    public static final String AVD_INI_RAM_SIZE = "hw.ramSize";
    public static final String AVD_INI_VM_HEAP_SIZE = "vm.heapSize";
    public static final String AVD_INI_DATA_PARTITION_SIZE = "disk.dataPartition.size";
    public static final String AVD_INI_DEVICE_HASH_V1 = "hw.device.hash";
    public static final String AVD_INI_DEVICE_HASH_V2 = "hw.device.hash2";
    public static final String AVD_INI_ANDROID_API = "image.androidVersion.api";
    public static final String AVD_INI_ANDROID_CODENAME = "image.androidVersion.codename";
    public static final Pattern NUMERIC_SKIN_SIZE = Pattern.compile("([0-9]{2,})x([0-9]{2,})");
    private static final String USERDATA_IMG = "userdata.img";
    private static final String BOOT_PROP = "boot.prop";
    static final String CONFIG_INI = "config.ini";
    private static final String SDCARD_IMG = "sdcard.img";
    private static final String SNAPSHOTS_IMG = "snapshots.img";
    static final String INI_EXTENSION = ".ini";
    private static final Pattern INI_NAME_PATTERN = Pattern.compile("(.+)\\.ini$", 2);
    private static final Pattern IMAGE_NAME_PATTERN = Pattern.compile("(.+)\\.img$", 2);
    private static final Pattern SDCARD_SIZE_PATTERN = Pattern.compile("(\\d+)([KMG])");
    public static final long SDCARD_MIN_BYTE_SIZE = 0x900000L;
    public static final long SDCARD_MAX_BYTE_SIZE = 0xFFC0000000L;
    public static final int SDCARD_SIZE_NOT_IN_RANGE = 0;
    public static final int SDCARD_SIZE_INVALID = -1;
    public static final int SDCARD_NOT_SIZE_PATTERN = -2;
    public static final Pattern RE_AVD_NAME = Pattern.compile("[a-zA-Z0-9._-]+");
    public static final String CHARS_AVD_NAME = "a-z A-Z 0-9 . _ -";
    public static final String HARDWARE_INI = "hardware.ini";
    private static final Table<String, FileOp, WeakReference<AvdManager>> mManagers = HashBasedTable.create();
    private final ArrayList<AvdInfo> mAllAvdList = new ArrayList();
    private AvdInfo[] mValidAvdList;
    private AvdInfo[] mBrokenAvdList;
    private final AndroidSdkHandler mSdkHandler;
    private final Map<ILogger, DeviceManager> mDeviceManagers = new HashMap<ILogger, DeviceManager>();
    private final FileOp mFop;

    protected AvdManager(AndroidSdkHandler sdkHandler, ILogger log, FileOp fop) throws AndroidLocation.AndroidLocationException {
        this.mSdkHandler = sdkHandler;
        this.mFop = fop;
        this.buildAvdList(this.mAllAvdList, log);
    }

    public static AvdManager getInstance(AndroidSdkHandler sdkHandler, ILogger log) throws AndroidLocation.AndroidLocationException {
        return AvdManager.getInstance(sdkHandler, log, FileOpUtils.create());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AvdManager getInstance(AndroidSdkHandler sdkHandler, ILogger log, FileOp fop) throws AndroidLocation.AndroidLocationException {
        if (sdkHandler.getLocation() == null) {
            throw new AndroidLocation.AndroidLocationException("Local SDK path not set!");
        }
        Table<String, FileOp, WeakReference<AvdManager>> table = mManagers;
        synchronized (table) {
            AvdManager manager;
            WeakReference ref = (WeakReference)mManagers.get((Object)sdkHandler.getLocation().getPath(), (Object)fop);
            if (ref != null && (manager = (AvdManager)ref.get()) != null) {
                return manager;
            }
            try {
                manager = new AvdManager(sdkHandler, log, fop);
            }
            catch (AndroidLocation.AndroidLocationException e) {
                throw e;
            }
            catch (Exception e) {
                log.error((Throwable)e, "Exception during AvdManager initialization!", new Object[0]);
                return null;
            }
            mManagers.put((Object)sdkHandler.getLocation().getPath(), (Object)fop, new WeakReference<AvdManager>(manager));
            return manager;
        }
    }

    public String getBaseAvdFolder() throws AndroidLocation.AndroidLocationException {
        assert (AndroidLocation.getFolder().endsWith(File.separator));
        return AndroidLocation.getFolder() + "avd";
    }

    public static long parseSdcardSize(String sdcard, String[] parsedStrings) {
        Matcher m;
        if (parsedStrings != null) {
            assert (parsedStrings.length == 2);
            parsedStrings[0] = null;
            parsedStrings[1] = null;
        }
        if ((m = SDCARD_SIZE_PATTERN.matcher(sdcard)).matches()) {
            if (parsedStrings != null) {
                assert (parsedStrings.length == 2);
                parsedStrings[0] = m.group(1);
                parsedStrings[1] = m.group(2);
            }
            try {
                long sdcardSize = Long.parseLong(m.group(1));
                String sdcardSizeModifier = m.group(2);
                if ("K".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 10;
                } else if ("M".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 20;
                } else if ("G".equals(sdcardSizeModifier)) {
                    sdcardSize <<= 30;
                }
                if (sdcardSize < 0x900000L || sdcardSize > 0xFFC0000000L) {
                    return 0L;
                }
                return sdcardSize;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getAllAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            return this.mAllAvdList.toArray(new AvdInfo[this.mAllAvdList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getValidAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mValidAvdList == null) {
                ArrayList<AvdInfo> list = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() != AvdInfo.AvdStatus.OK) continue;
                    list.add(avd);
                }
                this.mValidAvdList = list.toArray(new AvdInfo[list.size()]);
            }
            return this.mValidAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo[] getBrokenAvds() {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mBrokenAvdList == null) {
                ArrayList<AvdInfo> list = new ArrayList<AvdInfo>();
                for (AvdInfo avd : this.mAllAvdList) {
                    if (avd.getStatus() == AvdInfo.AvdStatus.OK) continue;
                    list.add(avd);
                }
                this.mBrokenAvdList = list.toArray(new AvdInfo[list.size()]);
            }
            return this.mBrokenAvdList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo getAvd(String name, boolean validAvdOnly) {
        boolean ignoreCase;
        boolean bl = ignoreCase = SdkConstants.currentPlatform() == 2;
        if (validAvdOnly) {
            for (AvdInfo info : this.getValidAvds()) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                return info;
            }
        } else {
            ArrayList<AvdInfo> arrayList = this.mAllAvdList;
            synchronized (arrayList) {
                for (AvdInfo info : this.mAllAvdList) {
                    String name2 = info.getName();
                    if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public boolean isAvdRunning(AvdInfo info, ILogger logger) {
        String pid;
        try {
            pid = this.getAvdPid(info);
        }
        catch (IOException e) {
            logger.error((Throwable)e, "IOException while getting PID", new Object[0]);
            return true;
        }
        if (pid != null) {
            String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"tasklist /FI \"PID eq " + pid + "\" | findstr " + pid + "\"" : "kill -0 " + pid;
            try {
                Process p = Runtime.getRuntime().exec(command);
                return p.waitFor() == 0;
            }
            catch (IOException e) {
                logger.warning("Got IOException while checking running processes:\n%s", new Object[]{Arrays.toString(e.getStackTrace())});
                return true;
            }
            catch (InterruptedException e) {
                logger.warning("Got InterruptedException while checking running processes:\n%s", new Object[]{Arrays.toString(e.getStackTrace())});
                return true;
            }
        }
        return false;
    }

    public void stopAvd(AvdInfo info) {
        try {
            String pid = this.getAvdPid(info);
            if (pid != null) {
                String command = SdkConstants.currentPlatform() == 2 ? "cmd /c \"taskkill /PID " + pid + "\"" : "kill " + pid;
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    p.waitFor();
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String getAvdPid(AvdInfo info) throws IOException {
        File f = new File(info.getDataFolderPath(), "userdata-qemu.img.lock");
        if (SdkConstants.currentPlatform() == 2) {
            f = new File(f, "pid");
        }
        if (this.mFop.exists(f)) {
            return this.mFop.toString(f, Charsets.UTF_8).trim();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<AvdConflict, String> isAvdNameConflicting(String name) {
        boolean ignoreCase = SdkConstants.currentPlatform() == 2;
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            for (AvdInfo info : this.mAllAvdList) {
                String name2 = info.getName();
                if (!name2.equals(name) && (!ignoreCase || !name2.equalsIgnoreCase(name))) continue;
                if (info.getStatus() == AvdInfo.AvdStatus.OK) {
                    return Pair.of((Object)((Object)AvdConflict.CONFLICT_EXISTING_AVD), (Object)name2);
                }
                return Pair.of((Object)((Object)AvdConflict.CONFLICT_INVALID_AVD), (Object)name2);
            }
        }
        try {
            File file = AvdInfo.getDefaultIniFile(this, name);
            if (this.mFop.exists(file)) {
                return Pair.of((Object)((Object)AvdConflict.CONFLICT_EXISTING_PATH), (Object)file.getPath());
            }
            file = AvdInfo.getDefaultAvdFolder(this, name, this.mFop, false);
            if (this.mFop.exists(file)) {
                return Pair.of((Object)((Object)AvdConflict.CONFLICT_EXISTING_PATH), (Object)file.getPath());
            }
        }
        catch (AndroidLocation.AndroidLocationException androidLocationException) {
            // empty catch block
        }
        return Pair.of((Object)((Object)AvdConflict.NO_CONFLICT), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAvds(ILogger log) throws AndroidLocation.AndroidLocationException {
        ArrayList<AvdInfo> allList = new ArrayList<AvdInfo>();
        this.buildAvdList(allList, log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.clear();
            this.mAllAvdList.addAll(allList);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AvdInfo reloadAvd(AvdInfo avdInfo, ILogger log) throws AndroidLocation.AndroidLocationException {
        AvdInfo newInfo = this.parseAvdInfo(avdInfo.getIniFile(), log);
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            int index = this.mAllAvdList.indexOf(avdInfo);
            if (index >= 0) {
                this.replaceAvd(avdInfo, newInfo);
            }
        }
        return newInfo;
    }

    /*
     * Exception decompiling
     */
    public AvdInfo createAvd(File avdFolder, String avdName, ISystemImage systemImage, File skinFolder, String skinName, String sdcard, Map<String, String> hardwareConfig, Map<String, String> bootProps, boolean createSnapshot, boolean removePrevious, boolean editExisting, ILogger log) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void copyImageFile(File source, File destination) throws FileNotFoundException, IOException {
        int count;
        InputStream fis = this.mFop.newFileInputStream(source);
        OutputStream fos = this.mFop.newFileOutputStream(destination);
        byte[] buffer = new byte[4096];
        while ((count = fis.read(buffer)) != -1) {
            fos.write(buffer, 0, count);
        }
        fos.close();
        fis.close();
    }

    private String getImageRelativePath(ISystemImage systemImage) throws InvalidTargetPathException {
        String[] list;
        String sdkLocation;
        File folder = systemImage.getLocation();
        String imageFullPath = folder.getAbsolutePath();
        if (!imageFullPath.startsWith(sdkLocation = this.mSdkHandler.getLocation().getPath())) {
            assert (false);
            throw new InvalidTargetPathException("Target location is not inside the SDK.");
        }
        if (this.mFop.isDirectory(folder) && (list = this.mFop.list(folder, new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return IMAGE_NAME_PATTERN.matcher(name).matches();
            }
        })).length > 0) {
            if ((imageFullPath = imageFullPath.substring(sdkLocation.length())).charAt(0) == File.separatorChar) {
                imageFullPath = imageFullPath.substring(1);
            }
            if (!imageFullPath.endsWith(File.separator)) {
                imageFullPath = imageFullPath + File.separator;
            }
            return imageFullPath;
        }
        return null;
    }

    private File createAvdIniFile(String name, File avdFolder, boolean removePrevious, AndroidVersion version) throws AndroidLocation.AndroidLocationException, IOException {
        File iniFile = AvdInfo.getDefaultIniFile(this, name);
        if (removePrevious) {
            if (this.mFop.isFile(iniFile)) {
                this.mFop.delete(iniFile);
            } else if (this.mFop.isDirectory(iniFile)) {
                this.deleteContentOf(iniFile);
                this.mFop.delete(iniFile);
            }
        }
        String absPath = avdFolder.getAbsolutePath();
        String relPath = null;
        String androidPath = AndroidLocation.getFolder();
        if (absPath.startsWith(androidPath)) {
            assert (androidPath.endsWith(File.separator));
            relPath = absPath.substring(androidPath.length());
        }
        HashMap<String, String> values = new HashMap<String, String>();
        if (relPath != null) {
            values.put(AVD_INFO_REL_PATH, relPath);
        }
        values.put(AVD_INFO_ABS_PATH, absPath);
        values.put(AVD_INFO_TARGET, AndroidTargetHash.getPlatformHashString(version));
        this.writeIniFile(iniFile, values, true);
        return iniFile;
    }

    private File createAvdIniFile(AvdInfo info) throws AndroidLocation.AndroidLocationException, IOException {
        return this.createAvdIniFile(info.getName(), new File(info.getDataFolderPath()), false, info.getAndroidVersion());
    }

    public boolean deleteAvd(AvdInfo avdInfo, ILogger log) {
        try {
            String path;
            boolean error = false;
            File f = avdInfo.getIniFile();
            if (f != null && this.mFop.exists(f)) {
                log.info("Deleting file %1$s\n", new Object[]{f.getCanonicalPath()});
                if (!this.mFop.delete(f)) {
                    log.error(null, "Failed to delete %1$s\n", new Object[]{f.getCanonicalPath()});
                    error = true;
                }
            }
            if ((path = avdInfo.getDataFolderPath()) != null && this.mFop.exists(f = new File(path))) {
                log.info("Deleting folder %1$s\n", new Object[]{f.getCanonicalPath()});
                if (!this.deleteContentOf(f) || !this.mFop.delete(f)) {
                    log.error(null, "Failed to delete %1$s\n", new Object[]{f.getCanonicalPath()});
                    error = true;
                }
            }
            this.removeAvd(avdInfo);
            if (!error) {
                log.info("\nAVD '%1$s' deleted.\n", new Object[]{avdInfo.getName()});
                return true;
            }
            log.info("\nAVD '%1$s' deleted with errors. See errors above.\n", new Object[]{avdInfo.getName()});
        }
        catch (IOException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        catch (SecurityException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        return false;
    }

    public boolean moveAvd(AvdInfo avdInfo, String newName, String paramFolderPath, ILogger log) {
        try {
            if (paramFolderPath != null) {
                File f = new File(avdInfo.getDataFolderPath());
                log.warning("Moving '%1$s' to '%2$s'.", new Object[]{avdInfo.getDataFolderPath(), paramFolderPath});
                if (!this.mFop.renameTo(f, new File(paramFolderPath))) {
                    log.error(null, "Failed to move '%1$s' to '%2$s'.", new Object[]{avdInfo.getDataFolderPath(), paramFolderPath});
                    return false;
                }
                AvdInfo info = new AvdInfo(avdInfo.getName(), avdInfo.getIniFile(), paramFolderPath, avdInfo.getSystemImage(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
                this.createAvdIniFile(info);
            }
            if (newName != null) {
                File oldIniFile = avdInfo.getIniFile();
                File newIniFile = AvdInfo.getDefaultIniFile(this, newName);
                log.warning("Moving '%1$s' to '%2$s'.", new Object[]{oldIniFile.getPath(), newIniFile.getPath()});
                if (!this.mFop.renameTo(oldIniFile, newIniFile)) {
                    log.error(null, "Failed to move '%1$s' to '%2$s'.", new Object[]{oldIniFile.getPath(), newIniFile.getPath()});
                    return false;
                }
                AvdInfo info = new AvdInfo(newName, avdInfo.getIniFile(), avdInfo.getDataFolderPath(), avdInfo.getSystemImage(), avdInfo.getProperties());
                this.replaceAvd(avdInfo, info);
            }
            log.info("AVD '%1$s' moved.\n", new Object[]{avdInfo.getName()});
        }
        catch (AndroidLocation.AndroidLocationException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        catch (IOException e) {
            log.error((Throwable)e, null, new Object[0]);
        }
        return true;
    }

    private boolean deleteContentOf(File folder) throws SecurityException {
        File[] files = this.mFop.listFiles(folder);
        if (files != null) {
            for (File f : files) {
                if (this.mFop.isDirectory(f) && !this.deleteContentOf(f)) {
                    return false;
                }
                if (this.mFop.delete(f)) continue;
                return false;
            }
        }
        return true;
    }

    private File[] buildAvdFilesList() throws AndroidLocation.AndroidLocationException {
        File folder = new File(this.getBaseAvdFolder());
        if (this.mFop.isFile(folder)) {
            throw new AndroidLocation.AndroidLocationException(String.format("%1$s is not a valid folder.", folder.getAbsolutePath()));
        }
        if (!this.mFop.exists(folder)) {
            this.mFop.mkdirs(folder);
            return null;
        }
        File[] avds = this.mFop.listFiles(folder, new FilenameFilter(){

            @Override
            public boolean accept(File parent, String name) {
                if (INI_NAME_PATTERN.matcher(name).matches()) {
                    return AvdManager.this.mFop.isFile(new File(parent, name));
                }
                return false;
            }
        });
        return avds;
    }

    private void buildAvdList(ArrayList<AvdInfo> allList, ILogger log) throws AndroidLocation.AndroidLocationException {
        File[] avds = this.buildAvdFilesList();
        if (avds != null) {
            for (File avd : avds) {
                AvdInfo info = this.parseAvdInfo(avd, log);
                if (info == null || allList.contains(info)) continue;
                allList.add(info);
            }
        }
    }

    private DeviceManager getDeviceManager(ILogger logger) {
        DeviceManager manager = this.mDeviceManagers.get(logger);
        if (manager == null) {
            manager = DeviceManager.createInstance(this.mSdkHandler.getLocation(), logger);
            manager.registerListener(new DeviceManager.DevicesChangedListener(){

                @Override
                public void onDevicesChanged() {
                    AvdManager.this.mDeviceManagers.clear();
                }
            });
            this.mDeviceManagers.put(logger, manager);
        }
        return manager;
    }

    private AvdInfo parseAvdInfo(File iniPath, ILogger log) {
        String targetHash;
        AndroidVersion version;
        String relPath;
        Map<String, String> map = AvdManager.parseIniFile(new FileOpFileWrapper(iniPath, this.mFop, false), log);
        String avdPath = map.get(AVD_INFO_ABS_PATH);
        if (!(avdPath != null && this.mFop.isDirectory(new File(avdPath)) || (relPath = map.get(AVD_INFO_REL_PATH)) == null)) {
            try {
                String androidPath = AndroidLocation.getFolder();
                File f = new File(androidPath, relPath);
                if (this.mFop.isDirectory(f)) {
                    avdPath = f.getAbsolutePath();
                }
            }
            catch (AndroidLocation.AndroidLocationException androidPath) {
                // empty catch block
            }
        }
        FileOpFileWrapper configIniFile = null;
        HashMap properties = null;
        LoggerProgressIndicatorWrapper progress = new LoggerProgressIndicatorWrapper(log);
        if (avdPath != null) {
            configIniFile = new FileOpFileWrapper(new File(avdPath, CONFIG_INI), this.mFop, false);
        }
        if (configIniFile != null) {
            if (!configIniFile.exists()) {
                log.warning("Missing file '%1$s'.", new Object[]{configIniFile.getOsLocation()});
            } else {
                properties = AvdManager.parseIniFile(configIniFile, log);
            }
        }
        String name = iniPath.getName();
        Matcher matcher = INI_NAME_PATTERN.matcher(iniPath.getName());
        if (matcher.matches()) {
            name = matcher.group(1);
        }
        boolean validImageSysdir = true;
        String imageSysDir = null;
        ISystemImage sysImage = null;
        if (properties != null && (imageSysDir = properties.get(AVD_INI_IMAGES_1)) != null) {
            sysImage = this.mSdkHandler.getSystemImageManager((ProgressIndicator)progress).getImageAt(new File(this.mSdkHandler.getLocation(), imageSysDir));
        }
        DeviceManager.DeviceStatus deviceStatus = null;
        boolean updateHashV2 = false;
        if (properties != null) {
            String deviceName = properties.get(AVD_INI_DEVICE_NAME);
            String deviceMfctr = properties.get(AVD_INI_DEVICE_MANUFACTURER);
            if (deviceName != null && deviceMfctr != null) {
                DeviceManager devMan = this.getDeviceManager(log);
                Device d = devMan.getDevice(deviceName, deviceMfctr);
                DeviceManager.DeviceStatus deviceStatus2 = deviceStatus = d == null ? DeviceManager.DeviceStatus.MISSING : DeviceManager.DeviceStatus.EXISTS;
                if (d != null) {
                    String hashV1;
                    updateHashV2 = true;
                    String hashV2 = (String)properties.get(AVD_INI_DEVICE_HASH_V2);
                    if (hashV2 != null) {
                        String newHashV2 = DeviceManager.hasHardwarePropHashChanged(d, hashV2);
                        if (newHashV2 == null) {
                            updateHashV2 = false;
                        } else {
                            properties.put(AVD_INI_DEVICE_HASH_V2, newHashV2);
                        }
                    }
                    if ((hashV1 = (String)properties.get(AVD_INI_DEVICE_HASH_V1)) != null) {
                        properties.remove(AVD_INI_DEVICE_HASH_V1);
                    }
                }
            }
        }
        AvdInfo.AvdStatus status = avdPath == null ? AvdInfo.AvdStatus.ERROR_PATH : (configIniFile == null ? AvdInfo.AvdStatus.ERROR_CONFIG : (properties == null || imageSysDir == null ? AvdInfo.AvdStatus.ERROR_PROPERTIES : (!validImageSysdir ? AvdInfo.AvdStatus.ERROR_IMAGE_DIR : (deviceStatus == DeviceManager.DeviceStatus.CHANGED ? AvdInfo.AvdStatus.ERROR_DEVICE_CHANGED : (deviceStatus == DeviceManager.DeviceStatus.MISSING ? AvdInfo.AvdStatus.ERROR_DEVICE_MISSING : (sysImage == null ? AvdInfo.AvdStatus.ERROR_IMAGE_MISSING : AvdInfo.AvdStatus.OK))))));
        if (properties == null) {
            properties = Maps.newHashMap();
        }
        if (!properties.containsKey(AVD_INI_ANDROID_API) && !properties.containsKey(AVD_INI_ANDROID_CODENAME) && (version = AndroidTargetHash.getVersionFromHash(targetHash = map.get(AVD_INFO_TARGET))) != null) {
            properties.put(AVD_INI_ANDROID_API, Integer.toString(version.getApiLevel()));
            if (version.getCodename() != null) {
                properties.put(AVD_INI_ANDROID_CODENAME, version.getCodename());
            }
        }
        AvdInfo info = new AvdInfo(name, iniPath, avdPath, sysImage, properties, status);
        if (updateHashV2) {
            try {
                return this.updateDeviceChanged(info, log);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeIniFile(File iniFile, Map<String, String> values, boolean addEncoding) throws IOException {
        Charset charset = Charsets.UTF_8;
        OutputStreamWriter writer = new OutputStreamWriter(this.mFop.newFileOutputStream(iniFile), charset);
        try {
            if (addEncoding) {
                writer.write(String.format("%1$s=%2$s\n", AVD_INI_ENCODING, charset.name()));
            }
            ArrayList<String> keys = new ArrayList<String>(values.keySet());
            keys.remove(AVD_INI_ANDROID_API);
            keys.remove(AVD_INI_ANDROID_CODENAME);
            Collections.sort(keys);
            for (String key : keys) {
                String value = values.get(key);
                if (value == null) continue;
                writer.write(String.format("%1$s=%2$s\n", key, value));
            }
        }
        finally {
            writer.close();
        }
    }

    public static Map<String, String> parseIniFile(IAbstractFile propFile, ILogger log) {
        return AvdManager.parseIniFileImpl(propFile, log, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> parseIniFileImpl(IAbstractFile propFile, ILogger log, Charset charset) {
        reader = null;
        try {
            canChangeCharset = false;
            if (charset == null) {
                canChangeCharset = true;
                charset = Charsets.ISO_8859_1;
            }
            reader = new BufferedReader(new InputStreamReader(propFile.getContents(), charset));
            line = null;
            map = new HashMap<String, String>();
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                m = AvdManager.INI_LINE_PATTERN.matcher(line);
                if (m.matches()) {
                    key = m.group(1);
                    value = m.group(2);
                    if (canChangeCharset && "avd.ini.encoding".equals(key) && !charset.name().equals(value) && Charset.isSupported(value)) {
                        charset = Charset.forName(value);
                        var10_18 = AvdManager.parseIniFileImpl(propFile, log, charset);
                        try {
                            Closeables.close((Closeable)reader, (boolean)true);
                            return var10_18;
                        }
                        catch (IOException var11_19) {
                            // empty catch block
                        }
                        return var10_18;
                    }
                    map.put(key, value);
                    continue;
                }
                if (log != null) {
                    log.warning("Error parsing '%1$s': \"%2$s\" is not a valid syntax", new Object[]{propFile.getOsLocation(), line});
                }
                var8_14 = null;
                try {
                    Closeables.close((Closeable)reader, (boolean)true);
                    return var8_14;
                }
                catch (IOException var9_17) {
                    // empty catch block
                }
                return var8_14;
            }
            var7_13 = map;
            ** try [egrp 5[TRYBLOCK] [2 : 252->260)] { 
        }
        catch (FileNotFoundException canChangeCharset) {
            try {
                Closeables.close(reader, (boolean)true);
                return null;
            }
            catch (IOException canChangeCharset) {
                return null;
            }
        }
        catch (IOException e) {
            if (log == null) return null;
            log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
            return null;
            {
                catch (Throwable var12_20) {
                    throw var12_20;
                }
            }
            catch (StreamException e) {
                if (log == null) return null;
                log.warning("Error parsing '%1$s': %2$s.", new Object[]{propFile.getOsLocation(), e.getMessage()});
                return null;
            }
        }
        finally {
            try {
                Closeables.close(reader, (boolean)true);
            }
            catch (IOException e) {}
        }
lbl-1000:
        // 1 sources

        {
            Closeables.close((Closeable)reader, (boolean)true);
            return var7_13;
        }
lbl41:
        // 1 sources

        catch (IOException var8_15) {
            // empty catch block
        }
        return var7_13;
    }

    protected boolean createSdCard(String toolLocation, String size, String location, ILogger log) {
        try {
            String[] command = new String[]{toolLocation, size, location};
            Process process = Runtime.getRuntime().exec(command);
            final ArrayList errorOutput = new ArrayList();
            final ArrayList stdOutput = new ArrayList();
            int status = GrabProcessOutput.grabProcessOutput((Process)process, (GrabProcessOutput.Wait)GrabProcessOutput.Wait.WAIT_FOR_READERS, (GrabProcessOutput.IProcessOutput)new GrabProcessOutput.IProcessOutput(){

                public void out(String line) {
                    if (line != null) {
                        stdOutput.add(line);
                    }
                }

                public void err(String line) {
                    if (line != null) {
                        errorOutput.add(line);
                    }
                }
            });
            if (status == 0) {
                return true;
            }
            for (String error : errorOutput) {
                log.error(null, error, new Object[0]);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.error(null, "Failed to create the SD card.", new Object[0]);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAvd(AvdInfo avdInfo) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            if (this.mAllAvdList.remove(avdInfo)) {
                this.mBrokenAvdList = null;
                this.mValidAvdList = null;
                return true;
            }
        }
        return false;
    }

    public AvdInfo updateAvd(AvdInfo avd, Map<String, String> newProperties, AvdInfo.AvdStatus status, ILogger log) throws IOException {
        File configIniFile = new File(avd.getDataFolderPath(), CONFIG_INI);
        this.writeIniFile(configIniFile, newProperties, true);
        AvdInfo newAvd = new AvdInfo(avd.getName(), avd.getIniFile(), avd.getDataFolderPath(), avd.getSystemImage(), newProperties);
        this.replaceAvd(avd, newAvd);
        return newAvd;
    }

    public AvdInfo updateDeviceChanged(AvdInfo avd, ILogger log) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>(avd.getProperties());
        DeviceManager devMan = this.getDeviceManager(log);
        Collection<Device> devices = devMan.getDevices(DeviceManager.ALL_DEVICES);
        String name = (String)properties.get(AVD_INI_DEVICE_NAME);
        String manufacturer = (String)properties.get(AVD_INI_DEVICE_MANUFACTURER);
        if (properties != null && devices != null && name != null && manufacturer != null) {
            for (Device d : devices) {
                if (!d.getId().equals(name) || !d.getManufacturer().equals(manufacturer)) continue;
                properties.putAll(DeviceManager.getHardwareProperties(d));
                try {
                    return this.updateAvd(avd, properties, AvdInfo.AvdStatus.OK, log);
                }
                catch (IOException e) {
                    log.error((Throwable)e, null, new Object[0]);
                }
            }
        } else {
            log.error(null, "Base device information incomplete or missing.", new Object[0]);
        }
        return null;
    }

    private boolean setImagePathProperties(ISystemImage image, Map<String, String> properties, ILogger log) {
        properties.remove(AVD_INI_IMAGES_1);
        properties.remove(AVD_INI_IMAGES_2);
        try {
            String property = AVD_INI_IMAGES_1;
            String imagePath = this.getImageRelativePath(image);
            if (imagePath != null) {
                properties.put(property, imagePath);
                return true;
            }
            return false;
        }
        catch (InvalidTargetPathException e) {
            log.error((Throwable)e, e.getMessage(), new Object[0]);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceAvd(AvdInfo oldAvd, AvdInfo newAvd) {
        ArrayList<AvdInfo> arrayList = this.mAllAvdList;
        synchronized (arrayList) {
            this.mAllAvdList.remove(oldAvd);
            this.mAllAvdList.add(newAvd);
            this.mBrokenAvdList = null;
            this.mValidAvdList = null;
        }
    }

    @Deprecated
    public AndroidSdkHandler getSdkHandler() {
        return this.mSdkHandler;
    }

    public static enum AvdConflict {
        NO_CONFLICT,
        CONFLICT_EXISTING_AVD,
        CONFLICT_INVALID_AVD,
        CONFLICT_EXISTING_PATH;

    }

    private static final class InvalidTargetPathException
    extends Exception {
        private static final long serialVersionUID = 1L;

        InvalidTargetPathException(String message) {
            super(message);
        }
    }
}

