/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.MessageLite;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelGroupFuture;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32FrameDecoder;
import io.netty.handler.codec.protobuf.ProtobufVarint32LengthFieldPrepender;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.java.JavaCompilingTool;
import org.jetbrains.jps.cmdline.ClasspathBootstrap;
import org.jetbrains.jps.incremental.GlobalContextKey;
import org.jetbrains.jps.javac.DiagnosticOutputConsumer;
import org.jetbrains.jps.javac.ExternalJavacMessageHandler;
import org.jetbrains.jps.javac.ExternalJavacProcess;
import org.jetbrains.jps.javac.JavacProtoUtil;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.OutputFileConsumer;
import org.jetbrains.jps.javac.PlainMessageDiagnostic;
import org.jetbrains.jps.service.SharedThreadPool;

public class ExternalJavacManager {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.javac.ExternalJavacServer");
    public static final GlobalContextKey<ExternalJavacManager> KEY = GlobalContextKey.create("_external_javac_server_");
    public static final int DEFAULT_SERVER_PORT = 7878;
    public static final String STDOUT_LINE_PREFIX = "JAVAC_PROCESS[STDOUT]";
    public static final String STDERR_LINE_PREFIX = "JAVAC_PROCESS[STDERR]";
    private static final AttributeKey<JavacProcessDescriptor> SESSION_DESCRIPTOR = AttributeKey.valueOf((String)"ExternalJavacServer.JavacProcessDescriptor");
    @NotNull
    private final File myWorkingDir;
    @NotNull
    private final ChannelRegistrar myChannelRegistrar;
    private final Map<UUID, JavacProcessDescriptor> myMessageHandlers;
    private int myListenPort;

    public ExternalJavacManager(@NotNull File workingDir) {
        if (workingDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "workingDir", "org/jetbrains/jps/javac/ExternalJavacManager", "<init>"));
        }
        this.myMessageHandlers = new HashMap<UUID, JavacProcessDescriptor>();
        this.myListenPort = 7878;
        this.myWorkingDir = workingDir;
        this.myChannelRegistrar = new ChannelRegistrar();
    }

    @NotNull
    public File getWorkingDir() {
        File file = this.myWorkingDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ExternalJavacManager", "getWorkingDir"));
        }
        return file;
    }

    public void start(int listenPort) {
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(1, (Executor)SharedThreadPool.getInstance())).channel(NioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        CompilationRequestsHandler compilationRequestsHandler = new CompilationRequestsHandler();
        bootstrap.childHandler((ChannelHandler)new ChannelInitializer((ChannelHandler)compilationRequestsHandler){
            final /* synthetic */ ChannelHandler val$compilationRequestsHandler;
            {
                this.val$compilationRequestsHandler = channelHandler;
            }

            protected void initChannel(Channel channel) throws Exception {
                channel.pipeline().addLast(new ChannelHandler[]{ExternalJavacManager.this.myChannelRegistrar, new ProtobufVarint32FrameDecoder(), new ProtobufDecoder((MessageLite)JavacRemoteProto.Message.getDefaultInstance()), new ProtobufVarint32LengthFieldPrepender(), new ProtobufEncoder(), this.val$compilationRequestsHandler});
            }
        });
        try {
            InetAddress loopback = InetAddress.getByName(null);
            this.myChannelRegistrar.add(bootstrap.bind(loopback, listenPort).syncUninterruptibly().channel());
            this.myListenPort = listenPort;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean forkJavac(String javaHome, int heapSize, List<String> vmOptions, List<String> options, Collection<File> platformCp, Collection<File> classpath, Collection<File> sourcePath, Collection<File> files, Map<File, Set<File>> outs, final DiagnosticOutputConsumer diagnosticSink, OutputFileConsumer outputSink, JavaCompilingTool compilingTool, CanceledStatus cancelStatus) {
        ExternalJavacMessageHandler rh = new ExternalJavacMessageHandler(diagnosticSink, outputSink, ExternalJavacManager.getEncodingName(options));
        JavacRemoteProto.Message.Request request = JavacProtoUtil.createCompilationRequest(options, files, classpath, platformCp, sourcePath, outs);
        UUID uuid = UUID.randomUUID();
        JavacProcessDescriptor processDescriptor = new JavacProcessDescriptor(uuid, rh, request);
        Map<UUID, JavacProcessDescriptor> map = this.myMessageHandlers;
        synchronized (map) {
            this.myMessageHandlers.put(uuid, processDescriptor);
        }
        try {
            ExternalJavacProcessHandler processHandler = this.launchExternalJavacProcess(uuid, javaHome, heapSize, this.myListenPort, this.myWorkingDir, vmOptions, compilingTool);
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void onTextAvailable(ProcessEvent event, Key outputType) {
                    String text = event.getText();
                    if (!StringUtil.isEmptyOrSpaces((String)text)) {
                        String prefix = null;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            prefix = ExternalJavacManager.STDOUT_LINE_PREFIX;
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            prefix = ExternalJavacManager.STDERR_LINE_PREFIX;
                        }
                        if (prefix != null) {
                            diagnosticSink.outputLineAvailable(prefix + ": " + text);
                        }
                    }
                }
            });
            processHandler.startNotify();
            while (!processDescriptor.waitFor(300L)) {
                if (processHandler.isProcessTerminated() && processDescriptor.channel == null && processHandler.getExitCode() != 0) {
                    processDescriptor.setDone();
                    break;
                }
                if (!cancelStatus.isCanceled()) continue;
                processDescriptor.cancelBuild();
            }
            boolean bl = rh.isTerminatedSuccessfully();
            return bl;
        }
        catch (Throwable e) {
            LOG.info(e);
            diagnosticSink.report(new PlainMessageDiagnostic(Diagnostic.Kind.ERROR, e.getMessage()));
        }
        finally {
            this.unregisterMessageHandler(uuid);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterMessageHandler(UUID uuid) {
        JavacProcessDescriptor descriptor;
        Map<UUID, JavacProcessDescriptor> map = this.myMessageHandlers;
        synchronized (map) {
            descriptor = this.myMessageHandlers.remove(uuid);
        }
        if (descriptor != null) {
            descriptor.setDone();
        }
    }

    @Nullable
    private static String getEncodingName(List<String> options) {
        boolean found = false;
        for (String option : options) {
            if (found) {
                return option;
            }
            if (!"-encoding".equalsIgnoreCase(option)) continue;
            found = true;
        }
        return null;
    }

    public void stop() {
        this.myChannelRegistrar.close().awaitUninterruptibly();
    }

    private ExternalJavacProcessHandler launchExternalJavacProcess(UUID uuid, String sdkHomePath, int heapSize, int port, File workingDir, List<String> vmOptions, JavaCompilingTool compilingTool) throws Exception {
        String region;
        String country;
        String lang;
        String encoding;
        ArrayList<String> cmdLine = new ArrayList<String>();
        ExternalJavacManager.appendParam(cmdLine, ExternalJavacManager.getVMExecutablePath(sdkHomePath));
        ExternalJavacManager.appendParam(cmdLine, "-Djava.awt.headless=true");
        if (heapSize > 0) {
            int xms = heapSize / 2;
            if (xms > 32) {
                ExternalJavacManager.appendParam(cmdLine, "-Xms" + xms + "m");
            }
            ExternalJavacManager.appendParam(cmdLine, "-Xmx" + heapSize + "m");
        }
        if ((encoding = System.getProperty("file.encoding")) != null) {
            ExternalJavacManager.appendParam(cmdLine, "-Dfile.encoding=" + encoding);
        }
        if ((lang = System.getProperty("user.language")) != null) {
            ExternalJavacManager.appendParam(cmdLine, "-Duser.language=" + lang);
        }
        if ((country = System.getProperty("user.country")) != null) {
            ExternalJavacManager.appendParam(cmdLine, "-Duser.country=" + country);
        }
        if ((region = System.getProperty("user.region")) != null) {
            ExternalJavacManager.appendParam(cmdLine, "-Duser.region=" + region);
        }
        ExternalJavacManager.appendParam(cmdLine, "-Djps.java.compiling.tool=" + compilingTool.getId());
        ExternalJavacManager.appendParam(cmdLine, "-Djava.ext.dirs=");
        ExternalJavacManager.appendParam(cmdLine, "-Dlog4j.defaultInitOverride=true");
        for (String option : vmOptions) {
            ExternalJavacManager.appendParam(cmdLine, option);
        }
        ExternalJavacManager.appendParam(cmdLine, "-classpath");
        List<File> cp = ClasspathBootstrap.getExternalJavacProcessClasspath(sdkHomePath, compilingTool);
        StringBuilder classpath = new StringBuilder();
        for (File file : cp) {
            if (classpath.length() > 0) {
                classpath.append(File.pathSeparator);
            }
            classpath.append(file.getPath());
        }
        ExternalJavacManager.appendParam(cmdLine, classpath.toString());
        ExternalJavacManager.appendParam(cmdLine, ExternalJavacProcess.class.getName());
        ExternalJavacManager.appendParam(cmdLine, uuid.toString());
        ExternalJavacManager.appendParam(cmdLine, "127.0.0.1");
        ExternalJavacManager.appendParam(cmdLine, Integer.toString(port));
        workingDir.mkdirs();
        ExternalJavacManager.appendParam(cmdLine, FileUtil.toSystemIndependentName((String)workingDir.getPath()));
        ProcessBuilder builder = new ProcessBuilder(cmdLine);
        builder.directory(workingDir);
        Process process = builder.start();
        return this.createProcessHandler(process, StringUtil.join(cmdLine, (String)" "));
    }

    protected ExternalJavacProcessHandler createProcessHandler(@NotNull Process process, @NotNull String commandLine) {
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/jps/javac/ExternalJavacManager", "createProcessHandler"));
        }
        if (commandLine == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/jetbrains/jps/javac/ExternalJavacManager", "createProcessHandler"));
        }
        return new ExternalJavacProcessHandler(process, commandLine);
    }

    private static void appendParam(List<String> cmdLine, String param) {
        if (SystemInfo.isWindows) {
            if (param.contains("\"")) {
                param = StringUtil.replace((String)param, (String)"\"", (String)"\\\"");
            } else if (param.length() == 0) {
                param = "\"\"";
            }
        }
        cmdLine.add(param);
    }

    private static String getVMExecutablePath(String sdkHome) {
        return sdkHome + "/bin/java";
    }

    private static class JavacProcessDescriptor {
        @NotNull
        final UUID sessionId;
        @NotNull
        final ExternalJavacMessageHandler handler;
        volatile JavacRemoteProto.Message.Request request;
        volatile Channel channel;
        private final Semaphore myDone;

        public JavacProcessDescriptor(@NotNull UUID sessionId, @NotNull ExternalJavacMessageHandler handler, @NotNull JavacRemoteProto.Message.Request request) {
            if (sessionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionId", "org/jetbrains/jps/javac/ExternalJavacManager$JavacProcessDescriptor", "<init>"));
            }
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "org/jetbrains/jps/javac/ExternalJavacManager$JavacProcessDescriptor", "<init>"));
            }
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/jps/javac/ExternalJavacManager$JavacProcessDescriptor", "<init>"));
            }
            this.myDone = new Semaphore();
            this.sessionId = sessionId;
            this.handler = handler;
            this.request = request;
            this.myDone.down();
        }

        public void cancelBuild() {
            if (this.channel != null) {
                this.channel.writeAndFlush((Object)JavacProtoUtil.toMessage(this.sessionId, JavacProtoUtil.createCancelRequest()));
            }
        }

        public void setDone() {
            this.myDone.up();
        }

        public boolean waitFor(long timeout) {
            return this.myDone.waitFor(timeout);
        }
    }

    @ChannelHandler.Sharable
    private static final class ChannelRegistrar
    extends ChannelInboundHandlerAdapter {
        private final ChannelGroup openChannels = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);

        private ChannelRegistrar() {
        }

        public boolean isEmpty() {
            return this.openChannels.isEmpty();
        }

        public void add(@NotNull Channel serverChannel) {
            if (serverChannel == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverChannel", "org/jetbrains/jps/javac/ExternalJavacManager$ChannelRegistrar", "add"));
            }
            assert (serverChannel instanceof ServerChannel);
            this.openChannels.add((Object)serverChannel);
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            this.openChannels.add((Object)context.channel());
            super.channelActive(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelGroupFuture close() {
            ChannelGroupFuture future;
            EventLoopGroup eventLoopGroup = null;
            for (Channel channel : this.openChannels) {
                if (!(channel instanceof ServerChannel)) continue;
                eventLoopGroup = channel.eventLoop().parent();
                break;
            }
            try {
                future = this.openChannels.close();
            }
            finally {
                assert (eventLoopGroup != null);
                eventLoopGroup.shutdownGracefully(0L, 15L, TimeUnit.SECONDS);
            }
            return future;
        }
    }

    @ChannelHandler.Sharable
    private class CompilationRequestsHandler
    extends SimpleChannelInboundHandler<JavacRemoteProto.Message> {
        private CompilationRequestsHandler() {
        }

        public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
            JavacProcessDescriptor descriptor = (JavacProcessDescriptor)ctx.channel().attr(SESSION_DESCRIPTOR).getAndRemove();
            if (descriptor != null) {
                descriptor.setDone();
            }
            super.channelUnregistered(ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void channelRead0(ChannelHandlerContext context, JavacRemoteProto.Message message) throws Exception {
            UUID sessionId;
            JavacProcessDescriptor descriptor = (JavacProcessDescriptor)context.channel().attr(SESSION_DESCRIPTOR).get();
            if (descriptor == null) {
                sessionId = JavacProtoUtil.fromProtoUUID(message.getSessionId());
                descriptor = (JavacProcessDescriptor)ExternalJavacManager.this.myMessageHandlers.get(sessionId);
                if (descriptor != null) {
                    descriptor.channel = context.channel();
                    context.channel().attr(SESSION_DESCRIPTOR).set((Object)descriptor);
                }
            } else {
                sessionId = descriptor.sessionId;
            }
            ExternalJavacMessageHandler handler = descriptor != null ? descriptor.handler : null;
            JavacRemoteProto.Message.Type messageType = message.getMessageType();
            JavacRemoteProto.Message reply = null;
            try {
                if (messageType == JavacRemoteProto.Message.Type.RESPONSE) {
                    JavacRemoteProto.Message.Response response = message.getResponse();
                    JavacRemoteProto.Message.Response.Type responseType = response.getResponseType();
                    if (handler != null) {
                        if (responseType == JavacRemoteProto.Message.Response.Type.REQUEST_ACK) {
                            JavacRemoteProto.Message.Request request = descriptor.request;
                            if (request != null) {
                                reply = JavacProtoUtil.toMessage(sessionId, request);
                                descriptor.request = null;
                            }
                        } else {
                            boolean terminateOk = handler.handleMessage((MessageLite)message);
                            if (terminateOk) {
                                descriptor.setDone();
                            }
                        }
                    } else {
                        reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createCancelRequest());
                    }
                } else {
                    reply = JavacProtoUtil.toMessage(sessionId, JavacProtoUtil.createFailure("Unsupported message: " + messageType.name(), null));
                }
                if (reply == null) return;
            }
            catch (Throwable throwable) {
                if (reply == null) throw throwable;
                context.channel().writeAndFlush(reply);
                throw throwable;
            }
            context.channel().writeAndFlush((Object)reply);
        }
    }

    protected static class ExternalJavacProcessHandler
    extends BaseOSProcessHandler {
        private volatile int myExitCode;

        protected ExternalJavacProcessHandler(@NotNull Process process, @NotNull String commandLine) {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler", "<init>"));
            }
            if (commandLine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLine", "org/jetbrains/jps/javac/ExternalJavacManager$ExternalJavacProcessHandler", "<init>"));
            }
            super(process, commandLine, null);
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(ProcessEvent event) {
                    ExternalJavacProcessHandler.this.myExitCode = event.getExitCode();
                }
            });
        }

        public int getExitCode() {
            return this.myExitCode;
        }
    }
}

