/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemInfo
extends SystemInfoRt {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isOS2 = SystemInfoRt.isOS2;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isAppleJvm = SystemInfo.isAppleJvm();
    public static final boolean isOracleJvm = SystemInfo.isOracleJvm();
    public static final boolean isSunJvm = SystemInfo.isSunJvm();
    public static final boolean isIbmJvm = SystemInfo.isIbmJvm();
    public static final boolean isJetbrainsJvm = SystemInfo.isJetbrainsJvm();
    public static final boolean isWin2kOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.0");
    public static final boolean isWinXpOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.1");
    public static final boolean isWinVistaOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.0");
    public static final boolean isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
    public static final boolean isWin8OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.2");
    public static final boolean isXWindow = isUnix && !isMac;
    public static final boolean isKDE = !StringUtil.isEmpty(System.getenv("KDE_FULL_SESSION"));
    private static final NotNullLazyValue<Map<String, String>> ourOsReleaseInfo = new AtomicNotNullLazyValue<Map<String, String>>(){

        @Override
        @NotNull
        protected Map<String, String> compute() {
            if (isUnix && !isMac) {
                HashMap<String, String> hashMap;
                try {
                    List<String> lines = FileUtil.loadLines("/etc/os-release");
                    HashMap<String, String> info = ContainerUtil.newHashMap();
                    for (String line : lines) {
                        int p = line.indexOf(61);
                        if (p <= 0) continue;
                        String name = line.substring(0, p);
                        String value = StringUtil.unquoteString(line.substring(p + 1));
                        if (StringUtil.isEmptyOrSpaces(name) || StringUtil.isEmptyOrSpaces(value)) continue;
                        info.put(name, value);
                    }
                    hashMap = info;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo$1", "compute"));
                }
                return hashMap;
            }
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo$1", "compute"));
            }
            return map;
        }
    };
    public static final boolean isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
    public static final boolean isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
    public static final boolean areSymLinksSupported = isUnix || isWinVistaOrNewer;
    public static final boolean is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
    public static final boolean is64Bit = !is32Bit;
    public static final boolean isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen = new AtomicNotNullLazyValue<Boolean>(){

        @Override
        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/xdg-open").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo$2", "compute"));
            }
            return bl;
        }
    };
    private static final NotNullLazyValue<Boolean> ourHasXdgMime = new AtomicNotNullLazyValue<Boolean>(){

        @Override
        @NotNull
        protected Boolean compute() {
            Boolean bl = new File("/usr/bin/xdg-mime").canExecute();
            if (bl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo$3", "compute"));
            }
            return bl;
        }
    };
    public static final boolean isMacOSTiger = isMac && SystemInfo.isOsVersionAtLeast("10.4");
    public static final boolean isMacOSLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.5");
    public static final boolean isMacOSSnowLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.6");
    public static final boolean isMacOSLion = isMac && SystemInfo.isOsVersionAtLeast("10.7");
    public static final boolean isMacOSMountainLion = isMac && SystemInfo.isOsVersionAtLeast("10.8");
    public static final boolean isMacOSMavericks = isMac && SystemInfo.isOsVersionAtLeast("10.9");
    public static final boolean isMacOSYosemite = isMac && SystemInfo.isOsVersionAtLeast("10.10");
    public static final boolean isMacOSElCapitan = isMac && SystemInfo.isOsVersionAtLeast("10.11");
    public static final boolean isWindowsXP = isWindows && (OS_VERSION.equals("5.1") || OS_VERSION.equals("5.2"));
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);

    public static boolean isOsVersionAtLeast(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "isOsVersionAtLeast"));
        }
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    @Nullable
    public static String getUnixReleaseName() {
        return ourOsReleaseInfo.getValue().get("NAME");
    }

    @Nullable
    public static String getUnixReleaseVersion() {
        return ourOsReleaseInfo.getValue().get("VERSION");
    }

    public static boolean hasXdgOpen() {
        return isXWindow && ourHasXdgOpen.getValue() != false;
    }

    public static boolean hasXdgMime() {
        return isXWindow && ourHasXdgMime.getValue() != false;
    }

    @NotNull
    public static String getMacOSMajorVersion() {
        String string = SystemInfo.getMacOSMajorVersion(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersion"));
        }
        return string;
    }

    public static String getMacOSMajorVersion(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%d.%d", parts[0], parts[1]);
    }

    @NotNull
    public static String getMacOSVersionCode() {
        String string = SystemInfo.getMacOSVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode() {
        String string = SystemInfo.getMacOSMajorVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode() {
        String string = SystemInfo.getMacOSMinorVersionCode(OS_VERSION);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMinorVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionCode"));
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), SystemInfo.normalize(parts[2]));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMajorVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersionCode"));
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), 0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMajorVersionCode"));
        }
        return string;
    }

    @NotNull
    public static String getMacOSMinorVersionCode(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSMinorVersionCode"));
        }
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        String string = String.format("%02d%02d", parts[1], parts[2]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/SystemInfo", "getMacOSMinorVersionCode"));
        }
        return string;
    }

    private static int[] getMacOSVersionParts(@NotNull String version) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "com/intellij/openapi/util/SystemInfo", "getMacOSVersionParts"));
        }
        List<String> parts = StringUtil.split(version, ".");
        while (parts.size() < 3) {
            parts.add("0");
        }
        return new int[]{SystemInfo.toInt(parts.get(0)), SystemInfo.toInt(parts.get(1)), SystemInfo.toInt(parts.get(2))};
    }

    private static int normalize(int number) {
        return number > 9 ? 9 : number;
    }

    private static int toInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean isOracleJvm() {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Oracle");
    }

    private static boolean isSunJvm() {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Sun") && StringUtil.containsIgnoreCase(vendor, "Microsystems");
    }

    private static boolean isIbmJvm() {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "IBM");
    }

    private static boolean isAppleJvm() {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Apple");
    }

    private static boolean isJetbrainsJvm() {
        String vendor = SystemProperties.getJavaVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "jetbrains");
    }
}

