/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.lang.aspectj.build.AjAspectPathIndex;
import com.intellij.lang.aspectj.build.AjBuilderBase;
import com.intellij.lang.aspectj.build.AjCompilerMessageHandler;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjCompilerSettings;
import com.intellij.lang.aspectj.build.config.AjJpsModuleSettings;
import com.intellij.lang.aspectj.build.config.AjModuleSettings;
import com.intellij.lang.aspectj.build.config.AjPathEntries;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajdt.ajc.BuildArgParser;
import org.aspectj.ajdt.internal.compiler.ICompilerAdapter;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.core.builder.AjBuildConfig;
import org.aspectj.ajdt.internal.core.builder.AjBuildManager;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.org.eclipse.jdt.internal.compiler.ClassFile;
import org.aspectj.org.eclipse.jdt.internal.compiler.CompilationResult;
import org.aspectj.org.eclipse.jdt.internal.compiler.Compiler;
import org.aspectj.org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.impl.BuildTargetChunk;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleType;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;

public class AjJpsCompiler {
    private static final Object ourLock = new Object();
    private static final Set<ModuleChunk> ourChunksToRebuild = Collections.synchronizedSet(ContainerUtil.newHashSet());
    private final CompileContext myContext;
    private final AjAspectPathIndex myIndex;
    private final ModuleChunk myChunk;
    private final List<File> myToCompile;
    private final ModuleBuildTarget myTarget;
    private final AjCompilerSettings myCompilerSettings;
    private final ModuleLevelBuilder.OutputConsumer myOutputConsumer;
    private final AjModuleSettings myModuleSettings;

    public AjJpsCompiler(@NotNull CompileContext context, @NotNull AjAspectPathIndex index, @NotNull ModuleChunk chunk, @NotNull List<File> toCompile, @NotNull ModuleBuildTarget target, @NotNull AjCompilerSettings settings, @NotNull ModuleLevelBuilder.OutputConsumer consumer) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (toCompile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toCompile", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/lang/aspectj/build/AjJpsCompiler", "<init>"));
        }
        this.myContext = context;
        this.myIndex = index;
        this.myChunk = chunk;
        this.myToCompile = toCompile;
        this.myTarget = target;
        this.myCompilerSettings = settings;
        this.myOutputConsumer = consumer;
        this.myModuleSettings = AjJpsModuleSettings.getSettings(target.getModule());
    }

    public ModuleLevelBuilder.ExitCode build() throws ProjectBuildException, IOException {
        this.myContext.processMessage((BuildMessage)new ProgressMessage(AjJpsBundle.message("aj.progress.loading", new Object[0])));
        if (this.myToCompile.isEmpty()) {
            HashMap outputMap = ContainerUtil.newHashMap();
            this.processOutput(outputMap);
        } else {
            String targetDir;
            MyAjBuildManager manager;
            AjCompilerMessageHandler mh;
            boolean aspectsChanged;
            Map<String, Long> current;
            Map<String, Long> lastUsed;
            boolean fullBuild;
            boolean bl = fullBuild = this.myContext.getScope().isBuildForced((BuildTarget)this.myTarget) || ourChunksToRebuild.remove(this.myChunk);
            if (!fullBuild && !(lastUsed = this.getLastUsedAspectPath()).equals(current = this.getCurrentAspectPath())) {
                AjBuilderBase.LOG.debug("aspect path changed, rebuilding chunk");
                ourChunksToRebuild.add(this.myChunk);
                return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
            }
            List<String> command = this.getCommand();
            if (AjBuilderBase.LOG.isDebugEnabled()) {
                AjBuilderBase.LOG.debug("command: " + command);
            }
            if (aspectsChanged = AjJpsCompiler.doBuild(mh = new AjCompilerMessageHandler(this.myContext, command.contains("-showWeaveInfo")), manager = new MyAjBuildManager((IMessageHandler)mh, this.myContext, fullBuild, targetDir = AjBuilderBase.getTargetDir(this.myTarget)), ArrayUtil.toStringArray(command))) {
                AjBuilderBase.LOG.debug("aspect update detected, rebuilding chunk");
                ourChunksToRebuild.add(this.myChunk);
                return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
            }
            this.processOutput(manager.myOutputMap);
            boolean nextPass = false;
            if (fullBuild && !this.myTarget.isTests()) {
                String name = this.myTarget.getModule().getName();
                long oldHash = this.myIndex.getSelfHash(name);
                Map<String, Long> hashes = this.getCurrentAspectPath();
                long newHash = AjJpsCompiler.computeHash(manager.myAspects, manager.myOutputMap);
                hashes.put("", newHash);
                this.myIndex.update(name, hashes);
                if (newHash != oldHash) {
                    nextPass = this.forceRebuildDependent(name);
                }
            }
            if (mh.hasErrors()) {
                return ModuleLevelBuilder.ExitCode.ABORT;
            }
            if (nextPass) {
                return ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED;
            }
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    private Map<String, Long> getLastUsedAspectPath() throws IOException {
        HashMap hashes = ContainerUtil.newHashMap();
        Map state = (Map)this.myIndex.getState(this.myTarget.getModule().getName());
        if (state != null) {
            for (Map.Entry entry : state.entrySet()) {
                if (((String)entry.getKey()).isEmpty()) continue;
                hashes.put(entry.getKey(), entry.getValue());
            }
        }
        return hashes;
    }

    private Map<String, Long> getCurrentAspectPath() throws IOException {
        HashMap hashes = ContainerUtil.newHashMap();
        if (this.myModuleSettings != null) {
            for (AjPathEntries.Entry entry : this.myModuleSettings.aspectPath) {
                JpsModule module;
                if (!(entry instanceof AjPathEntries.ModuleEntry) || (module = (JpsModule)((AjPathEntries.ModuleEntry)entry).resolve()) == null || !(module.getModuleType() instanceof JpsJavaModuleType)) continue;
                String name = module.getName();
                hashes.put(name, this.myIndex.getSelfHash(name));
            }
        }
        return hashes;
    }

    private List<String> getCommand() {
        List<String> aspectPath;
        ArrayList command = ContainerUtilRt.newArrayList();
        AjCompilerSettings.addFilteredCompilerOptions(command, this.myCompilerSettings);
        ProcessorConfigProfile profile = null;
        if (this.myCompilerSettings.aptOptionsEnabled) {
            JpsProject project = this.myContext.getProjectDescriptor().getProject();
            JpsJavaCompilerConfiguration compilerConfig = JpsJavaExtensionService.getInstance().getCompilerConfiguration(project);
            Set modules = this.myChunk.getModules();
            if (compilerConfig != null && modules.size() == 1) {
                JpsModule module = (JpsModule)modules.iterator().next();
                profile = compilerConfig.getAnnotationProcessingProfile(module);
            }
        }
        JavaBuilder.addCompilationOptions((List)command, (CompileContext)this.myContext, (ModuleChunk)this.myChunk, profile);
        command.add("-verbose");
        command.add("-d");
        command.add(AjBuilderBase.getTargetDir(this.myTarget));
        List<String> classPath = AjBuilderBase.getClassPath(this.myChunk);
        if (!this.myCompilerSettings.ajcPath.isEmpty()) {
            classPath.add(this.myCompilerSettings.ajcPath);
        }
        if (!classPath.isEmpty()) {
            command.add("-classpath");
            command.add(StringUtil.join(classPath, (String)File.pathSeparator));
        }
        if (!(aspectPath = AjBuilderBase.getAspectPath(this.myTarget, this.myModuleSettings)).isEmpty()) {
            command.add("-aspectpath");
            command.add(StringUtil.join(aspectPath, (String)File.pathSeparator));
        }
        for (File file : this.myToCompile) {
            command.add(file.getPath());
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doBuild(AjCompilerMessageHandler mh, MyAjBuildManager manager, String[] args) throws ProjectBuildException, IOException {
        BuildArgParser parser = new BuildArgParser((IMessageHandler)mh);
        AjBuildConfig config = parser.genBuildConfig(args);
        if (mh.hasErrors()) {
            throw new ProjectBuildException("Internal error: bad args");
        }
        if (!config.hasSources()) {
            throw new ProjectBuildException("Internal error: no sources");
        }
        config.setGenerateModelMode(true);
        Object object = ourLock;
        synchronized (object) {
            manager.batchBuild(config, (IMessageHandler)mh);
        }
        return manager.myRebuildRequested;
    }

    private void processOutput(Map<String, Collection<String>> map) throws IOException {
        JavaBuilderUtil.registerFilesToCompile((CompileContext)this.myContext, this.myToCompile);
        Callbacks.Backend callback = JavaBuilderUtil.getDependenciesRegistrar((CompileContext)this.myContext);
        for (Map.Entry<String, Collection<String>> entry : map.entrySet()) {
            String srcPath = entry.getKey();
            File srcFile = new File(srcPath);
            JavaBuilderUtil.registerSuccessfullyCompiled((CompileContext)this.myContext, (File)srcFile);
            for (String outPath : entry.getValue()) {
                File outFile = new File(outPath);
                byte[] bytes = FileUtil.loadFileBytes((File)outFile);
                FailSafeClassReader reader = new FailSafeClassReader(bytes);
                CompiledClass compiledClass = new CompiledClass(outFile, srcFile, AjJpsCompiler.readClassName((ClassReader)reader), new BinaryContent(bytes));
                this.myOutputConsumer.registerCompiledClass((BuildTarget)this.myTarget, compiledClass);
                try {
                    callback.associate(outPath, srcPath, (ClassReader)reader);
                }
                catch (Throwable e) {
                    String message = "Class dependency information may be incomplete! Error parsing generated class " + outPath;
                    AjBuilderBase.LOG.info(message, e);
                    this.myContext.processMessage((BuildMessage)new CompilerMessage("ajc", BuildMessage.Kind.WARNING, message + "\n" + CompilerMessage.getTextFromThrowable((Throwable)e), srcPath));
                }
            }
        }
    }

    private static long computeHash(List<String> aspects, Map<String, Collection<String>> map) {
        long hash = 0L;
        for (String aspect : aspects) {
            Collection<String> classFiles = map.get(aspect);
            if (classFiles == null) continue;
            for (String classFile : classFiles) {
                hash = hash * 31L + (long)classFile.hashCode();
                File file = new File(classFile);
                hash = hash * 31L + file.lastModified();
                hash = hash * 31L + file.length();
            }
        }
        return hash;
    }

    private boolean forceRebuildDependent(String name) throws IOException {
        HashSet toRebuild = ContainerUtil.newHashSet();
        for (JpsModule module : this.myContext.getProjectDescriptor().getProject().getModules()) {
            AjModuleSettings settings = AjJpsModuleSettings.getSettings(module);
            if (settings == null) continue;
            for (AjPathEntries.Entry entry : settings.aspectPath) {
                if (!(entry instanceof AjPathEntries.ModuleEntry) || !name.equals(entry.getName())) continue;
                toRebuild.add(module);
            }
        }
        boolean rebuild = false;
        if (!toRebuild.isEmpty()) {
            for (BuildTargetChunk chunk : this.myContext.getProjectDescriptor().getBuildTargetIndex().getSortedTargetChunks(this.myContext)) {
                for (BuildTarget target : chunk.getTargets()) {
                    JpsModule module;
                    if (!(target instanceof ModuleBuildTarget) || !toRebuild.contains(module = ((ModuleBuildTarget)target).getModule())) continue;
                    FSOperations.markDirty((CompileContext)this.myContext, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)new ModuleChunk(Collections.singleton((ModuleBuildTarget)target)), null);
                    rebuild = true;
                }
            }
        }
        return rebuild;
    }

    private static String readClassName(ClassReader reader) {
        final Ref nameRef = Ref.create();
        reader.accept(new ClassVisitor(327680){

            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                nameRef.set((Object)name.replace('/', '.'));
            }
        }, 7);
        return (String)nameRef.get();
    }

    private static class DelegatingCompilerRequestor
    implements ICompilerRequestor {
        private final ICompilerRequestor delegate;

        public DelegatingCompilerRequestor(ICompilerRequestor delegate) {
            this.delegate = delegate;
        }

        public void acceptResult(CompilationResult result) {
            this.delegate.acceptResult(result);
        }
    }

    private static class DelegatingCompilerAdapter
    implements ICompilerAdapter {
        private final ICompilerAdapter delegate;

        public DelegatingCompilerAdapter(ICompilerAdapter original) {
            this.delegate = original;
        }

        public void afterDietParsing(CompilationUnitDeclaration[] units) {
            this.delegate.afterDietParsing(units);
        }

        public void beforeCompiling(ICompilationUnit[] sourceUnits) {
            this.delegate.beforeCompiling(sourceUnits);
        }

        public void afterCompiling(CompilationUnitDeclaration[] units) {
            this.delegate.afterCompiling(units);
        }

        public void beforeProcessing(CompilationUnitDeclaration unit) {
            this.delegate.beforeProcessing(unit);
        }

        public void afterProcessing(CompilationUnitDeclaration unit, int unitIndex) {
            this.delegate.afterProcessing(unit, unitIndex);
        }

        public void beforeResolving(CompilationUnitDeclaration unit) {
            this.delegate.beforeResolving(unit);
        }

        public void afterResolving(CompilationUnitDeclaration unit) {
            this.delegate.afterResolving(unit);
        }

        public void beforeAnalysing(CompilationUnitDeclaration unit) {
            this.delegate.beforeAnalysing(unit);
        }

        public void afterAnalysing(CompilationUnitDeclaration unit) {
            this.delegate.afterAnalysing(unit);
        }

        public void beforeGenerating(CompilationUnitDeclaration unit) {
            this.delegate.beforeGenerating(unit);
        }

        public void afterGenerating(CompilationUnitDeclaration unit) {
            this.delegate.afterGenerating(unit);
        }
    }

    private static class MyAjBuildManager
    extends AjBuildManager {
        private static final String ASPECT_ANNO_NAME = "Aspect";
        private static final String ASPECT_ANNO_SIG = "L" + Aspect.class.getName().replace('.', '/') + ";";
        private final CompileContext myContext;
        private final boolean myFullBuild;
        private final String myTargetDir;
        private boolean myRebuildRequested = false;
        private final List<String> myAspects = ContainerUtil.newSmartList();
        private final Map<String, Collection<String>> myOutputMap = ContainerUtil.newHashMap();

        public MyAjBuildManager(IMessageHandler handler, CompileContext context, boolean fullBuild, String targetDir) {
            super(handler);
            this.myContext = context;
            this.myFullBuild = fullBuild;
            this.myTargetDir = targetDir;
        }

        public ICompilerAdapter getAdapter(Compiler forCompiler) {
            return new DelegatingCompilerAdapter(super.getAdapter(forCompiler)){

                @Override
                public void afterDietParsing(CompilationUnitDeclaration[] units) {
                    super.afterDietParsing(units);
                    if (!MyAjBuildManager.this.myFullBuild) {
                        if (MyAjBuildManager.containAspect(units[0].types)) {
                            MyAjBuildManager.this.myRebuildRequested = true;
                            throw new AbortCompilation();
                        }
                    } else {
                        for (CompilationUnitDeclaration unit : units) {
                            if (!MyAjBuildManager.containAspect(unit.types)) break;
                            MyAjBuildManager.this.myAspects.add(FileUtil.toSystemIndependentName((String)new String(unit.getFileName())));
                        }
                    }
                }

                @Override
                public void beforeProcessing(CompilationUnitDeclaration unit) {
                    String name = new File(new String(unit.getFileName())).getName();
                    MyAjBuildManager.this.myContext.processMessage((BuildMessage)new ProgressMessage(AjJpsBundle.message("aj.progress.compiling", name)));
                    super.beforeProcessing(unit);
                }
            };
        }

        public ICompilerRequestor getBatchRequestor() {
            return new DelegatingCompilerRequestor(super.getBatchRequestor()){

                @Override
                public void acceptResult(CompilationResult result) {
                    if (result != null && !result.hasErrors()) {
                        List targets = ContainerUtil.newSmartList();
                        for (ClassFile file : result.getClassFiles()) {
                            targets.add(FileUtil.toSystemIndependentName((String)(MyAjBuildManager.this.myTargetDir + "/" + new String(file.fileName()) + ".class")));
                        }
                        MyAjBuildManager.this.myOutputMap.put(FileUtil.toSystemIndependentName((String)new String(result.getFileName())), targets);
                    }
                    super.acceptResult(result);
                }
            };
        }

        private static boolean containAspect(TypeDeclaration[] types) {
            if (types != null) {
                for (TypeDeclaration type : types) {
                    if (!MyAjBuildManager.isAspect(type) && !MyAjBuildManager.containAspect(type.memberTypes)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean isAspect(TypeDeclaration type) {
            if (type instanceof AspectDeclaration) {
                return true;
            }
            if (type.annotations != null) {
                for (Annotation annotation : type.annotations) {
                    TypeBinding resolved;
                    if (!MyAjBuildManager.equals(annotation.type.getLastToken(), ASPECT_ANNO_NAME) || (resolved = annotation.resolvedType) == null || !MyAjBuildManager.equals(resolved.signature(), ASPECT_ANNO_SIG)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean equals(char[] chars, String string) {
            if (chars == null || chars.length != string.length()) {
                return false;
            }
            for (int i = 0; i < chars.length; ++i) {
                if (chars[i] == string.charAt(i)) continue;
                return false;
            }
            return true;
        }
    }
}

