package aQute.jpm.facade.repo;

import java.net.*;
import java.util.*;

import aQute.service.library.*;
import aQute.service.library.Library.Revision;
import aQute.service.library.Library.RevisionRef;

public interface JpmRepo {

	/**
	 * Get a Program from its coordinates
	 * 
	 * @param auth
	 */
	Library.Program getProgram(String groupId, String artifactId) throws Exception;

	/**
	 * Get a Program from query
	 */
	List<Library.Program> getQueryPrograms(String query, int skip, int limit) throws Exception;

	/**
	 * Get a revision by group,artifact,class,version
	 * 
	 * @param auth
	 * @throws Exception
	 */

	Revision getRevisionByCoordinate(Coordinate coordinate) throws Exception;

	/**
	 * Get a revision by group,artifact,class,version
	 * 
	 * @param coordinate
	 * @return a sorted list of revisions
	 * @throws Exception
	 */

	List<Revision> getRevisionsByCoordinate(Coordinate coordinate) throws Exception;

	/**
	 * Get a revision by its sha
	 * 
	 * @param auth
	 * @throws Exception
	 */

	Revision getRevision(byte[] sha) throws Exception;

	/**
	 * Create a revisions object. The given object is guaranteed to exist after
	 * this method is called.
	 * 
	 * @param revisions
	 * @throws Exception
	 */
	Revisions createRevisions(Revisions revisions) throws Exception;

	List<RevisionRef> getClosure(byte[] revision, boolean b) throws Exception;

	/**
	 * Provide a writeable URL for a deposit
	 * 
	 * @param depositoryGroup
	 * @param depositoryName
	 * @param path
	 * @return
	 * @throws Exception
	 */
	URI depository(String depositoryGroup, String depositoryName) throws Exception;

	Revisions getRevisions(byte[] revisions) throws Exception;

}