/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.repository.Revision;
import com.android.repository.io.FileOp;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

public class PackageParserUtils {
    public static Revision getRevisionProperty(Properties props, String propKey) {
        String revStr = PackageParserUtils.getProperty(props, propKey, null);
        Revision rev = null;
        if (revStr != null) {
            try {
                rev = Revision.parseRevision((String)revStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rev;
    }

    public static String getProperty(Properties props, String propKey, String defaultValue) {
        if (props == null) {
            return defaultValue;
        }
        return props.getProperty(propKey, defaultValue);
    }

    public static List<File> parseSkinFolder(File skinRootFolder, FileOp fileOp) {
        if (fileOp.isDirectory(skinRootFolder)) {
            File[] files;
            ArrayList<File> skinList = new ArrayList<File>();
            for (File skinFolder : files = fileOp.listFiles(skinRootFolder)) {
                File layout;
                if (!fileOp.isDirectory(skinFolder) || !fileOp.isFile(layout = new File(skinFolder, "layout"))) continue;
                skinList.add(skinFolder);
            }
            Collections.sort(skinList);
            return skinList;
        }
        return Collections.emptyList();
    }
}

