/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.internal;

import com.springsource.util.osgi.manifest.BundleSymbolicName;
import com.springsource.util.osgi.manifest.internal.BaseParameterised;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;

class StandardBundleSymbolicName
extends BaseParameterised
implements BundleSymbolicName {
    StandardBundleSymbolicName(HeaderParser parser) {
        super(parser);
    }

    HeaderDeclaration parse(HeaderParser parser, String parseString) {
        return parser.parseBundleSymbolicName(parseString);
    }

    public BundleSymbolicName.FragmentAttachment getFragmentAttachment() {
        String value = this.getDirectives().get("fragment-attachment");
        if ("never".equals(value)) {
            return BundleSymbolicName.FragmentAttachment.NEVER;
        }
        if ("resolve-time".equals(value)) {
            return BundleSymbolicName.FragmentAttachment.RESOLVE_TIME;
        }
        return BundleSymbolicName.FragmentAttachment.ALWAYS;
    }

    public String getSymbolicName() {
        return this.name;
    }

    public boolean isSingleton() {
        return Boolean.valueOf(this.getDirectives().get("singleton"));
    }

    public void setFragmentAttachment(BundleSymbolicName.FragmentAttachment fragmentAttachment) {
        switch (fragmentAttachment) {
            case NEVER: {
                this.getDirectives().put("fragment-attachment", "never");
                break;
            }
            case RESOLVE_TIME: {
                this.getDirectives().put("fragment-attachment", "resolve-time");
                break;
            }
            default: {
                this.getDirectives().remove("fragment-attachment");
            }
        }
    }

    public void setSingleton(boolean singleton) {
        this.getDirectives().put("singleton", Boolean.toString(singleton));
    }

    public void setSymbolicName(String symbolicName) {
        this.name = symbolicName;
    }
}

