/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.conversion;

import com.intellij.openapi.util.InvalidDataException;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractIdeaSpecificSettings<T, C, SdkType> {
    public void readIdeaSpecific(@NotNull Element root, T model, @Nullable SdkType projectSdkType, @Nullable Map<String, String> levels) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/idea/eclipse/conversion/AbstractIdeaSpecificSettings", "readIdeaSpecific"));
        }
        this.expandElement(root, model);
        this.readLanguageLevel(root, model);
        this.setupCompilerOutputs(root, model);
        this.readContentEntry(root, model);
        this.setupJdk(root, model, projectSdkType);
        this.setupLibraryRoots(root, model);
        this.overrideModulesScopes(root, model);
        if (levels != null) {
            this.readLibraryLevels(root, levels);
        }
    }

    public void initLevels(Element root, T model, Map<String, String> levels) throws InvalidDataException {
        this.expandElement(root, model);
        this.readLanguageLevel(root, model);
        this.readLibraryLevels(root, levels);
    }

    public void updateEntries(Element root, T model, @Nullable SdkType projectSdkType) {
        this.setupJdk(root, model, projectSdkType);
        this.setupCompilerOutputs(root, model);
        this.readContentEntry(root, model);
    }

    private void readContentEntry(Element root, T model) {
        List entriesElements = root.getChildren("contentEntry");
        if (entriesElements.isEmpty()) {
            C[] entries = this.getEntries(model);
            if (entries.length > 0) {
                this.readContentEntry(root, entries[0], model);
            }
        } else {
            for (Element element : entriesElements) {
                this.readContentEntry(element, this.createContentEntry(model, element.getAttributeValue("url")), model);
            }
        }
    }

    protected void readLibraryLevels(Element root, @NotNull Map<String, String> levels) {
        if (levels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "levels", "org/jetbrains/idea/eclipse/conversion/AbstractIdeaSpecificSettings", "readLibraryLevels"));
        }
    }

    protected abstract C[] getEntries(T var1);

    protected abstract C createContentEntry(T var1, String var2);

    protected abstract void setupLibraryRoots(Element var1, T var2);

    protected abstract void setupJdk(Element var1, T var2, @Nullable SdkType var3);

    protected abstract void setupCompilerOutputs(Element var1, T var2);

    protected abstract void readLanguageLevel(Element var1, T var2);

    protected abstract void expandElement(Element var1, T var2);

    protected abstract void overrideModulesScopes(Element var1, T var2);

    public abstract void readContentEntry(Element var1, C var2, T var3);
}

