/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc.impl;

import com.intellij.flex.model.bc.JpsAirPackageEntry;
import com.intellij.flex.model.bc.JpsIosPackagingOptions;
import com.intellij.flex.model.bc.impl.JpsAirPackageEntryImpl;
import com.intellij.flex.model.bc.impl.JpsAirPackagingOptionsBase;
import com.intellij.flex.model.bc.impl.JpsAirSigningOptionsImpl;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

class JpsIosPackagingOptionsImpl
extends JpsAirPackagingOptionsBase<JpsIosPackagingOptionsImpl>
implements JpsIosPackagingOptions {
    static final JpsIosPackagingOptionsRole ROLE = new JpsIosPackagingOptionsRole();

    private JpsIosPackagingOptionsImpl() {
    }

    private JpsIosPackagingOptionsImpl(JpsAirPackagingOptionsBase<JpsIosPackagingOptionsImpl> original) {
        super(original);
    }

    @NotNull
    public JpsIosPackagingOptionsImpl createCopy() {
        JpsIosPackagingOptionsImpl jpsIosPackagingOptionsImpl = new JpsIosPackagingOptionsImpl(this);
        if (jpsIosPackagingOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsIosPackagingOptionsImpl", "createCopy"));
        }
        return jpsIosPackagingOptionsImpl;
    }

    State getState() {
        State state = new State();
        state.ENABLED = this.isEnabled();
        state.USE_GENERATED_DESCRIPTOR = this.isUseGeneratedDescriptor();
        state.CUSTOM_DESCRIPTOR_PATH = this.getCustomDescriptorPath();
        state.PACKAGE_FILE_NAME = this.getPackageFileName();
        for (JpsAirPackageEntry entry : this.getFilesToPackage()) {
            state.FILES_TO_PACKAGE.add(((JpsAirPackageEntryImpl)entry).getState());
        }
        state.SIGNING_OPTIONS = ((JpsAirSigningOptionsImpl)this.getSigningOptions()).getState();
        return state;
    }

    void loadState(@NotNull State state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/flex/model/bc/impl/JpsIosPackagingOptionsImpl", "loadState"));
        }
        this.setEnabled(state.ENABLED);
        this.setUseGeneratedDescriptor(state.USE_GENERATED_DESCRIPTOR);
        this.setCustomDescriptorPath(state.CUSTOM_DESCRIPTOR_PATH);
        this.setPackageFileName(state.PACKAGE_FILE_NAME);
        JpsElementCollection packageEntries = (JpsElementCollection)this.myContainer.getChild(JpsAirPackageEntryImpl.COLLECTION_ROLE);
        assert (packageEntries.getElements().isEmpty());
        for (JpsAirPackageEntryImpl.State f : state.FILES_TO_PACKAGE) {
            JpsAirPackageEntry entry = (JpsAirPackageEntry)JpsAirPackageEntryImpl.ROLE.create();
            ((JpsAirPackageEntryImpl)entry).loadState(f);
            packageEntries.addChild((JpsElement)entry);
        }
        ((JpsAirSigningOptionsImpl)this.getSigningOptions()).loadState(state.SIGNING_OPTIONS);
    }

    @Tag(value="packaging-ios")
    public static class State {
        @Attribute(value="enabled")
        public boolean ENABLED = false;
        @Attribute(value="use-generated-descriptor")
        public boolean USE_GENERATED_DESCRIPTOR = true;
        @Attribute(value="custom-descriptor-path")
        public String CUSTOM_DESCRIPTOR_PATH = "";
        @Attribute(value="package-file-name")
        public String PACKAGE_FILE_NAME = "";
        @Tag(value="files-to-package")
        @AbstractCollection(surroundWithTag=false)
        public List<JpsAirPackageEntryImpl.State> FILES_TO_PACKAGE = new ArrayList<JpsAirPackageEntryImpl.State>();
        @Property(surroundWithTag=false)
        public JpsAirSigningOptionsImpl.State SIGNING_OPTIONS = new JpsAirSigningOptionsImpl.State();
    }

    private static class JpsIosPackagingOptionsRole
    extends JpsElementChildRoleBase<JpsIosPackagingOptions>
    implements JpsElementCreator<JpsIosPackagingOptions> {
        public JpsIosPackagingOptionsRole() {
            super("ios packaging options");
        }

        @NotNull
        public JpsIosPackagingOptions create() {
            JpsIosPackagingOptionsImpl jpsIosPackagingOptionsImpl = new JpsIosPackagingOptionsImpl();
            if (jpsIosPackagingOptionsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsIosPackagingOptionsImpl$JpsIosPackagingOptionsRole", "create"));
            }
            return jpsIosPackagingOptionsImpl;
        }
    }
}

