/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.run;

import com.intellij.flex.model.bc.JpsFlexBuildConfiguration;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.module.JpsFlexModuleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsTypedModule;

public abstract class JpsBCBasedRunnerParameters<Self extends JpsBCBasedRunnerParameters<Self>>
extends JpsElementBase<Self> {
    @NotNull
    protected String myModuleName = "";
    @NotNull
    protected String myBCName = "";

    protected JpsBCBasedRunnerParameters() {
    }

    protected JpsBCBasedRunnerParameters(Self original) {
        this.myModuleName = ((JpsBCBasedRunnerParameters)((Object)original)).myModuleName;
        this.myBCName = ((JpsBCBasedRunnerParameters)((Object)original)).myBCName;
    }

    @NotNull
    public String getModuleName() {
        String string = this.myModuleName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsBCBasedRunnerParameters", "getModuleName"));
        }
        return string;
    }

    public void setModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/flex/model/run/JpsBCBasedRunnerParameters", "setModuleName"));
        }
        this.myModuleName = moduleName;
    }

    @NotNull
    public String getBCName() {
        String string = this.myBCName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/run/JpsBCBasedRunnerParameters", "getBCName"));
        }
        return string;
    }

    public void setBCName(@NotNull String BCName) {
        if (BCName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "BCName", "com/intellij/flex/model/run/JpsBCBasedRunnerParameters", "setBCName"));
        }
        this.myBCName = BCName;
    }

    public void applyChanges(@NotNull Self modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/flex/model/run/JpsBCBasedRunnerParameters", "applyChanges"));
        }
        this.myModuleName = ((JpsBCBasedRunnerParameters)((Object)modified)).myModuleName;
        this.myBCName = ((JpsBCBasedRunnerParameters)((Object)modified)).myBCName;
    }

    @Nullable
    public JpsFlexBuildConfiguration getBC(JpsProject project) {
        if (!this.myModuleName.isEmpty() && !this.myBCName.isEmpty()) {
            for (JpsTypedModule module : project.getModules((JpsModuleType)JpsFlexModuleType.INSTANCE)) {
                if (!module.getName().equals(this.myModuleName)) continue;
                return ((JpsFlexBuildConfigurationManager)module.getProperties()).findConfigurationByName(this.myBCName);
            }
        }
        return null;
    }
}

