/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.bundlor.support.contributors;

import com.springsource.bundlor.support.ManifestReader;
import com.springsource.bundlor.support.ManifestTemplateModifier;
import com.springsource.bundlor.support.PartialManifestModifier;
import com.springsource.bundlor.support.partialmanifest.ReadablePartialManifest;
import com.springsource.bundlor.util.SimpleParserLogger;
import com.springsource.util.osgi.manifest.parse.HeaderDeclaration;
import com.springsource.util.osgi.manifest.parse.HeaderParser;
import com.springsource.util.osgi.manifest.parse.HeaderParserFactory;
import com.springsource.util.parser.manifest.ManifestContents;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestTemplateDirectiveMigrator
implements ManifestReader,
ManifestTemplateModifier,
PartialManifestModifier {
    private volatile String importPackageString;
    private volatile String exportPackageString;
    private final List<HeaderDeclaration> importPackage = new ArrayList<HeaderDeclaration>();
    private final List<HeaderDeclaration> exportPackage = new ArrayList<HeaderDeclaration>();
    private final Object monitor = new Object();

    @Override
    public void readJarManifest(ManifestContents manifest) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readManifestTemplate(ManifestContents manifestTemplate) {
        Object object = this.monitor;
        synchronized (object) {
            this.importPackageString = manifestTemplate.getMainAttributes().get("Import-Package");
            this.importPackage.addAll(this.parseTemplate(this.importPackageString));
            this.exportPackageString = manifestTemplate.getMainAttributes().get("Export-Package");
            this.exportPackage.addAll(this.parseTemplate(this.exportPackageString));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ManifestContents manifestTemplate) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.importPackageString != null) {
                String importTemplateString = manifestTemplate.getMainAttributes().get("Import-Template");
                if (importTemplateString == null) {
                    manifestTemplate.getMainAttributes().put("Import-Template", this.importPackageString);
                } else {
                    manifestTemplate.getMainAttributes().put("Import-Template", String.format("%s,%s", importTemplateString, this.importPackageString));
                }
            }
            if (this.exportPackageString != null) {
                String exportTemplateString = manifestTemplate.getMainAttributes().get("Export-Template");
                if (exportTemplateString == null) {
                    manifestTemplate.getMainAttributes().put("Export-Template", this.exportPackageString);
                } else {
                    manifestTemplate.getMainAttributes().put("Export-Template", String.format("%s,%s", exportTemplateString, this.exportPackageString));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(ReadablePartialManifest partialManifest) {
        Object object = this.monitor;
        synchronized (object) {
            for (HeaderDeclaration header : this.importPackage) {
                partialManifest.recordReferencedPackage(header.getNames().get(0));
            }
            for (HeaderDeclaration header : this.exportPackage) {
                partialManifest.recordExportPackage(header.getNames().get(0));
            }
        }
    }

    private List<HeaderDeclaration> parseTemplate(String template) {
        if (StringUtils.hasText(template)) {
            HeaderParser parser = HeaderParserFactory.newHeaderParser(new SimpleParserLogger());
            return parser.parseHeader(template);
        }
        return new ArrayList<HeaderDeclaration>(0);
    }
}

