/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogUtil {
    private LogUtil() {
    }

    public static String objectAndClass(@Nullable Object o) {
        return o != null ? o + " (" + o.getClass().getName() + ")" : "null";
    }

    public static void debug(@NotNull Logger logger, @NonNls @NotNull String format, Object ... args) {
        if (logger == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/openapi/diagnostic/LogUtil", "debug"));
        }
        if (format == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "format", "com/intellij/openapi/diagnostic/LogUtil", "debug"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    public static String getProcessList() {
        try {
            String[] stringArray;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (SystemInfo.isWindows) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = System.getenv("windir") + "\\system32\\tasklist.exe";
                stringArray = stringArray2;
                stringArray2[1] = "/v";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "ps";
                stringArray = stringArray3;
                stringArray3[1] = "a";
            }
            Process process = processBuilder.command(stringArray).redirectErrorStream(true).start();
            return FileUtil.loadTextAndClose(process.getInputStream());
        }
        catch (IOException e) {
            return ExceptionUtil.getThrowableText(e);
        }
    }

    public static String getSystemMemoryInfo() {
        try {
            Process process = new ProcessBuilder(new String[0]).command(SystemInfo.isWindows ? "systeminfo" : (SystemInfo.isMac ? "vm_stat" : "free")).redirectErrorStream(true).start();
            return FileUtil.loadTextAndClose(process.getInputStream());
        }
        catch (IOException e) {
            return ExceptionUtil.getThrowableText(e);
        }
    }
}

