/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.ide.common.res2.DataFile;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.google.common.base.Objects;
import java.io.File;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ResourceFile
extends DataFile<ResourceItem> {
    static final String ATTR_QUALIFIER = "qualifiers";
    private String mQualifiers;
    private FolderConfiguration mFolderConfiguration;

    public ResourceFile(File file, ResourceItem item, String qualifiers, FolderConfiguration folderConfiguration) {
        super(file, DataFile.FileType.SINGLE_FILE);
        this.mQualifiers = qualifiers;
        this.mFolderConfiguration = folderConfiguration;
        this.init(item);
    }

    public ResourceFile(File file, List<ResourceItem> items, String qualifiers, FolderConfiguration folderConfiguration) {
        this(file, items, qualifiers, folderConfiguration, DataFile.FileType.XML_VALUES);
    }

    private ResourceFile(File file, List<ResourceItem> items, String qualifiers, FolderConfiguration folderConfiguration, DataFile.FileType fileType) {
        super(file, fileType);
        this.mQualifiers = qualifiers;
        this.mFolderConfiguration = folderConfiguration;
        this.init(items);
    }

    public static ResourceFile generatedFiles(File file, List<ResourceItem> items, String qualifiers, FolderConfiguration folderConfiguration) {
        return new ResourceFile(file, items, qualifiers, folderConfiguration, DataFile.FileType.GENERATED_FILES);
    }

    public static ResourceFile createSingle(File file, ResourceItem item, String qualifiers) {
        FolderConfiguration folderConfiguration = FolderConfiguration.getConfigForQualifierString(qualifiers);
        assert (folderConfiguration != null);
        return new ResourceFile(file, item, qualifiers, folderConfiguration);
    }

    public String getQualifiers() {
        return this.mQualifiers;
    }

    public void setQualifiers(String qualifiers) {
        this.mQualifiers = qualifiers;
        this.mFolderConfiguration = FolderConfiguration.getConfigForQualifierString(qualifiers);
    }

    public FolderConfiguration getFolderConfiguration() {
        return this.mFolderConfiguration;
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, namespaceUri, ATTR_QUALIFIER, this.getQualifiers());
        if (this.getType() == DataFile.FileType.GENERATED_FILES) {
            NodeUtils.addAttribute(document, node, namespaceUri, "preprocessing", "true");
        }
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("mFile", (Object)this.mFile).add("mQualifiers", (Object)this.mQualifiers).toString();
    }
}

