/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.meta;

import com.android.SdkConstants;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Objects;
import java.io.File;
import javax.xml.bind.annotation.XmlTransient;

@XmlTransient
public abstract class Library
implements IAndroidTarget.OptionalLibrary {
    @XmlTransient
    private File mPackagePath;

    public void setPackagePath(File packagePath) {
        this.mPackagePath = packagePath;
    }

    @Override
    public File getJar() {
        assert (this.mPackagePath != null);
        String localPath = this.getLocalJarPath();
        if (localPath == null) {
            return null;
        }
        localPath = localPath.replace('/', File.separatorChar);
        return new File(this.mPackagePath, SdkConstants.OS_ADDON_LIBS_FOLDER + localPath);
    }

    @Override
    public abstract String getName();

    @Override
    public abstract String getDescription();

    @Override
    public abstract boolean isManifestEntryRequired();

    public abstract void setLocalJarPath(String var1);

    public abstract void setDescription(String var1);

    public abstract void setName(String var1);

    public boolean equals(Object o) {
        if (!(o instanceof IAndroidTarget.OptionalLibrary)) {
            return false;
        }
        IAndroidTarget.OptionalLibrary lib = (IAndroidTarget.OptionalLibrary)o;
        return Objects.equal((Object)lib.getLocalJarPath(), (Object)this.getLocalJarPath()) && lib.getName().equals(this.getName());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getLocalJarPath(), this.getName()});
    }

    public String toString() {
        return String.format("OptionalLibrary[name=\"%1$s\" description=\"%2$s\" jar=\"%3$s\"]", this.getName(), this.getDescription(), this.getLocalJarPath());
    }

    public abstract void setManifestEntryRequired(Boolean var1);
}

