/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsProjectUtil;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.builder.AndroidLibraryPackagingTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class AndroidPreDexBuildTarget
extends BuildTarget<MyRootDescriptor> {
    private static final String ID = "only";
    private final JpsProject myProject;
    public static final String PRE_DEXED_LIBS_DIRECTORY_NAME = "pre_dexed_libs";

    public AndroidPreDexBuildTarget(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "<init>"));
        }
        super((BuildTargetType)MyTargetType.INSTANCE);
        this.myProject = project;
    }

    public String getId() {
        return ID;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList();
        for (JpsModule module : this.myProject.getModules()) {
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null) continue;
            if (extension.isLibrary()) {
                result.add(new AndroidLibraryPackagingTarget(module));
                continue;
            }
            result.add(new AndroidAarDepsBuildTarget(module));
        }
        return result;
    }

    private static void fillDepsRecursively(@NotNull JpsModule root, @NotNull Set<JpsModule> libModules, @NotNull Set<String> externalJars, @NotNull BuildDataPaths dataPaths, @NotNull AndroidPlatform platform) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "fillDepsRecursively"));
        }
        if (libModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libModules", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "fillDepsRecursively"));
        }
        if (externalJars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalJars", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "fillDepsRecursively"));
        }
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPaths", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "fillDepsRecursively"));
        }
        if (platform == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "platform", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "fillDepsRecursively"));
        }
        for (String jarOrLibDirPath : AndroidJpsUtil.getExternalLibraries(dataPaths, root, platform, false, false, true)) {
            String path = FileUtil.toCanonicalPath((String)jarOrLibDirPath);
            if (path == null) continue;
            externalJars.add(path);
        }
        for (JpsDependencyElement dependencyElement : root.getDependenciesList().getDependencies()) {
            JpsAndroidModuleExtension depExtension;
            JpsModule depModule;
            if (!(dependencyElement instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)dependencyElement).getModule()) == null || (depExtension = AndroidJpsUtil.getExtension(depModule)) == null || !depExtension.isLibrary() || !libModules.add(depModule)) continue;
            AndroidPreDexBuildTarget.fillDepsRecursively(depModule, libModules, externalJars, dataPaths, platform);
        }
    }

    @NotNull
    public List<MyRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<MyRootDescriptor> result = new ArrayList<MyRootDescriptor>();
        HashSet libModules = new HashSet();
        HashSet externalJars = new HashSet();
        for (JpsModule module : this.myProject.getModules()) {
            AndroidPlatform platform;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null || extension.isLibrary() || !extension.isPreDexingEnabled() || (platform = AndroidJpsUtil.getAndroidPlatform(module, null, null)) == null) continue;
            AndroidPreDexBuildTarget.fillDepsRecursively(module, (Set<JpsModule>)libModules, (Set<String>)externalJars, dataPaths, platform);
        }
        for (JpsModule libModule : libModules) {
            File classesJarFile = new AndroidLibraryPackagingTarget(libModule).getOutputFile(dataPaths);
            result.add(new MyRootDescriptor(this, classesJarFile, libModule.getName()));
        }
        for (String externalJarPath : externalJars) {
            result.add(new MyRootDescriptor(this, new File(externalJarPath), null));
        }
        ArrayList<MyRootDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "computeRootDescriptors"));
        }
        return arrayList;
    }

    @Nullable
    public MyRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (MyRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        if ("Android Pre-DEX" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "getPresentableName"));
        }
        return "Android Pre-DEX";
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputFile(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "getOutputRoots"));
        }
        return list;
    }

    @NotNull
    public File getOutputFile(CompileContext context) {
        File file = AndroidPreDexBuildTarget.getOutputDir(context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "getOutputFile"));
        }
        return file;
    }

    @NotNull
    public static File getOutputDir(@NotNull BuildDataPaths dataPaths) {
        if (dataPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPaths", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "getOutputDir"));
        }
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths);
        File file = new File(dir, PRE_DEXED_LIBS_DIRECTORY_NAME);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "getOutputDir"));
        }
        return file;
    }

    @NotNull
    public JpsProject getProject() {
        JpsProject jpsProject = this.myProject;
        if (jpsProject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget", "getProject"));
        }
        return jpsProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AndroidPreDexBuildTarget target = (AndroidPreDexBuildTarget)((Object)o);
        return this.myProject.equals(target.myProject);
    }

    public int hashCode() {
        return this.myProject.hashCode();
    }

    public static class MyRootDescriptor
    extends BuildRootDescriptorImpl {
        private final String myModuleName;

        private MyRootDescriptor(@NotNull BuildTarget target, @NotNull File root, @Nullable String moduleName) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyRootDescriptor", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyRootDescriptor", "<init>"));
            }
            super(target, root);
            this.myModuleName = moduleName;
        }

        @Nullable
        public String getModuleName() {
            return this.myModuleName;
        }
    }

    public static class MyTargetType
    extends BuildTargetType<AndroidPreDexBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-pre-dex");
        }

        @NotNull
        public List<AndroidPreDexBuildTarget> computeAllTargets(@NotNull JpsModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType", "computeAllTargets"));
            }
            if (!AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
                List<AndroidPreDexBuildTarget> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType", "computeAllTargets"));
                }
                return list;
            }
            List<AndroidPreDexBuildTarget> list = Collections.singletonList(new AndroidPreDexBuildTarget(model.getProject()));
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType", "computeAllTargets"));
            }
            return list;
        }

        @NotNull
        public BuildTargetLoader<AndroidPreDexBuildTarget> createLoader(@NotNull JpsModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType", "createLoader"));
            }
            final JpsProject project = model.getProject();
            BuildTargetLoader<AndroidPreDexBuildTarget> buildTargetLoader = new BuildTargetLoader<AndroidPreDexBuildTarget>(){

                @Nullable
                public AndroidPreDexBuildTarget createTarget(@NotNull String targetId) {
                    if (targetId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType$1", "createTarget"));
                    }
                    return AndroidPreDexBuildTarget.ID.equals(targetId) && AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(project) ? new AndroidPreDexBuildTarget(project) : null;
                }
            };
            if (buildTargetLoader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/builder/AndroidPreDexBuildTarget$MyTargetType", "createLoader"));
            }
            return buildTargetLoader;
        }
    }
}

