/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.artifacts;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.incremental.artifacts.ArtifactBasedBuildTarget;
import org.jetbrains.jps.incremental.artifacts.JpsBuilderArtifactService;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;

public abstract class ArtifactBasedBuildTargetType<T extends ArtifactBasedBuildTarget>
extends BuildTargetType<T> {
    protected ArtifactBasedBuildTargetType(String typeId) {
        super(typeId);
    }

    @Override
    @NotNull
    public List<T> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType", "computeAllTargets"));
        }
        Collection<JpsArtifact> artifacts = JpsBuilderArtifactService.getInstance().getArtifacts(model, true);
        ArrayList<T> targets = new ArrayList<T>(artifacts.size());
        for (JpsArtifact artifact : artifacts) {
            if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
            targets.add(this.createArtifactBasedTarget(artifact));
        }
        ArrayList<T> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public BuildTargetLoader<T> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType", "createLoader"));
        }
        Loader loader = new Loader(model);
        if (loader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType", "createLoader"));
        }
        return loader;
    }

    protected abstract T createArtifactBasedTarget(JpsArtifact var1);

    private class Loader
    extends BuildTargetLoader<T> {
        private final Map<String, JpsArtifact> myArtifacts = new HashMap<String, JpsArtifact>();

        public Loader(JpsModel model) {
            for (JpsArtifact artifact : JpsBuilderArtifactService.getInstance().getArtifacts(model, true)) {
                this.myArtifacts.put(artifact.getName(), artifact);
            }
        }

        @Override
        @Nullable
        public T createTarget(@NotNull String targetId) {
            if (targetId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/incremental/artifacts/ArtifactBasedBuildTargetType$Loader", "createTarget"));
            }
            JpsArtifact artifact = this.myArtifacts.get(targetId);
            return artifact != null ? (Object)ArtifactBasedBuildTargetType.this.createArtifactBasedTarget(artifact) : null;
        }
    }
}

