/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gant;

import org.jetbrains.jps.gant.BuildInfoPrinter;
import org.jetbrains.jps.gant.JpsGantProjectBuilder;

public class TeamCityBuildInfoPrinter
implements BuildInfoPrinter {
    private static char escapedChar(char c) {
        switch (c) {
            case '\n': {
                return 'n';
            }
            case '\r': {
                return 'r';
            }
            case '\u0085': {
                return 'x';
            }
            case '\u2028': {
                return 'l';
            }
            case '\u2029': {
                return 'p';
            }
            case '|': {
                return '|';
            }
            case '\'': {
                return '\'';
            }
            case '[': {
                return '[';
            }
            case ']': {
                return ']';
            }
        }
        return '\u0000';
    }

    private static String escape(String text) {
        StringBuilder escaped = new StringBuilder();
        for (char c : text.toCharArray()) {
            Character escChar = Character.valueOf(TeamCityBuildInfoPrinter.escapedChar(c));
            if (escChar.charValue() == '\u0000') {
                escaped.append(c);
                continue;
            }
            escaped.append('|').append(escChar);
        }
        return escaped.toString();
    }

    @Override
    public void printProgressMessage(JpsGantProjectBuilder builder, String message) {
        String escapedMessage = TeamCityBuildInfoPrinter.escape(message);
        builder.info("##teamcity[progressMessage '" + escapedMessage + "']");
    }

    @Override
    public void printBlockOpenedMessage(JpsGantProjectBuilder builder, String blockId) {
        builder.info("##teamcity[blockOpened name='" + TeamCityBuildInfoPrinter.escape(blockId) + "']");
    }

    @Override
    public void printBlockClosedMessage(JpsGantProjectBuilder builder, String blockId) {
        builder.info("##teamcity[blockClosed name='" + TeamCityBuildInfoPrinter.escape(blockId) + "']");
    }

    @Override
    public void printStatisticsMessage(JpsGantProjectBuilder builder, String key, String value) {
        builder.info("##teamcity[buildStatisticValue key='" + TeamCityBuildInfoPrinter.escape(key) + "' value='" + TeamCityBuildInfoPrinter.escape(value) + "']");
    }

    @Override
    public void printCompilationErrors(JpsGantProjectBuilder builder, String compilerName, String messages) {
        String escapedCompiler = TeamCityBuildInfoPrinter.escape(compilerName);
        String escapedOutput = TeamCityBuildInfoPrinter.escape(messages);
        builder.info("##teamcity[compilationStarted compiler='" + escapedCompiler + "']");
        builder.info("##teamcity[message text='" + escapedOutput + "' status='ERROR']");
        builder.info("##teamcity[compilationFinished compiler='" + escapedCompiler + "']");
    }

    @Override
    public void printCompilationStart(JpsGantProjectBuilder builder, String compilerName) {
        builder.info("##teamcity[compilationStarted compiler='" + TeamCityBuildInfoPrinter.escape(compilerName) + "']");
    }

    @Override
    public void printCompilationFinish(JpsGantProjectBuilder builder, String compilerName) {
        builder.info("##teamcity[compilationFinished compiler='" + TeamCityBuildInfoPrinter.escape(compilerName) + "']");
    }
}

