/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.EventDispatcher;
import gnu.trove.TObjectLongHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.api.CanceledStatus;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.builders.logging.BuildLoggingManager;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuildListener;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompileScope;
import org.jetbrains.jps.incremental.MessageHandler;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.FileDeletedEvent;
import org.jetbrains.jps.incremental.messages.FileGeneratedEvent;
import org.jetbrains.jps.incremental.messages.ProgressMessage;

public class CompileContextImpl
extends UserDataHolderBase
implements CompileContext {
    private static final String CANCELED_MESSAGE = "The build has been canceled";
    private final CompileScope myScope;
    private final MessageHandler myDelegateMessageHandler;
    private final Set<ModuleBuildTarget> myNonIncrementalModules = new HashSet<ModuleBuildTarget>();
    private final TObjectLongHashMap<BuildTarget<?>> myCompilationStartStamp = new TObjectLongHashMap();
    private final ProjectDescriptor myProjectDescriptor;
    private final Map<String, String> myBuilderParams;
    private final CanceledStatus myCancelStatus;
    private volatile float myDone = -1.0f;
    private EventDispatcher<BuildListener> myListeners = EventDispatcher.create(BuildListener.class);

    public CompileContextImpl(CompileScope scope, ProjectDescriptor pd, MessageHandler delegateMessageHandler, Map<String, String> builderParams, CanceledStatus cancelStatus) throws ProjectBuildException {
        this.myProjectDescriptor = pd;
        this.myBuilderParams = Collections.unmodifiableMap(builderParams);
        this.myCancelStatus = cancelStatus;
        this.myScope = scope;
        this.myDelegateMessageHandler = delegateMessageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getCompilationStartStamp(BuildTarget<?> target) {
        TObjectLongHashMap<BuildTarget<?>> tObjectLongHashMap = this.myCompilationStartStamp;
        synchronized (tObjectLongHashMap) {
            return this.myCompilationStartStamp.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCompilationStartStamp(Collection<BuildTarget<?>> targets, long stamp) {
        TObjectLongHashMap<BuildTarget<?>> tObjectLongHashMap = this.myCompilationStartStamp;
        synchronized (tObjectLongHashMap) {
            for (BuildTarget<?> target : targets) {
                this.myCompilationStartStamp.put(target, stamp);
            }
        }
    }

    @Override
    public boolean isMake() {
        return JavaBuilderUtil.isCompileJavaIncrementally(this);
    }

    @Override
    public boolean isProjectRebuild() {
        return JavaBuilderUtil.isForcedRecompilationAllJavaModules(this);
    }

    @Override
    public BuildLoggingManager getLoggingManager() {
        return this.myProjectDescriptor.getLoggingManager();
    }

    @Override
    @Nullable
    public String getBuilderParameter(String paramName) {
        return this.myBuilderParams.get(paramName);
    }

    @Override
    public void addBuildListener(BuildListener listener) {
        this.myListeners.addListener((EventListener)listener);
    }

    @Override
    public void removeBuildListener(BuildListener listener) {
        this.myListeners.removeListener((EventListener)listener);
    }

    @Override
    public void markNonIncremental(ModuleBuildTarget target) {
        if (!target.isTests()) {
            this.myNonIncrementalModules.add(new ModuleBuildTarget(target.getModule(), JavaModuleBuildTargetType.TEST));
        }
        this.myNonIncrementalModules.add(target);
    }

    @Override
    public boolean shouldDifferentiate(ModuleChunk chunk) {
        if (this.myNonIncrementalModules.isEmpty()) {
            return true;
        }
        for (ModuleBuildTarget target : chunk.getTargets()) {
            if (!this.myNonIncrementalModules.contains(target)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final CanceledStatus getCancelStatus() {
        return this.myCancelStatus;
    }

    @Override
    public final void checkCanceled() throws ProjectBuildException {
        if (this.getCancelStatus().isCanceled()) {
            throw new StopBuildException(CANCELED_MESSAGE);
        }
    }

    @Override
    public void clearNonIncrementalMark(ModuleBuildTarget target) {
        this.myNonIncrementalModules.remove(target);
    }

    @Override
    public CompileScope getScope() {
        return this.myScope;
    }

    @Override
    public void processMessage(BuildMessage msg) {
        if (msg.getKind() == BuildMessage.Kind.ERROR) {
            Utils.ERRORS_DETECTED_KEY.set((UserDataHolder)this, (Object)Boolean.TRUE);
        }
        if (msg instanceof ProgressMessage) {
            ((ProgressMessage)msg).setDone(this.myDone);
        }
        this.myDelegateMessageHandler.processMessage(msg);
        if (msg instanceof FileGeneratedEvent) {
            ((BuildListener)this.myListeners.getMulticaster()).filesGenerated((FileGeneratedEvent)msg);
        } else if (msg instanceof FileDeletedEvent) {
            ((BuildListener)this.myListeners.getMulticaster()).filesDeleted((FileDeletedEvent)msg);
        }
    }

    @Override
    public void setDone(float done) {
        this.myDone = done;
    }

    @Override
    public ProjectDescriptor getProjectDescriptor() {
        return this.myProjectDescriptor;
    }
}

