/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.indexer;

import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.service.indexer.Capability;
import org.osgi.service.indexer.Requirement;

public final class Builder {
    private String namespace = null;
    private final Map<String, Object> attributes = new LinkedHashMap<String, Object>();
    private final Map<String, String> directives = new LinkedHashMap<String, String>();

    public Builder setNamespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public Builder addAttribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public Builder addDirective(String name, String value) {
        this.directives.put(name, value);
        return this;
    }

    public Capability buildCapability() throws IllegalStateException {
        if (this.namespace == null) {
            throw new IllegalStateException("Namespace not set");
        }
        return new Capability(this.namespace, new LinkedHashMap<String, Object>(this.attributes), new LinkedHashMap<String, String>(this.directives));
    }

    public Requirement buildRequirement() throws IllegalStateException {
        if (this.namespace == null) {
            throw new IllegalStateException("Namespace not set");
        }
        return new Requirement(this.namespace, new LinkedHashMap<String, Object>(this.attributes), new LinkedHashMap<String, String>(this.directives));
    }
}

