/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsElementCollectionRole;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsDependenciesList;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsLibraryDependency;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;
import org.jetbrains.jps.model.module.JpsModuleReference;
import org.jetbrains.jps.model.module.impl.JpsLibraryDependencyImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleDependencyImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleImpl;
import org.jetbrains.jps.model.module.impl.JpsModuleSourceDependencyImpl;
import org.jetbrains.jps.model.module.impl.JpsSdkDependencyImpl;

public class JpsDependenciesListImpl
extends JpsCompositeElementBase<JpsDependenciesListImpl>
implements JpsDependenciesList {
    public static final JpsElementCollectionRole<JpsDependencyElement> DEPENDENCY_COLLECTION_ROLE = JpsElementCollectionRole.create(JpsElementChildRoleBase.create("dependency"));

    public JpsDependenciesListImpl() {
        this.myContainer.setChild(DEPENDENCY_COLLECTION_ROLE);
    }

    private JpsDependenciesListImpl(JpsDependenciesListImpl original) {
        super(original);
    }

    @Override
    @NotNull
    public List<JpsDependencyElement> getDependencies() {
        List<JpsDependencyElement> list = ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).getElements();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "getDependencies"));
        }
        return list;
    }

    @Override
    public void clear() {
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).removeAllChildren();
    }

    @Override
    @NotNull
    public JpsModuleDependency addModuleDependency(@NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addModuleDependency"));
        }
        JpsModuleDependency jpsModuleDependency = this.addModuleDependency(module.createReference());
        if (jpsModuleDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addModuleDependency"));
        }
        return jpsModuleDependency;
    }

    @Override
    @NotNull
    public JpsModuleDependency addModuleDependency(@NotNull JpsModuleReference moduleReference) {
        if (moduleReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleReference", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addModuleDependency"));
        }
        JpsModuleDependencyImpl dependency = new JpsModuleDependencyImpl(moduleReference);
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(dependency);
        JpsModuleDependencyImpl jpsModuleDependencyImpl = dependency;
        if (jpsModuleDependencyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addModuleDependency"));
        }
        return jpsModuleDependencyImpl;
    }

    @Override
    @NotNull
    public JpsLibraryDependency addLibraryDependency(@NotNull JpsLibrary libraryElement) {
        if (libraryElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryElement", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addLibraryDependency"));
        }
        JpsLibraryDependency jpsLibraryDependency = this.addLibraryDependency(libraryElement.createReference());
        if (jpsLibraryDependency == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addLibraryDependency"));
        }
        return jpsLibraryDependency;
    }

    @Override
    @NotNull
    public JpsLibraryDependency addLibraryDependency(@NotNull JpsLibraryReference libraryReference) {
        if (libraryReference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryReference", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addLibraryDependency"));
        }
        JpsLibraryDependencyImpl dependency = new JpsLibraryDependencyImpl(libraryReference);
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(dependency);
        JpsLibraryDependencyImpl jpsLibraryDependencyImpl = dependency;
        if (jpsLibraryDependencyImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addLibraryDependency"));
        }
        return jpsLibraryDependencyImpl;
    }

    @Override
    public void addModuleSourceDependency() {
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(new JpsModuleSourceDependencyImpl());
    }

    @Override
    public void addSdkDependency(@NotNull JpsSdkType<?> sdkType) {
        if (sdkType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdkType", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "addSdkDependency"));
        }
        ((JpsElementCollection)((Object)this.myContainer.getChild(DEPENDENCY_COLLECTION_ROLE))).addChild(new JpsSdkDependencyImpl(sdkType));
    }

    @Override
    @NotNull
    public JpsDependenciesListImpl createCopy() {
        JpsDependenciesListImpl jpsDependenciesListImpl = new JpsDependenciesListImpl(this);
        if (jpsDependenciesListImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/module/impl/JpsDependenciesListImpl", "createCopy"));
        }
        return jpsDependenciesListImpl;
    }

    @Override
    public JpsModuleImpl getParent() {
        return (JpsModuleImpl)super.getParent();
    }
}

