/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.execution;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class CommandLineWrapper {
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public static void main(String[] args) throws Exception {
        File jarFile = new File(args[0]);
        MainPair mainPair = args[0].endsWith(".jar") ? CommandLineWrapper.loadMainClassFromClasspathJar(jarFile, args) : CommandLineWrapper.loadMainClassWithOldCustomLoader(jarFile, args);
        String[] mainArgs = mainPair.getArgs();
        Class mainClass = mainPair.getMainClass();
        Class<?> mainArgType = new String[0].getClass();
        Method main = mainClass.getMethod("main", mainArgType);
        CommandLineWrapper.ensureAccess(main);
        main.invoke(null, new Object[]{mainArgs});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MainPair loadMainClassFromClasspathJar(File jarFile, String[] args) throws Exception {
        String[] mainArgs;
        JarInputStream inputStream = new JarInputStream(new FileInputStream(jarFile));
        try {
            String programParameters;
            Manifest manifest = inputStream.getManifest();
            String vmParams = manifest.getMainAttributes().getValue("VM-Options");
            if (vmParams != null) {
                String[] properties = CommandLineWrapper.splitBySpaces(vmParams);
                for (int i = 0; i < properties.length; ++i) {
                    CommandLineWrapper.setProperty(properties[i]);
                }
            }
            if ((programParameters = manifest.getMainAttributes().getValue("Program-Parameters")) == null) {
                mainArgs = new String[args.length - 2];
                System.arraycopy(args, 2, mainArgs, 0, mainArgs.length);
            } else {
                mainArgs = CommandLineWrapper.splitBySpaces(programParameters);
            }
        }
        finally {
            inputStream.close();
            jarFile.deleteOnExit();
        }
        return new MainPair(Class.forName(args[1]), mainArgs);
    }

    private static String[] splitBySpaces(String parameterString) {
        parameterString = parameterString.trim();
        ArrayList<String> params = new ArrayList<String>();
        StringBuffer token = new StringBuffer(128);
        boolean inQuotes = false;
        boolean escapedQuote = false;
        boolean nonEmpty = false;
        for (int i = 0; i < parameterString.length(); ++i) {
            char ch = parameterString.charAt(i);
            if (ch == '\"') {
                if (!escapedQuote) {
                    inQuotes = !inQuotes;
                    nonEmpty = true;
                    continue;
                }
                escapedQuote = false;
            } else if (Character.isWhitespace(ch)) {
                if (!inQuotes) {
                    if (token.length() <= 0 && !nonEmpty) continue;
                    params.add(token.toString());
                    token.setLength(0);
                    nonEmpty = false;
                    continue;
                }
            } else if (ch == '\\' && i < parameterString.length() - 1 && parameterString.charAt(i + 1) == '\"') {
                escapedQuote = true;
                continue;
            }
            token.append(ch);
        }
        if (token.length() > 0 || nonEmpty) {
            params.add(token.toString());
        }
        return params.toArray(new String[params.size()]);
    }

    private static void ensureAccess(Object reflectionObject) {
        Class<?> aClass = reflectionObject.getClass();
        try {
            Method setAccessibleMethod = aClass.getMethod("setAccessible", Boolean.TYPE);
            setAccessibleMethod.invoke(reflectionObject, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MainPair loadMainClassWithOldCustomLoader(File file, String[] args) throws Exception {
        StringBuffer buf;
        ArrayList<URL> urls;
        block18: {
            urls = new ArrayList<URL>();
            buf = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            block10: while (true) {
                while (reader.ready()) {
                    String fileName = reader.readLine();
                    if (buf.length() > 0) {
                        buf.append(File.pathSeparator);
                    }
                    buf.append(fileName);
                    File classpathElement = new File(fileName);
                    try {
                        urls.add(classpathElement.toURI().toURL());
                        continue block10;
                    }
                    catch (NoSuchMethodError e) {
                        urls.add(classpathElement.toURL());
                    }
                }
                break block18;
                {
                    continue block10;
                    break;
                }
                break;
            }
            finally {
                reader.close();
            }
        }
        if (!file.delete()) {
            file.deleteOnExit();
        }
        System.setProperty("java.class.path", buf.toString());
        int startArgsIdx = 2;
        if (args.length >= 3 && "@vm_params".equals(args[1])) {
            startArgsIdx = 4;
            BufferedReader vmParamsReader = new BufferedReader(new FileReader(args[2]));
            try {
                String property;
                while ((property = vmParamsReader.readLine()) != null) {
                    CommandLineWrapper.setProperty(property);
                }
            }
            finally {
                vmParamsReader.close();
            }
        }
        String mainClassName = args[startArgsIdx - 1];
        String[] mainArgs = new String[args.length - startArgsIdx];
        System.arraycopy(args, startArgsIdx, mainArgs, 0, mainArgs.length);
        for (int i = 0; i < urls.size(); ++i) {
            URL url = (URL)urls.get(i);
            urls.set(i, CommandLineWrapper.internFileProtocol(url));
        }
        ClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), null);
        String classLoader = System.getProperty("java.system.class.loader");
        if (classLoader != null) {
            try {
                loader = (ClassLoader)Class.forName(classLoader).getConstructor(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CommandLineWrapper.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).newInstance(loader);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Class<?> mainClass = loader.loadClass(mainClassName);
        Thread.currentThread().setContextClassLoader(loader);
        return new MainPair(mainClass, mainArgs);
    }

    private static void setProperty(String property) {
        if (property.startsWith("-D")) {
            int p = property.indexOf(61);
            if (p > 0) {
                System.setProperty(property.substring(2, p), property.substring(p + 1));
            } else {
                System.setProperty(property.substring(2), "");
            }
        }
    }

    private static URL internFileProtocol(URL url) {
        try {
            if ("file".equals(url.getProtocol())) {
                return new URL("file", url.getHost(), url.getPort(), url.getFile());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class MainPair {
        private Class mainClass;
        private String[] args;

        public MainPair(Class mainClass, String[] args) {
            this.mainClass = mainClass;
            this.args = args;
        }

        public Class getMainClass() {
            return this.mainClass;
        }

        public String[] getArgs() {
            return this.args;
        }
    }
}

