/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Repository;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.impl.meta.TypeDetails;
import com.android.repository.io.FileOp;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.JAXBException;

public final class LocalRepoLoader {
    public static final String PACKAGE_XML_FN = "package.xml";
    private static final int MAX_SCAN_DEPTH = 10;
    private Map<String, LocalPackage> mPackages = null;
    private final File mRoot;
    private final RepoManager mRepoManager;
    private final FileOp mFop;
    private FallbackLocalRepoLoader mFallback;

    public LocalRepoLoader(File root, RepoManager manager, FallbackLocalRepoLoader fallback, FileOp fop) {
        this.mRoot = root;
        this.mRepoManager = manager;
        this.mFop = fop;
        this.mFallback = fallback;
    }

    public Map<String, LocalPackage> getPackages(ProgressIndicator progress) {
        if (this.mPackages == null) {
            HashMap packages = Maps.newHashMap();
            this.collectPackages(progress, packages, this.mRoot, 0);
            this.mPackages = packages;
        }
        return Collections.unmodifiableMap(this.mPackages);
    }

    private void collectPackages(ProgressIndicator progress, Map<String, LocalPackage> collector, File root, int depth) {
        if (depth > 10) {
            return;
        }
        File packageXml = new File(root, PACKAGE_XML_FN);
        LocalPackage p = null;
        if (this.mFop.exists(packageXml)) {
            try {
                p = this.parsePackage(packageXml, progress);
            }
            catch (Exception e) {
                progress.logWarning("Found corrupted package.xml at " + packageXml);
            }
        }
        if (p == null && this.mFallback != null) {
            p = this.mFallback.parseLegacyLocalPackage(root, progress);
            if (p != null) {
                this.writePackage(p, packageXml, progress);
            } else if (this.mFop.exists(packageXml)) {
                File bad = new File(packageXml.getPath() + ".bad");
                progress.logWarning(String.format("Invalid package.xml found and failed to parse using fallback. Renaming %1$s to %2$s", packageXml, bad));
                this.mFop.renameTo(packageXml, bad);
            }
        }
        if (p != null) {
            this.addPackage(p, collector, progress);
        } else {
            for (File f : this.mFop.listFiles(root)) {
                if (!this.mFop.isDirectory(f)) continue;
                this.collectPackages(progress, collector, f, depth + 1);
            }
        }
    }

    private void addPackage(LocalPackage p, Map<String, LocalPackage> collector, ProgressIndicator progress) {
        File actual;
        String filePath = p.getPath().replace(';', File.separatorChar);
        File desired = new File(this.mRoot, filePath);
        if (!desired.equals(actual = p.getLocation())) {
            progress.logWarning(String.format("Observed package id '%1$s' in inconsistent location '%2$s' (Expected '%3$s')", p.getPath(), actual.getPath(), desired.getPath()));
            LocalPackage existing = collector.get(p.getPath());
            if (existing != null) {
                progress.logWarning(String.format("Already observed package id '%1$s' in '%2$s'. Skipping duplicate at '%3$s'", p.getPath(), existing.getLocation().getPath(), actual.getPath()));
                return;
            }
        }
        collector.put(p.getPath(), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackage(LocalPackage p, File packageXml, ProgressIndicator progress) {
        LocalPackageImpl impl = LocalPackageImpl.create(p, this.mRepoManager);
        OutputStream fos = null;
        try {
            fos = this.mFop.newFileOutputStream(packageXml);
            Repository repo = impl.createFactory().createRepositoryType();
            repo.setLocalPackage(impl);
            repo.addLicense(impl.getLicense());
            TypeDetails typeDetails = p.getTypeDetails();
            CommonFactory factory = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
            SchemaModuleUtil.marshal(factory.generateRepository(repo), this.mRepoManager.getSchemaModules(), fos, this.mRepoManager.getResourceResolver(progress), progress);
        }
        catch (FileNotFoundException e) {
            progress.logInfo("File not found while marshalling " + packageXml + ". Probably the SDK is read-only");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private LocalPackage parsePackage(File packageXml, ProgressIndicator progress) throws JAXBException {
        Repository repo;
        try {
            progress.logInfo("Parsing " + packageXml);
            repo = (Repository)SchemaModuleUtil.unmarshal(this.mFop.newFileInputStream(packageXml), this.mRepoManager.getSchemaModules(), this.mRepoManager.getResourceResolver(progress), false, progress);
        }
        catch (FileNotFoundException e) {
            progress.logError(String.format("XML file %s doesn't exist", packageXml), e);
            return null;
        }
        if (repo == null) {
            progress.logWarning(String.format("Failed to parse %s", packageXml));
            return null;
        }
        LocalPackage p = repo.getLocalPackage();
        if (p == null) {
            progress.logWarning("Didn't find any local package in repository");
            return null;
        }
        p.setInstalledPath(packageXml.getParentFile());
        return p;
    }
}

