/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.messages;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public class CompilerMessage
extends BuildMessage {
    private final String myCompilerName;
    private final long myProblemBeginOffset;
    private final long myProblemEndOffset;
    private final long myProblemLocationOffset;
    private final Collection<String> mySourcePaths;
    private final long myLine;
    private final long myColumn;

    public CompilerMessage(@NotNull String compilerName, @NotNull Throwable internalError) {
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        if (internalError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "internalError", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        this(compilerName, BuildMessage.Kind.ERROR, CompilerMessage.getTextFromThrowable(internalError));
    }

    public CompilerMessage(@NotNull String compilerName, BuildMessage.Kind kind, String messageText) {
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        this(compilerName, kind, messageText, (String)null, -1L, -1L, -1L, -1L, -1L);
    }

    public CompilerMessage(@NotNull String compilerName, String messageText, Collection<String> sourcePaths, BuildMessage.Kind kind) {
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        this(compilerName, kind, messageText, sourcePaths, -1L, -1L, -1L, -1L, -1L);
    }

    public CompilerMessage(@NotNull String compilerName, BuildMessage.Kind kind, String messageText, String sourcePath) {
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        this(compilerName, messageText, sourcePath == null ? Collections.emptyList() : Collections.singleton(sourcePath), kind);
    }

    /*
     * WARNING - void declaration
     */
    public CompilerMessage(@NotNull String compilerName, BuildMessage.Kind kind, String messageText, @NotNull Collection<String> sourcePaths, long problemBeginOffset, long problemEndOffset, long problemLocationOffset, long l, long l2) {
        void locationColumn;
        void locationLine;
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        if (sourcePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourcePaths", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        super(messageText, kind);
        this.myCompilerName = compilerName;
        this.myProblemBeginOffset = problemBeginOffset;
        this.myProblemEndOffset = problemEndOffset;
        this.myProblemLocationOffset = problemLocationOffset;
        this.mySourcePaths = ContainerUtil.map(sourcePaths, (Function)new Function<String, String>(){

            public String fun(String s) {
                return s.replace(File.separatorChar, '/');
            }
        });
        this.myLine = locationLine;
        this.myColumn = locationColumn;
    }

    /*
     * WARNING - void declaration
     */
    public CompilerMessage(@NotNull String compilerName, BuildMessage.Kind kind, String messageText, @Nullable String sourcePath, long problemBeginOffset, long problemEndOffset, long problemLocationOffset, long l, long l2) {
        void locationColumn;
        void locationLine;
        if (compilerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerName", "org/jetbrains/jps/incremental/messages/CompilerMessage", "<init>"));
        }
        this(compilerName, kind, messageText, sourcePath == null ? Collections.emptyList() : Collections.singleton(sourcePath), problemBeginOffset, problemEndOffset, problemLocationOffset, (long)locationLine, (long)locationColumn);
    }

    @NotNull
    public String getCompilerName() {
        String string = this.myCompilerName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/messages/CompilerMessage", "getCompilerName"));
        }
        return string;
    }

    @Nullable
    public String getSourcePath() {
        return this.mySourcePaths.size() == 1 ? (String)ContainerUtil.getFirstItem(this.mySourcePaths) : null;
    }

    public long getLine() {
        return this.myLine;
    }

    public long getColumn() {
        return this.myColumn;
    }

    public long getProblemBeginOffset() {
        return this.myProblemBeginOffset;
    }

    public long getProblemEndOffset() {
        return this.myProblemEndOffset;
    }

    public long getProblemLocationOffset() {
        return this.myProblemLocationOffset;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getCompilerName()).append(":").append(this.getKind().name()).append(":").append(super.toString());
        String result = this.mySourcePaths.isEmpty() ? null : (this.mySourcePaths.size() == 1 ? (String)ContainerUtil.getFirstItem(this.mySourcePaths) : this.mySourcePaths.toString());
        String path = result;
        if (path != null) {
            builder.append("; file: ").append(path);
            long line = this.getLine();
            long column = this.getColumn();
            if (line >= 0L && column >= 0L) {
                builder.append(" at (").append(line).append(":").append(column).append(")");
            }
        }
        return builder.toString();
    }

    public static String getTextFromThrowable(Throwable internalError) {
        StringBuilder text = new StringBuilder();
        text.append("Error: ");
        String msg = internalError.getMessage();
        if (!StringUtil.isEmptyOrSpaces((String)msg)) {
            text.append(msg);
        } else {
            text.append(internalError.getClass().getName());
        }
        text.append("\n");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        internalError.printStackTrace(new PrintStream(out));
        text.append(out.toString());
        return text.toString();
    }
}

