/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.util.osgi.manifest.parse.standard;

import com.springsource.util.osgi.manifest.parse.standard.HeaderProblem;
import com.springsource.util.osgi.manifest.parse.standard.HeaderToken;
import com.springsource.util.osgi.manifest.parse.standard.HeaderTokenKind;
import com.springsource.util.osgi.manifest.parse.standard.Severity;
import com.springsource.util.osgi.manifest.parse.standard.SourceContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderTokenStream {
    private List<HeaderToken> tokens = new ArrayList<HeaderToken>(20);
    private int tokenStreamLen = -1;
    private int tokenStreamPosition = 0;
    private List<HeaderProblem> problems = new ArrayList<HeaderProblem>();
    SourceContext sourceContext;

    HeaderTokenStream(String header) {
        this.tokens.clear();
        this.tokenStreamPosition = 0;
        this.sourceContext = new SourceContext(header);
    }

    public String toString() {
        return this.toFormattedString(true);
    }

    public int getCount() {
        return this.tokenStreamLen;
    }

    public int getPosition() {
        return this.tokenStreamPosition;
    }

    public HeaderToken next() {
        if (this.tokenStreamPosition >= this.tokenStreamLen) {
            return null;
        }
        return this.tokens.get(this.tokenStreamPosition++);
    }

    public void setPosition(int newPosition) {
        this.tokenStreamPosition = newPosition;
    }

    public HeaderToken peek() {
        if (this.tokenStreamPosition >= this.tokenStreamLen) {
            return null;
        }
        return this.tokens.get(this.tokenStreamPosition);
    }

    public HeaderToken peekLast() {
        return this.tokens.get(this.tokenStreamLen - 1);
    }

    public HeaderToken peek(int offset) {
        int pos = this.tokenStreamPosition + offset;
        if (pos >= this.tokenStreamLen) {
            return null;
        }
        if (pos < 0) {
            return null;
        }
        return this.tokens.get(pos);
    }

    public String toFormattedString() {
        return this.toFormattedString(false);
    }

    public String toFormattedString(boolean includePositionsInOutput) {
        StringBuilder sb = new StringBuilder();
        sb.append("TokenStream:#").append(this.tokens.size()).append(" tokens:");
        sb.append("[");
        int i = 0;
        for (HeaderToken token : this.tokens) {
            if (i > 0) {
                sb.append(",");
            }
            if (i == this.tokenStreamPosition) {
                sb.append("[[");
            }
            if (includePositionsInOutput) {
                sb.append(token.toString());
            } else {
                sb.append(token.value());
            }
            if (i == this.tokenStreamPosition) {
                sb.append("]]");
            }
            ++i;
        }
        sb.append("]");
        return sb.toString();
    }

    void addToken(HeaderToken token) {
        this.tokens.add(token);
    }

    public SourceContext getSourceContext() {
        return this.sourceContext;
    }

    public boolean hasMore() {
        return this.tokenStreamPosition < this.tokenStreamLen;
    }

    public void skip() {
        ++this.tokenStreamPosition;
    }

    public void recordProblem(HeaderProblem problem) {
        this.problems.add(problem);
    }

    public boolean containsProblems() {
        return !this.problems.isEmpty();
    }

    public boolean containsProblems(Severity severity) {
        if (this.problems.size() != 0) {
            for (HeaderProblem problem : this.problems) {
                if (!problem.isSeverity(severity)) continue;
                return true;
            }
        }
        return false;
    }

    public List<HeaderProblem> getProblems() {
        return this.problems;
    }

    public void reset() {
        this.setPosition(0);
    }

    public HeaderToken peekFor(HeaderTokenKind kind) {
        HeaderToken t;
        if (this.tokenStreamPosition < this.tokenStreamLen && (t = this.tokens.get(this.tokenStreamPosition)).getKind() == kind) {
            ++this.tokenStreamPosition;
            return t;
        }
        return null;
    }

    public void lexComplete() {
        this.tokenStreamLen = this.tokens.size();
    }
}

