/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.WeakList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class LowMemoryWatcher {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcher");
    private static final List<Runnable> ourListeners = new WeakList<Runnable>();
    private final Runnable myRunnable;

    static void onLowMemorySignalReceived() {
        LOG.info("Low memory signal received.");
        for (Runnable watcher : ourListeners) {
            try {
                watcher.run();
            }
            catch (Throwable e) {
                LOG.info(e);
            }
        }
    }

    @Contract(pure=true)
    public static LowMemoryWatcher register(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/LowMemoryWatcher", "register"));
        }
        return new LowMemoryWatcher(runnable);
    }

    public static void register(@NotNull Runnable runnable, @NotNull Disposable parentDisposable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/LowMemoryWatcher", "register"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/util/LowMemoryWatcher", "register"));
        }
        final LowMemoryWatcher watcher = new LowMemoryWatcher(runnable);
        Disposer.register(parentDisposable, new Disposable(){

            @Override
            public void dispose() {
                watcher.stop();
            }
        });
    }

    private LowMemoryWatcher(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/util/LowMemoryWatcher", "<init>"));
        }
        this.myRunnable = runnable;
        ourListeners.add(runnable);
    }

    public void stop() {
        ourListeners.remove(this.myRunnable);
    }

    static void stopAll() {
        ourListeners.clear();
    }
}

