/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.concurrent.Future;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;

public class LowMemoryWatcherManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.LowMemoryWatcherManager");
    private static final long MEM_THRESHOLD = 0x500000L;
    private Future<?> mySubmitted;
    private final Runnable myJanitor = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Runnable runnable = LowMemoryWatcherManager.this.myJanitor;
            synchronized (runnable) {
                LowMemoryWatcherManager.this.mySubmitted = null;
            }
            LowMemoryWatcher.onLowMemorySignalReceived();
        }
    };
    private final NotificationListener myLowMemoryListener = new NotificationListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notification, Object __) {
            if ("java.management.memory.threshold.exceeded".equals(notification.getType()) || "java.management.memory.collection.threshold.exceeded".equals(notification.getType())) {
                Runnable runnable = LowMemoryWatcherManager.this.myJanitor;
                synchronized (runnable) {
                    if (LowMemoryWatcherManager.this.mySubmitted == null) {
                        LowMemoryWatcherManager.this.mySubmitted = AppExecutorUtil.getAppExecutorService().submit(LowMemoryWatcherManager.this.myJanitor);
                    }
                }
            }
        }
    };

    public LowMemoryWatcherManager() {
        try {
            for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                long threshold;
                if (bean.getType() != MemoryType.HEAP || !bean.isUsageThresholdSupported() || (threshold = bean.getUsage().getMax() - 0x500000L) <= 0L) continue;
                bean.setUsageThreshold(threshold);
                bean.setCollectionUsageThreshold(threshold);
            }
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this.myLowMemoryListener, null, null);
        }
        catch (Throwable e) {
            LOG.info("Errors initializing LowMemoryWatcher: ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (ListenerNotFoundException e) {
            LOG.error(e);
        }
        Runnable runnable = this.myJanitor;
        synchronized (runnable) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }
}

