/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gwt.model.GwtSdkPaths;
import org.jetbrains.jps.util.JpsPathUtil;

public class GwtMavenSdkPaths
implements GwtSdkPaths {
    @NonNls
    public static final String TYPE_ID = "maven";
    private final String myBasePath;
    private final String myVersion;
    private final String myDevDirPath;
    private final String myRepositoryPath;

    public GwtMavenSdkPaths(String homeDirectoryPath, String version) {
        this.myDevDirPath = homeDirectoryPath;
        this.myBasePath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)homeDirectoryPath));
        this.myRepositoryPath = PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)PathUtilRt.getParentPath((String)this.myBasePath)));
        this.myVersion = version;
    }

    public static String getPlatformId() {
        return SystemInfo.isMac ? "mac" : (SystemInfo.isLinux ? "linux" : "windows");
    }

    @Override
    @NotNull
    public String getDevJarPath(boolean systemIndependent) {
        String platformSuffix = VersionComparatorUtil.compare((String)this.myVersion, (String)"2.0") >= 0 ? "" : "-" + GwtMavenSdkPaths.getPlatformId();
        String string = new File(this.myDevDirPath, "gwt-dev-" + this.myVersion + platformSuffix + ".jar").getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getDevJarPath"));
        }
        return string;
    }

    @Override
    public String getCodeServerJarPath() {
        return this.getJarPath("gwt-codeserver");
    }

    @Override
    @NotNull
    public String getHomeDirectoryUrl() {
        String string = JpsPathUtil.pathToUrl((String)this.myDevDirPath);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getHomeDirectoryUrl"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getServletJarPath() {
        String string = this.getJarPath("gwt-servlet");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getServletJarPath"));
        }
        return string;
    }

    private String getJarPath(String name) {
        return new File(this.myBasePath, name + "/" + this.myVersion + "/" + name + "-" + this.myVersion + ".jar").getAbsolutePath();
    }

    @Override
    @NotNull
    public String getUserJarPath() {
        String string = this.getJarPath("gwt-user");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getUserJarPath"));
        }
        return string;
    }

    @Override
    @NotNull
    public List<String> getAdditionalCompilerJars() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtMavenSdkPaths", "getAdditionalCompilerJars"));
        }
        return list;
    }

    public List<String> resolveMavenArtifactsPaths(List<String> artifacts) {
        ArrayList<String> resolvedPaths = new ArrayList<String>();
        for (String artifact : artifacts) {
            List parts = StringUtil.split((String)artifact, (String)":");
            if (parts.size() != 3) continue;
            ContainerUtil.addIfNotNull(resolvedPaths, (Object)GwtMavenSdkPaths.getArtifactPath(this.myRepositoryPath, (String)parts.get(0), (String)parts.get(1), (String)parts.get(2)));
        }
        return resolvedPaths;
    }

    @Nullable
    public static String getArtifactPath(String repositoryPath, String groupId, String artifactId, String version) {
        File jar;
        File dir = new File(FileUtil.toSystemDependentName((String)(repositoryPath + "/" + groupId.replace('.', '/') + "/" + artifactId)));
        String[] fileNames = dir.list();
        if (fileNames != null && fileNames.length > 0 && (jar = new File(dir, version + "/" + artifactId + "-" + version + ".jar")).isFile()) {
            return jar.getAbsolutePath();
        }
        return null;
    }
}

