/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.model.impl.sdk;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtSdkPathUtil {
    @NonNls
    public static final String GWT_DEV_JAR = "gwt-dev.jar";
    @NonNls
    private static final String GWT_DEV_WINDOWS_JAR = "gwt-dev-windows.jar";
    @NonNls
    private static final String GWT_DEV_LINUX_JAR = "gwt-dev-linux.jar";
    @NonNls
    private static final String GWT_DEV_MAC_JAR = "gwt-dev-mac.jar";
    public static final String[][] ADDITIONAL_2_7_DEPENDENCIES = new String[][]{{"org.ow2.asm", "asm"}, {"org.ow2.asm", "asm-util"}, {"org.ow2.asm", "asm-tree"}, {"org.ow2.asm", "asm-commons"}};
    public static final String[][] ADDITIONAL_2_8_DEPENDENCIES = new String[][]{{"com.google.jsinterop", "jsinterop-annotations"}, {"javax.servlet", "javax.servlet-api"}, {"org.w3c.css", "sac"}, {"com.google.code.gson", "gson"}, {"colt", "colt"}, {"ant", "ant"}, {"commons-collections", "commons-collections"}, {"commons-io", "commons-io"}, {"com.ibm.icu", "icu4j"}, {"tapestry", "tapestry"}, {"net.sourceforge.htmlunit", "htmlunit"}, {"xalan", "xalan"}, {"xalan", "serializer"}, {"xml-apis", "xml-apis"}, {"org.apache.commons", "commons-lang3"}, {"org.apache.httpcomponents", "httpclient"}, {"org.apache.httpcomponents", "httpcore"}, {"commons-logging", "commons-logging"}, {"commons-codec", "commons-codec"}, {"org.apache.httpcomponents", "httpmime"}, {"net.sourceforge.htmlunit", "htmlunit-core-js"}, {"xerces", "xercesImpl"}, {"net.sourceforge.nekohtml", "nekohtml"}, {"net.sourceforge.cssparser", "cssparser"}, {"org.w3c.css", "sac"}, {"org.eclipse.jetty.websocket", "websocket-client"}, {"org.eclipse.jetty", "jetty-util"}, {"org.eclipse.jetty", "jetty-io"}, {"org.eclipse.jetty.websocket", "websocket-common"}, {"org.eclipse.jetty.websocket", "websocket-api"}, {"org.eclipse.jetty", "jetty-webapp"}, {"org.eclipse.jetty", "jetty-xml"}, {"org.eclipse.jetty", "jetty-servlet"}, {"org.eclipse.jetty", "jetty-security"}, {"org.eclipse.jetty", "jetty-server"}, {"javax.servlet", "javax.servlet-api"}, {"org.eclipse.jetty", "jetty-http"}, {"org.eclipse.jetty", "jetty-servlets"}, {"org.eclipse.jetty", "jetty-continuation"}, {"org.eclipse.jetty", "jetty-annotations"}, {"org.eclipse.jetty", "jetty-plus"}, {"org.eclipse.jetty", "jetty-jndi"}, {"javax.annotation", "javax.annotation-api"}, {"org.eclipse.jetty", "apache-jsp"}, {"org.eclipse.jetty.toolchain", "jetty-schemas"}, {"org.mortbay.jasper", "apache-jsp"}, {"org.mortbay.jasper", "apache-el"}};

    @NotNull
    public static List<String> findValidationJars(File parent) {
        File[] files = parent.listFiles();
        ArrayList<String> paths = new ArrayList<String>();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith("validation-api-") || !name.endsWith(".jar")) continue;
                paths.add(file.getAbsolutePath());
            }
        }
        ArrayList<String> arrayList = paths;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/model/impl/sdk/GwtSdkPathUtil", "findValidationJars"));
        }
        return arrayList;
    }

    public static String getCodeServerJarPath(String homePath) {
        return homePath + File.separator + "gwt-codeserver.jar";
    }

    public static String getUserJarPath(String homePath) {
        return homePath + File.separator + "gwt-user.jar";
    }

    public static String getSystemDependentDevJarName() {
        String jarName = SystemInfo.isWindows ? GWT_DEV_WINDOWS_JAR : (SystemInfo.isMac ? GWT_DEV_MAC_JAR : GWT_DEV_LINUX_JAR);
        return jarName;
    }

    public static String getDevJarPath(String homePath) {
        String newPath = GwtSdkPathUtil.getSystemIndependentDevJarPath(homePath);
        if (new File(newPath).exists()) {
            return newPath;
        }
        String oldPath = GwtSdkPathUtil.getSystemDependentDevJarPath(homePath);
        if (new File(oldPath).exists()) {
            return oldPath;
        }
        return newPath;
    }

    public static String getSystemIndependentDevJarPath(String homePath) {
        return homePath + File.separator + GWT_DEV_JAR;
    }

    public static String getSystemDependentDevJarPath(String homePath) {
        return homePath + File.separator + GwtSdkPathUtil.getSystemDependentDevJarName();
    }

    public static List<String> findValidationJarsInMavenRepo(String repositoryPath) {
        File validationDir = new File(FileUtil.toSystemDependentName((String)(repositoryPath + "/javax/validation/validation-api")));
        String[] fileNames = validationDir.list();
        if (fileNames != null && fileNames.length > 0) {
            String version = Collections.max(Arrays.asList(fileNames), VersionComparatorUtil.COMPARATOR);
            return GwtSdkPathUtil.findValidationJars(new File(validationDir, version));
        }
        return Collections.emptyList();
    }
}

