/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.model.bc.impl;

import com.intellij.flex.model.bc.JpsAirSigningOptions;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsElementCreator;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;

public class JpsAirSigningOptionsImpl
extends JpsElementBase<JpsAirSigningOptionsImpl>
implements JpsAirSigningOptions {
    static final JpsAirSigningOptionsRole ROLE = new JpsAirSigningOptionsRole();
    private boolean myUseTempCertificate = true;
    @NotNull
    private String myProvisioningProfilePath = "";
    @NotNull
    private String myKeystorePath = "";
    @NotNull
    private String myKeystoreType = "PKCS12";
    @NotNull
    private String myKeyAlias = "";
    @NotNull
    private String myProvider = "";
    @NotNull
    private String myTsa = "";

    private JpsAirSigningOptionsImpl() {
    }

    private JpsAirSigningOptionsImpl(JpsAirSigningOptionsImpl original) {
        this.myUseTempCertificate = original.myUseTempCertificate;
        this.myProvisioningProfilePath = original.myProvisioningProfilePath;
        this.myKeystorePath = original.myKeystorePath;
        this.myKeystoreType = original.myKeystoreType;
        this.myKeyAlias = original.myKeyAlias;
        this.myProvider = original.myProvider;
        this.myTsa = original.myTsa;
    }

    @NotNull
    public JpsAirSigningOptionsImpl createCopy() {
        JpsAirSigningOptionsImpl jpsAirSigningOptionsImpl = new JpsAirSigningOptionsImpl(this);
        if (jpsAirSigningOptionsImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "createCopy"));
        }
        return jpsAirSigningOptionsImpl;
    }

    public void applyChanges(@NotNull JpsAirSigningOptionsImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "applyChanges"));
        }
        this.setUseTempCertificate(modified.isUseTempCertificate());
        this.setProvisioningProfilePath(modified.getProvisioningProfilePath());
        this.setKeystorePath(modified.getKeystorePath());
        this.setKeystoreType(modified.getKeystoreType());
        this.setKeyAlias(modified.getKeyAlias());
        this.setProvider(modified.getProvider());
        this.setTsa(modified.getTsa());
    }

    @Override
    public boolean isUseTempCertificate() {
        return this.myUseTempCertificate;
    }

    @Override
    public void setUseTempCertificate(boolean useTempCertificate) {
        this.myUseTempCertificate = useTempCertificate;
    }

    @Override
    @NotNull
    public String getProvisioningProfilePath() {
        String string = this.myProvisioningProfilePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "getProvisioningProfilePath"));
        }
        return string;
    }

    @Override
    public void setProvisioningProfilePath(@NotNull String provisioningProfilePath) {
        if (provisioningProfilePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provisioningProfilePath", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "setProvisioningProfilePath"));
        }
        this.myProvisioningProfilePath = FileUtil.toSystemIndependentName((String)provisioningProfilePath);
    }

    @Override
    @NotNull
    public String getKeystorePath() {
        String string = this.myKeystorePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "getKeystorePath"));
        }
        return string;
    }

    @Override
    public void setKeystorePath(@NotNull String keystorePath) {
        if (keystorePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keystorePath", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "setKeystorePath"));
        }
        this.myKeystorePath = FileUtil.toSystemIndependentName((String)keystorePath);
    }

    @Override
    @NotNull
    public String getKeystoreType() {
        String string = this.myKeystoreType;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "getKeystoreType"));
        }
        return string;
    }

    @Override
    public void setKeystoreType(@NotNull String keystoreType) {
        if (keystoreType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keystoreType", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "setKeystoreType"));
        }
        this.myKeystoreType = keystoreType;
    }

    @Override
    @NotNull
    public String getKeyAlias() {
        String string = this.myKeyAlias;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "getKeyAlias"));
        }
        return string;
    }

    @Override
    public void setKeyAlias(@NotNull String keyAlias) {
        if (keyAlias == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyAlias", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "setKeyAlias"));
        }
        this.myKeyAlias = keyAlias;
    }

    @Override
    @NotNull
    public String getProvider() {
        String string = this.myProvider;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "getProvider"));
        }
        return string;
    }

    @Override
    public void setProvider(@NotNull String provider) {
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "setProvider"));
        }
        this.myProvider = provider;
    }

    @Override
    @NotNull
    public String getTsa() {
        String string = this.myTsa;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "getTsa"));
        }
        return string;
    }

    @Override
    public void setTsa(@NotNull String tsa) {
        if (tsa == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tsa", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl", "setTsa"));
        }
        this.myTsa = tsa;
    }

    State getState() {
        State state = new State();
        state.USE_TEMP_CERTIFICATE = this.myUseTempCertificate;
        state.PROVISIONING_PROFILE_PATH = this.myProvisioningProfilePath;
        state.KEYSTORE_PATH = this.myKeystorePath;
        state.KEYSTORE_TYPE = this.myKeystoreType;
        state.KEY_ALIAS = this.myKeyAlias;
        state.PROVIDER = this.myProvider;
        state.TSA = this.myTsa;
        return state;
    }

    void loadState(State state) {
        this.myUseTempCertificate = state.USE_TEMP_CERTIFICATE;
        this.myProvisioningProfilePath = state.PROVISIONING_PROFILE_PATH;
        this.myKeystorePath = state.KEYSTORE_PATH;
        this.myKeystoreType = state.KEYSTORE_TYPE;
        this.myKeyAlias = state.KEY_ALIAS;
        this.myProvider = state.PROVIDER;
        this.myTsa = state.TSA;
    }

    @Tag(value="AirSigningOptions")
    public static class State {
        @Attribute(value="use-temp-certificate")
        public boolean USE_TEMP_CERTIFICATE = true;
        @Attribute(value="provisioning-profile-path")
        public String PROVISIONING_PROFILE_PATH = "";
        @Attribute(value="keystore-path")
        public String KEYSTORE_PATH = "";
        @Attribute(value="keystore-type")
        public String KEYSTORE_TYPE = "";
        @Attribute(value="key-alias")
        public String KEY_ALIAS = "";
        @Attribute(value="provider")
        public String PROVIDER = "";
        @Attribute(value="tsa")
        public String TSA = "";
    }

    private static class JpsAirSigningOptionsRole
    extends JpsElementChildRoleBase<JpsAirSigningOptions>
    implements JpsElementCreator<JpsAirSigningOptions> {
        protected JpsAirSigningOptionsRole() {
            super("air signing options");
        }

        @NotNull
        public JpsAirSigningOptions create() {
            JpsAirSigningOptionsImpl jpsAirSigningOptionsImpl = new JpsAirSigningOptionsImpl();
            if (jpsAirSigningOptionsImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/model/bc/impl/JpsAirSigningOptionsImpl$JpsAirSigningOptionsRole", "create"));
            }
            return jpsAirSigningOptionsImpl;
        }
    }
}

