/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.util.ArrayUtil;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CharsetToolkit {
    @NonNls
    public static final String UTF8 = "UTF-8";
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    public static final Charset UTF_16LE_CHARSET = Charset.forName("UTF-16LE");
    public static final Charset UTF_16BE_CHARSET = Charset.forName("UTF-16BE");
    public static final Charset UTF_32BE_CHARSET = Charset.forName("UTF-32BE");
    public static final Charset UTF_32LE_CHARSET = Charset.forName("UTF-32LE");
    public static final Charset UTF_16_CHARSET = Charset.forName("UTF-16");
    private static final byte FF = -1;
    private static final byte FE = -2;
    private static final byte EF = -17;
    private static final byte BB = -69;
    private static final byte BF = -65;
    private static final int BINARY_THRESHOLD = 9;
    private final byte[] buffer;
    @NotNull
    private final Charset defaultCharset;
    private boolean enforce8Bit;
    public static final byte[] UTF8_BOM = new byte[]{-17, -69, -65};
    public static final byte[] UTF16LE_BOM = new byte[]{-1, -2};
    public static final byte[] UTF16BE_BOM = new byte[]{-2, -1};
    public static final byte[] UTF32BE_BOM = new byte[]{0, 0, -2, -1};
    public static final byte[] UTF32LE_BOM = new byte[]{-1, -2, 0, 0};
    @NonNls
    public static final String FILE_ENCODING_PROPERTY = "file.encoding";
    @NonNls
    private static final Map<Charset, byte[]> CHARSET_TO_MANDATORY_BOM = new THashMap(2);

    public CharsetToolkit(@NotNull byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/vfs/CharsetToolkit", "<init>"));
        }
        this.enforce8Bit = false;
        this.buffer = buffer;
        this.defaultCharset = CharsetToolkit.getDefaultSystemCharset();
    }

    public CharsetToolkit(@NotNull byte[] buffer, @NotNull Charset defaultCharset) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/vfs/CharsetToolkit", "<init>"));
        }
        if (defaultCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCharset", "com/intellij/openapi/vfs/CharsetToolkit", "<init>"));
        }
        this.enforce8Bit = false;
        this.buffer = buffer;
        this.defaultCharset = defaultCharset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static InputStream inputStreamSkippingBOM(@NotNull InputStream stream) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
        }
        assert (stream.markSupported()) : stream;
        stream.mark(4);
        boolean mustReset = true;
        int ret = stream.read();
        if (ret == -1) {
            InputStream inputStream = stream;
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
            }
            return inputStream2;
        }
        byte b0 = (byte)ret;
        if (b0 != -17 && b0 != -1 && b0 != -2 && b0 != 0) {
            InputStream inputStream = stream;
            InputStream inputStream3 = inputStream;
            if (inputStream3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
            }
            return inputStream3;
        }
        ret = stream.read();
        if (ret == -1) {
            InputStream inputStream = stream;
            InputStream inputStream4 = inputStream;
            if (inputStream4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
            }
            return inputStream4;
        }
        byte b1 = (byte)ret;
        if (b0 == -1 && b1 == -2) {
            stream.mark(2);
            ret = stream.read();
            if (ret == -1) {
                InputStream inputStream = stream;
                InputStream inputStream5 = inputStream;
                if (inputStream5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream5;
            }
            byte b2 = (byte)ret;
            if (b2 != 0) {
                InputStream inputStream = stream;
                InputStream inputStream6 = inputStream;
                if (inputStream6 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream6;
            }
            ret = stream.read();
            if (ret == -1) {
                InputStream inputStream = stream;
                InputStream inputStream7 = inputStream;
                if (inputStream7 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream7;
            }
            byte b3 = (byte)ret;
            if (b3 != 0) {
                InputStream inputStream = stream;
                InputStream inputStream8 = inputStream;
                if (inputStream8 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream8;
            }
            mustReset = false;
            InputStream inputStream = stream;
            InputStream inputStream9 = inputStream;
            if (inputStream9 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
            }
            return inputStream9;
        }
        if (b0 == -2 && b1 == -1) {
            mustReset = false;
            InputStream b2 = stream;
            InputStream inputStream = b2;
            if (inputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
            }
            return inputStream;
        }
        if (b0 == -17 && b1 == -69) {
            ret = stream.read();
            if (ret == -1) {
                InputStream b2 = stream;
                InputStream inputStream = b2;
                if (inputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream;
            }
            byte b2 = (byte)ret;
            if (b2 == -65) {
                mustReset = false;
                InputStream b3 = stream;
                InputStream inputStream = b3;
                if (inputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream;
            }
            InputStream b3 = stream;
            InputStream inputStream = b3;
            if (inputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
            }
            return inputStream;
        }
        if (b0 == 0 && b1 == 0) {
            ret = stream.read();
            if (ret == -1) {
                InputStream b2 = stream;
                InputStream inputStream = b2;
                if (inputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream;
            }
            byte b2 = (byte)ret;
            if (b2 != -2) {
                InputStream b3 = stream;
                InputStream inputStream = b3;
                if (inputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream;
            }
            ret = stream.read();
            if (ret == -1) {
                InputStream b3 = stream;
                InputStream inputStream = b3;
                if (inputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream;
            }
            byte b3 = (byte)ret;
            if (b3 != -1) {
                InputStream inputStream = stream;
                InputStream inputStream10 = inputStream;
                if (inputStream10 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
                }
                return inputStream10;
            }
            mustReset = false;
            InputStream inputStream = stream;
            InputStream inputStream11 = inputStream;
            if (inputStream11 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
            }
            return inputStream11;
        }
        InputStream inputStream = stream;
        InputStream inputStream12 = inputStream;
        if (inputStream12 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "inputStreamSkippingBOM"));
        }
        return inputStream12;
        finally {
            if (mustReset) {
                stream.reset();
            }
        }
    }

    public void setEnforce8Bit(boolean enforce) {
        this.enforce8Bit = enforce;
    }

    public boolean getEnforce8Bit() {
        return this.enforce8Bit;
    }

    @NotNull
    public Charset getDefaultCharset() {
        Charset charset = this.defaultCharset;
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "getDefaultCharset"));
        }
        return charset;
    }

    public Charset guessEncoding(int guess_length, @NotNull Charset defaultCharset) {
        if (defaultCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCharset", "com/intellij/openapi/vfs/CharsetToolkit", "guessEncoding"));
        }
        Charset charset = this.guessFromBOM();
        if (charset != null) {
            return charset;
        }
        GuessedEncoding encoding = this.guessFromContent(guess_length);
        switch (encoding) {
            case SEVEN_BIT: {
                return this.enforce8Bit ? defaultCharset : Charset.forName("US-ASCII");
            }
            case INVALID_UTF8: {
                return defaultCharset;
            }
            case VALID_UTF8: {
                return UTF8_CHARSET;
            }
            case BINARY: {
                break;
            }
        }
        return null;
    }

    @NotNull
    public static String bytesToString(@NotNull byte[] bytes, @NotNull Charset defaultCharset) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vfs/CharsetToolkit", "bytesToString"));
        }
        if (defaultCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCharset", "com/intellij/openapi/vfs/CharsetToolkit", "bytesToString"));
        }
        Charset charset = new CharsetToolkit(bytes, defaultCharset).guessEncoding(bytes.length);
        if (charset == null) {
            charset = defaultCharset;
        }
        String string = CharsetToolkit.decodeString(bytes, charset);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "bytesToString"));
        }
        return string;
    }

    @NotNull
    public static String decodeString(@NotNull byte[] bytes, @NotNull Charset charset) {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vfs/CharsetToolkit", "decodeString"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "decodeString"));
        }
        int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
        CharBuffer charBuffer = charset.decode(ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength));
        String string = charBuffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "decodeString"));
        }
        return string;
    }

    @NotNull
    public static String tryDecodeString(@NotNull byte[] bytes, @NotNull Charset charset) throws CharacterCodingException {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/openapi/vfs/CharsetToolkit", "tryDecodeString"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "tryDecodeString"));
        }
        int bomLength = CharsetToolkit.getBOMLength(bytes, charset);
        ByteBuffer buffer = ByteBuffer.wrap(bytes, bomLength, bytes.length - bomLength);
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
        String string = decoder.decode(buffer).toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "tryDecodeString"));
        }
        return string;
    }

    @NotNull
    public GuessedEncoding guessFromContent(int guess_length) {
        boolean highOrderBit = false;
        boolean validU8Char = true;
        boolean hasBinary = false;
        int length = Math.min(this.buffer.length, guess_length);
        for (int i = 0; i < length; ++i) {
            byte b5;
            byte b0 = this.buffer[i];
            byte b1 = i + 1 >= length ? (byte)0 : this.buffer[i + 1];
            byte b2 = i + 2 >= length ? (byte)0 : this.buffer[i + 2];
            byte b3 = i + 3 >= length ? (byte)0 : this.buffer[i + 3];
            byte b4 = i + 4 >= length ? (byte)0 : this.buffer[i + 4];
            byte by = b5 = i + 5 >= length ? (byte)0 : this.buffer[i + 5];
            if (b0 < 0) {
                highOrderBit = true;
                if (CharsetToolkit.isTwoBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1)) {
                        validU8Char = false;
                    } else {
                        ++i;
                    }
                } else if (CharsetToolkit.isThreeBytesSequence(b0)) {
                    if (!CharsetToolkit.isContinuationChar(b1) || !CharsetToolkit.isContinuationChar(b2)) {
                        validU8Char = false;
                    } else {
                        i += 2;
                    }
                } else if (CharsetToolkit.isFourBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3))) {
                        validU8Char = false;
                    } else {
                        i += 3;
                    }
                } else if (CharsetToolkit.isFiveBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4))) {
                        validU8Char = false;
                    } else {
                        i += 4;
                    }
                } else if (CharsetToolkit.isSixBytesSequence(b0)) {
                    if (!(CharsetToolkit.isContinuationChar(b1) && CharsetToolkit.isContinuationChar(b2) && CharsetToolkit.isContinuationChar(b3) && CharsetToolkit.isContinuationChar(b4) && CharsetToolkit.isContinuationChar(b5))) {
                        validU8Char = false;
                    } else {
                        i += 5;
                    }
                } else {
                    validU8Char = false;
                }
            } else if (b0 < 9) {
                hasBinary = true;
            }
            if (!validU8Char) break;
        }
        if (!highOrderBit && !hasBinary) {
            GuessedEncoding guessedEncoding = GuessedEncoding.SEVEN_BIT;
            if (guessedEncoding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromContent"));
            }
            return guessedEncoding;
        }
        if (!validU8Char) {
            GuessedEncoding guessedEncoding = GuessedEncoding.INVALID_UTF8;
            if (guessedEncoding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromContent"));
            }
            return guessedEncoding;
        }
        if (hasBinary) {
            GuessedEncoding guessedEncoding = GuessedEncoding.BINARY;
            if (guessedEncoding == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromContent"));
            }
            return guessedEncoding;
        }
        GuessedEncoding guessedEncoding = GuessedEncoding.VALID_UTF8;
        if (guessedEncoding == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromContent"));
        }
        return guessedEncoding;
    }

    @Nullable
    public Charset guessFromBOM() {
        return CharsetToolkit.guessFromBOM(this.buffer);
    }

    @Nullable
    public static Charset guessFromBOM(@NotNull byte[] buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/openapi/vfs/CharsetToolkit", "guessFromBOM"));
        }
        if (CharsetToolkit.hasUTF8Bom(buffer)) {
            return UTF8_CHARSET;
        }
        if (CharsetToolkit.hasUTF32BEBom(buffer)) {
            return UTF_32BE_CHARSET;
        }
        if (CharsetToolkit.hasUTF32LEBom(buffer)) {
            return UTF_32LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16LEBom(buffer)) {
            return UTF_16LE_CHARSET;
        }
        if (CharsetToolkit.hasUTF16BEBom(buffer)) {
            return UTF_16BE_CHARSET;
        }
        return null;
    }

    public Charset guessEncoding(int guess_length) {
        return this.guessEncoding(guess_length, this.defaultCharset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Charset guessEncoding(@NotNull File f, int bufferLength, @NotNull Charset defaultCharset) throws IOException {
        int read;
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/openapi/vfs/CharsetToolkit", "guessEncoding"));
        }
        if (defaultCharset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultCharset", "com/intellij/openapi/vfs/CharsetToolkit", "guessEncoding"));
        }
        byte[] buffer = new byte[bufferLength];
        FileInputStream fis = new FileInputStream(f);
        try {
            read = fis.read(buffer);
        }
        finally {
            fis.close();
        }
        CharsetToolkit toolkit = new CharsetToolkit(buffer, defaultCharset);
        return toolkit.guessEncoding(read);
    }

    private static boolean isContinuationChar(byte b) {
        return -128 <= b && b <= -65;
    }

    private static boolean isTwoBytesSequence(byte b) {
        return -64 <= b && b <= -33;
    }

    private static boolean isThreeBytesSequence(byte b) {
        return -32 <= b && b <= -17;
    }

    private static boolean isFourBytesSequence(byte b) {
        return -16 <= b && b <= -9;
    }

    private static boolean isFiveBytesSequence(byte b) {
        return -8 <= b && b <= -5;
    }

    private static boolean isSixBytesSequence(byte b) {
        return -4 <= b && b <= -3;
    }

    @NotNull
    public static Charset getDefaultSystemCharset() {
        Charset charset = Charset.defaultCharset();
        if (charset == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "getDefaultSystemCharset"));
        }
        return charset;
    }

    public static boolean hasUTF8Bom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bom", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF8Bom"));
        }
        return ArrayUtil.startsWith(bom, UTF8_BOM);
    }

    public static boolean hasUTF16LEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bom", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF16LEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF16LE_BOM);
    }

    public static boolean hasUTF16BEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bom", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF16BEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF16BE_BOM);
    }

    public static boolean hasUTF32BEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bom", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF32BEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF32BE_BOM);
    }

    public static boolean hasUTF32LEBom(@NotNull byte[] bom) {
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bom", "com/intellij/openapi/vfs/CharsetToolkit", "hasUTF32LEBom"));
        }
        return ArrayUtil.startsWith(bom, UTF32LE_BOM);
    }

    @NotNull
    public static Charset[] getAvailableCharsets() {
        Collection<Charset> collection = Charset.availableCharsets().values();
        Charset[] charsetArray = collection.toArray(new Charset[collection.size()]);
        if (charsetArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "getAvailableCharsets"));
        }
        return charsetArray;
    }

    @NotNull
    public static byte[] getUtf8Bytes(@NotNull String s) {
        byte[] byArray;
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/openapi/vfs/CharsetToolkit", "getUtf8Bytes"));
        }
        try {
            byArray = s.getBytes(UTF8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 must be supported", e);
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/CharsetToolkit", "getUtf8Bytes"));
        }
        return byArray;
    }

    public static int getBOMLength(@NotNull byte[] content, @NotNull Charset charset) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/vfs/CharsetToolkit", "getBOMLength"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "getBOMLength"));
        }
        if (charset.name().contains(UTF8) && CharsetToolkit.hasUTF8Bom(content)) {
            return UTF8_BOM.length;
        }
        if (CharsetToolkit.hasUTF32BEBom(content)) {
            return UTF32BE_BOM.length;
        }
        if (CharsetToolkit.hasUTF32BEBom(content)) {
            return UTF32BE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16LEBom(content)) {
            return UTF16LE_BOM.length;
        }
        if (CharsetToolkit.hasUTF16BEBom(content)) {
            return UTF16BE_BOM.length;
        }
        return 0;
    }

    @Nullable
    public static byte[] getMandatoryBom(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "getMandatoryBom"));
        }
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    @Nullable
    public static byte[] getBom(@NotNull Charset charset) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "getBom"));
        }
        if (charset.equals(UTF8_CHARSET)) {
            return UTF8_BOM;
        }
        return CHARSET_TO_MANDATORY_BOM.get(charset);
    }

    public static boolean canHaveBom(@NotNull Charset charset, @NotNull byte[] bom) {
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/openapi/vfs/CharsetToolkit", "canHaveBom"));
        }
        if (bom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bom", "com/intellij/openapi/vfs/CharsetToolkit", "canHaveBom"));
        }
        return charset.equals(UTF8_CHARSET) && Arrays.equals(bom, UTF8_BOM) || Arrays.equals(CharsetToolkit.getMandatoryBom(charset), bom);
    }

    @Nullable
    public static Charset forName(@Nullable String name) {
        Charset charset = null;
        if (name != null) {
            try {
                charset = Charset.forName(name);
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
                // empty catch block
            }
        }
        return charset;
    }

    static {
        CHARSET_TO_MANDATORY_BOM.put(UTF_16LE_CHARSET, UTF16LE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_16BE_CHARSET, UTF16BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32BE_CHARSET, UTF32BE_BOM);
        CHARSET_TO_MANDATORY_BOM.put(UTF_32LE_CHARSET, UTF32LE_BOM);
    }

    public static enum GuessedEncoding {
        SEVEN_BIT,
        VALID_UTF8,
        INVALID_UTF8,
        BINARY;

    }
}

