/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.devices;

public enum Abi {
    ARMEABI("armeabi", 4, "ARM", "arm"),
    ARMEABI_V7A("armeabi-v7a", 4, "ARM", "arm", "cortex-a8"),
    ARM64_V8A("arm64-v8a", 8, "ARM", "arm64"),
    X86("x86", 4, "Intel Atom", "x86"),
    X86_64("x86_64", 8, "Intel Atom", "x86_64"),
    MIPS("mips", 4, "MIPS", "mips"),
    MIPS64("mips64", 8, "MIPS", "mips64");

    private final String mAbi;
    private final int mAddressSizeInBytes;
    private final String mCpuArch;
    private final String mCpuModel;
    private final String mDisplayName;

    private Abi(String abi, int addrSizeInBytes, String displayName, String cpuArch) {
        this(abi, addrSizeInBytes, displayName, cpuArch, null);
    }

    private Abi(String abi, int addrSizeInBytes, String displayName, String cpuArch, String cpuModel) {
        this.mAbi = abi;
        this.mAddressSizeInBytes = addrSizeInBytes;
        this.mDisplayName = displayName;
        this.mCpuArch = cpuArch;
        this.mCpuModel = cpuModel;
    }

    public static Abi getEnum(String abi) {
        for (Abi a : Abi.values()) {
            if (!a.mAbi.equals(abi)) continue;
            return a;
        }
        return null;
    }

    public String toString() {
        return this.mAbi;
    }

    public String getCpuArch() {
        return this.mCpuArch;
    }

    public int getAddressSizeInBytes() {
        return this.mAddressSizeInBytes;
    }

    public String getCpuModel() {
        return this.mCpuModel;
    }

    public String getDisplayName() {
        return this.mDisplayName;
    }

    public boolean supportsMultipleCpuCores() {
        return this == X86 || this == X86_64;
    }
}

