/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.Comparing;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsUrlList;
import org.jetbrains.jps.model.ex.JpsCompositeElementBase;
import org.jetbrains.jps.model.impl.JpsUrlListRole;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.LanguageLevel;

public class JpsJavaModuleExtensionImpl
extends JpsCompositeElementBase<JpsJavaModuleExtensionImpl>
implements JpsJavaModuleExtension {
    private static final JpsUrlListRole JAVADOC_ROOTS_ROLE = new JpsUrlListRole("javadoc roots");
    private static final JpsUrlListRole ANNOTATIONS_ROOTS_ROLE = new JpsUrlListRole("annotation roots");
    private String myOutputUrl;
    private String myTestOutputUrl;
    private boolean myInheritOutput;
    private boolean myExcludeOutput;
    private LanguageLevel myLanguageLevel;

    public JpsJavaModuleExtensionImpl() {
        this.myContainer.setChild(JAVADOC_ROOTS_ROLE);
        this.myContainer.setChild(ANNOTATIONS_ROOTS_ROLE);
    }

    private JpsJavaModuleExtensionImpl(JpsJavaModuleExtensionImpl original) {
        super(original);
        this.myOutputUrl = original.myOutputUrl;
        this.myTestOutputUrl = original.myTestOutputUrl;
        this.myLanguageLevel = original.myLanguageLevel;
    }

    @Override
    @NotNull
    public JpsJavaModuleExtensionImpl createCopy() {
        JpsJavaModuleExtensionImpl jpsJavaModuleExtensionImpl = new JpsJavaModuleExtensionImpl(this);
        if (jpsJavaModuleExtensionImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaModuleExtensionImpl", "createCopy"));
        }
        return jpsJavaModuleExtensionImpl;
    }

    @Override
    @NotNull
    public JpsUrlList getAnnotationRoots() {
        JpsUrlList jpsUrlList = this.myContainer.getChild(ANNOTATIONS_ROOTS_ROLE);
        if (jpsUrlList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaModuleExtensionImpl", "getAnnotationRoots"));
        }
        return jpsUrlList;
    }

    @Override
    @NotNull
    public JpsUrlList getJavadocRoots() {
        JpsUrlList jpsUrlList = this.myContainer.getChild(JAVADOC_ROOTS_ROLE);
        if (jpsUrlList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JpsJavaModuleExtensionImpl", "getJavadocRoots"));
        }
        return jpsUrlList;
    }

    @Override
    public String getOutputUrl() {
        return this.myOutputUrl;
    }

    @Override
    public void setOutputUrl(String outputUrl) {
        if (!Comparing.equal((String)this.myOutputUrl, (String)outputUrl)) {
            this.myOutputUrl = outputUrl;
            this.fireElementChanged();
        }
    }

    @Override
    public String getTestOutputUrl() {
        return this.myTestOutputUrl;
    }

    @Override
    public void setTestOutputUrl(String testOutputUrl) {
        if (!Comparing.equal((String)this.myTestOutputUrl, (String)testOutputUrl)) {
            this.myTestOutputUrl = testOutputUrl;
            this.fireElementChanged();
        }
    }

    @Override
    public LanguageLevel getLanguageLevel() {
        return this.myLanguageLevel;
    }

    @Override
    public void setLanguageLevel(LanguageLevel languageLevel) {
        if (!Comparing.equal((Object)((Object)this.myLanguageLevel), (Object)((Object)languageLevel))) {
            this.myLanguageLevel = languageLevel;
            this.fireElementChanged();
        }
    }

    @Override
    public void applyChanges(@NotNull JpsJavaModuleExtensionImpl modified) {
        if (modified == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modified", "org/jetbrains/jps/model/java/impl/JpsJavaModuleExtensionImpl", "applyChanges"));
        }
        this.setLanguageLevel(modified.myLanguageLevel);
        this.setInheritOutput(modified.myInheritOutput);
        this.setExcludeOutput(modified.myExcludeOutput);
        this.setOutputUrl(modified.myOutputUrl);
        this.setTestOutputUrl(modified.myTestOutputUrl);
    }

    @Override
    public boolean isInheritOutput() {
        return this.myInheritOutput;
    }

    @Override
    public void setInheritOutput(boolean inheritOutput) {
        if (this.myInheritOutput != inheritOutput) {
            this.myInheritOutput = inheritOutput;
            this.fireElementChanged();
        }
    }

    @Override
    public boolean isExcludeOutput() {
        return this.myExcludeOutput;
    }

    @Override
    public void setExcludeOutput(boolean excludeOutput) {
        if (this.myExcludeOutput != excludeOutput) {
            this.myExcludeOutput = excludeOutput;
            this.fireElementChanged();
        }
    }
}

