/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.AndroidJpsProjectUtil;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.builders.ModuleBasedTarget;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.TargetTypeRegistry;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidManifestMergingTarget
extends ModuleBasedTarget<MyRootDescriptor> {
    public AndroidManifestMergingTarget(ModuleBasedBuildTargetType<?> targetType, @NotNull JpsModule module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/android/AndroidManifestMergingTarget", "<init>"));
        }
        super(targetType, module);
    }

    public boolean isCompiledBeforeModuleLevelBuilders() {
        return true;
    }

    public boolean isTests() {
        return false;
    }

    public String getId() {
        return this.myModule.getName();
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        BuildTargetType mavenResourcesProductionType = TargetTypeRegistry.getInstance().getTargetType("maven-resources-production");
        if (mavenResourcesProductionType != null) {
            return new ArrayList(targetRegistry.getAllTargets(mavenResourcesProductionType));
        }
        return Collections.emptyList();
    }

    public void writeConfiguration(ProjectDescriptor pd, PrintWriter out) {
    }

    @NotNull
    public List<MyRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(this.myModule);
        assert (extension != null);
        ArrayList<MyRootDescriptor> result = new ArrayList<MyRootDescriptor>();
        File manifestFile = AndroidJpsUtil.getManifestFileForCompilationPath(extension);
        if (manifestFile != null) {
            result.add(new MyRootDescriptor((BuildTarget)this, manifestFile, false));
        }
        for (JpsAndroidModuleExtension libExtension : AndroidJpsUtil.getAllAndroidDependencies(this.myModule, true)) {
            File libManifest = AndroidJpsUtil.getManifestFileForCompilationPath(libExtension);
            if (libManifest == null || !libManifest.exists()) continue;
            result.add(new MyRootDescriptor((BuildTarget)this, libManifest, true));
        }
        ArrayList<MyRootDescriptor> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingTarget", "computeRootDescriptors"));
        }
        return arrayList;
    }

    @Nullable
    public MyRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (MyRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    @NotNull
    public String getPresentableName() {
        if ("Android Manifest Merging" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingTarget", "getPresentableName"));
        }
        return "Android Manifest Merging";
    }

    @NotNull
    public Collection<File> getOutputRoots(CompileContext context) {
        List<File> list = Collections.singletonList(this.getOutputDirectory(context));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingTarget", "getOutputRoots"));
        }
        return list;
    }

    @NotNull
    public File getOutputDirectory(@NotNull CompileContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/jps/android/AndroidManifestMergingTarget", "getOutputDirectory"));
        }
        File file = AndroidJpsUtil.getPreprocessedManifestDirectory(this.myModule, context.getProjectDescriptor().dataManager.getDataPaths());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingTarget", "getOutputDirectory"));
        }
        return file;
    }

    public static class MyRootDescriptor
    extends BuildRootDescriptorImpl {
        private final boolean myLibManifestRoot;

        private MyRootDescriptor(@NotNull BuildTarget target, @NotNull File root, boolean libManifestRoot) {
            if (target == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyRootDescriptor", "<init>"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyRootDescriptor", "<init>"));
            }
            super(target, root);
            this.myLibManifestRoot = libManifestRoot;
        }

        public boolean isLibManifestRoot() {
            return this.myLibManifestRoot;
        }
    }

    public static class MyTargetType
    extends ModuleBasedBuildTargetType<AndroidManifestMergingTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-manifest-merging");
        }

        @NotNull
        public List<AndroidManifestMergingTarget> computeAllTargets(@NotNull JpsModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType", "computeAllTargets"));
            }
            if (!AndroidJpsProjectUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
                List<AndroidManifestMergingTarget> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType", "computeAllTargets"));
                }
                return list;
            }
            ArrayList<AndroidManifestMergingTarget> targets = new ArrayList<AndroidManifestMergingTarget>();
            for (JpsModule module : model.getProject().getModules()) {
                JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
                if (extension == null || extension.isLibrary() || !extension.isManifestMergingEnabled()) continue;
                targets.add(new AndroidManifestMergingTarget(this, module));
            }
            ArrayList<AndroidManifestMergingTarget> arrayList = targets;
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType", "computeAllTargets"));
            }
            return arrayList;
        }

        @NotNull
        public BuildTargetLoader<AndroidManifestMergingTarget> createLoader(@NotNull JpsModel model) {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType", "createLoader"));
            }
            final HashMap<String, AndroidManifestMergingTarget> targetMap = new HashMap<String, AndroidManifestMergingTarget>();
            for (AndroidManifestMergingTarget target : this.computeAllTargets(model)) {
                targetMap.put(target.getId(), target);
            }
            BuildTargetLoader<AndroidManifestMergingTarget> buildTargetLoader = new BuildTargetLoader<AndroidManifestMergingTarget>(){

                @Nullable
                public AndroidManifestMergingTarget createTarget(@NotNull String targetId) {
                    if (targetId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType$1", "createTarget"));
                    }
                    return (AndroidManifestMergingTarget)((Object)targetMap.get(targetId));
                }
            };
            if (buildTargetLoader == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/android/AndroidManifestMergingTarget$MyTargetType", "createLoader"));
            }
            return buildTargetLoader;
        }
    }
}

