/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompoundRuntimeException
extends RuntimeException {
    private final List<Throwable> myExceptions;

    public CompoundRuntimeException(@NotNull List<Throwable> throwables) {
        if (throwables == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwables", "com/intellij/util/lang/CompoundRuntimeException", "<init>"));
        }
        this.myExceptions = throwables;
    }

    @Override
    public String getMessage() {
        return this.processAll(new Function<Throwable, String>(){

            @Override
            public String fun(Throwable throwable) {
                return throwable.getMessage();
            }
        }, EmptyConsumer.<String>getInstance());
    }

    @Override
    public String getLocalizedMessage() {
        return this.processAll(new Function<Throwable, String>(){

            @Override
            public String fun(Throwable throwable) {
                return throwable.getLocalizedMessage();
            }
        }, EmptyConsumer.<String>getInstance());
    }

    @Override
    public String toString() {
        return this.processAll(new Function<Throwable, String>(){

            @Override
            public String fun(Throwable throwable) {
                return throwable.toString();
            }
        }, EmptyConsumer.<String>getInstance());
    }

    @Override
    public void printStackTrace(final PrintStream s) {
        this.processAll(new Function<Throwable, String>(){

            @Override
            public String fun(Throwable throwable) {
                throwable.printStackTrace(s);
                return "";
            }
        }, new Consumer<String>(){

            @Override
            public void consume(String str) {
                s.print(str);
            }
        });
    }

    @Override
    public void printStackTrace(final PrintWriter s) {
        this.processAll(new Function<Throwable, String>(){

            @Override
            public String fun(Throwable throwable) {
                throwable.printStackTrace(s);
                return "";
            }
        }, new Consumer<String>(){

            @Override
            public void consume(String str) {
                s.print(str);
            }
        });
    }

    private String processAll(@NotNull Function<Throwable, String> exceptionProcessor, @NotNull Consumer<String> stringProcessor) {
        if (exceptionProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionProcessor", "com/intellij/util/lang/CompoundRuntimeException", "processAll"));
        }
        if (stringProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringProcessor", "com/intellij/util/lang/CompoundRuntimeException", "processAll"));
        }
        if (this.myExceptions.size() == 1) {
            Throwable throwable = this.myExceptions.get(0);
            String s = exceptionProcessor.fun(throwable);
            stringProcessor.consume(s);
            return s;
        }
        StringBuilder sb = new StringBuilder();
        String line = "CompositeException (" + this.myExceptions.size() + " nested):\n------------------------------\n";
        stringProcessor.consume(line);
        sb.append(line);
        for (int i = 0; i < this.myExceptions.size(); ++i) {
            Throwable exception = this.myExceptions.get(i);
            line = "[" + i + "]: ";
            stringProcessor.consume(line);
            sb.append(line);
            line = exceptionProcessor.fun(exception);
            if (line == null) {
                line = "null\n";
            } else if (!line.endsWith("\n")) {
                line = line + '\n';
            }
            stringProcessor.consume(line);
            sb.append(line);
        }
        line = "------------------------------\n";
        stringProcessor.consume(line);
        sb.append(line);
        return sb.toString();
    }

    public static void throwIfNotEmpty(@Nullable List<Throwable> throwables) {
        if (ContainerUtil.isEmpty(throwables)) {
            return;
        }
        if (throwables.size() != 1) {
            throw new CompoundRuntimeException(throwables);
        }
        ExceptionUtil.rethrow(throwables.get(0));
    }
}

