/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.java.impl;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileFilters;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSdkUtil {
    @NotNull
    public static List<File> getJdkClassesRoots(@NotNull File home, boolean isJre) {
        File classesDir;
        String[] ibmJdkVmJarDirs;
        Object toolsJar;
        File libDir;
        File[] jarDirs;
        if (home == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "home", "org/jetbrains/jps/model/java/impl/JavaSdkUtil", "getJdkClassesRoots"));
        }
        if (SystemInfo.isMac && !home.getName().startsWith("mockJDK")) {
            File libEndorsedDir;
            File libExtDir;
            File classesDir2;
            File libDir2;
            File openJdkRtJar = new File(home, "jre/lib/rt.jar");
            if (openJdkRtJar.exists() && !openJdkRtJar.isDirectory()) {
                libDir2 = new File(home, "lib");
                classesDir2 = openJdkRtJar.getParentFile();
                libExtDir = new File(openJdkRtJar.getParentFile(), "ext");
                libEndorsedDir = new File(libDir2, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir2, classesDir2, libExtDir};
            } else {
                libDir2 = new File(home, "lib");
                classesDir2 = new File(home, "../Classes");
                libExtDir = new File(libDir2, "ext");
                libEndorsedDir = new File(libDir2, "endorsed");
                jarDirs = new File[]{libEndorsedDir, libDir2, classesDir2, libExtDir};
            }
        } else if (new File(home, "lib/modules").exists()) {
            libDir = new File(home, "lib");
            jarDirs = new File[]{libDir};
        } else {
            libDir = new File(home, isJre ? "lib" : "jre/lib");
            File libExtDir = new File(libDir, "ext");
            File libEndorsedDir = new File(libDir, "endorsed");
            jarDirs = new File[]{libEndorsedDir, libDir, libExtDir};
        }
        FileFilter jarFileFilter = FileFilters.filesWithExtension((String)"jar");
        THashSet pathFilter = ContainerUtil.newTroveSet((TObjectHashingStrategy)FileUtil.PATH_HASHING_STRATEGY);
        ArrayList rootFiles = ContainerUtil.newArrayList();
        if (Registry.is((String)"project.structure.add.tools.jar.to.new.jdk") && ((File)(toolsJar = new File(home, "lib/tools.jar"))).isFile()) {
            rootFiles.add(toolsJar);
        }
        for (File jarDir : jarDirs) {
            File[] jarFiles;
            if (jarDir == null || !jarDir.isDirectory()) continue;
            for (File jarFile : jarFiles = (File[])ObjectUtils.notNull((Object)jarDir.listFiles(jarFileFilter), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                String canonicalPath;
                String jarFileName = jarFile.getName();
                if (jarFileName.equals("alt-rt.jar") || jarFileName.equals("alt-string.jar") || (canonicalPath = JavaSdkUtil.getCanonicalPath(jarFile)) == null || !pathFilter.add(canonicalPath)) continue;
                rootFiles.add(jarFile);
            }
        }
        for (String relativePath : ibmJdkVmJarDirs = new String[]{"bin/default", "lib/i386/default", "lib/amd64/default"}) {
            File[] vmJarDirs;
            File libDir3 = new File(home, isJre ? relativePath : "jre/" + relativePath);
            for (File dir : vmJarDirs = (File[])ObjectUtils.notNull((Object)libDir3.listFiles(FileUtilRt.ALL_DIRECTORIES), (Object)ArrayUtil.EMPTY_FILE_ARRAY)) {
                File vmJar;
                if (!dir.getName().startsWith("jclSC") || !(vmJar = new File(dir, "vm.jar")).isFile()) continue;
                rootFiles.add(vmJar);
            }
        }
        File classesZip = new File(home, "lib/classes.zip");
        if (classesZip.isFile()) {
            rootFiles.add(classesZip);
        }
        if (rootFiles.isEmpty() && (classesDir = new File(home, "classes")).isDirectory()) {
            rootFiles.add(classesDir);
        }
        ArrayList arrayList = rootFiles;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/model/java/impl/JavaSdkUtil", "getJdkClassesRoots"));
        }
        return arrayList;
    }

    @Nullable
    private static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }
}

