/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gradle.model.impl;

import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.gradle.model.JpsGradleExtensionService;
import org.jetbrains.jps.gradle.model.artifacts.JpsGradleArtifactExtension;
import org.jetbrains.jps.gradle.model.impl.artifacts.GradleArtifactExtensionProperties;
import org.jetbrains.jps.gradle.model.impl.artifacts.JpsGradleArtifactExtensionImpl;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.artifact.JpsArtifactExtensionSerializer;

public class JpsGradleModelSerializationExtension
extends JpsModelSerializerExtension {
    private static final String PRODUCTION_ON_TEST_ATTRIBUTE = "production-on-test";

    public void loadModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "loadModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "loadModuleOptions"));
        }
        if ("GRADLE".equals(rootElement.getAttributeValue("external.system.id"))) {
            JpsGradleExtensionService.getInstance().getOrCreateExtension(module, rootElement);
        }
    }

    public void saveModuleOptions(@NotNull JpsModule module, @NotNull Element rootElement) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "saveModuleOptions"));
        }
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "saveModuleOptions"));
        }
        if (JpsGradleExtensionService.getInstance().getExtension(module) != null) {
            rootElement.setAttribute("external.system.id", "GRADLE");
        }
    }

    public void loadModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        if (orderEntry.getAttributeValue(PRODUCTION_ON_TEST_ATTRIBUTE) != null) {
            JpsGradleExtensionService.getInstance().setProductionOnTestDependency(dependency, true);
        }
    }

    public void saveModuleDependencyProperties(JpsDependencyElement dependency, Element orderEntry) {
        if (JpsGradleExtensionService.getInstance().isProductionOnTestDependency(dependency)) {
            orderEntry.setAttribute(PRODUCTION_ON_TEST_ATTRIBUTE, "");
        }
    }

    @NotNull
    public List<? extends JpsArtifactExtensionSerializer<?>> getArtifactExtensionSerializers() {
        List<JpsGradleArtifactExtensionSerializer> list = Collections.singletonList(new JpsGradleArtifactExtensionSerializer("gradle-properties", JpsGradleArtifactExtensionImpl.ROLE));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension", "getArtifactExtensionSerializers"));
        }
        return list;
    }

    private static class JpsGradleArtifactExtensionSerializer
    extends JpsArtifactExtensionSerializer<JpsGradleArtifactExtension> {
        private JpsGradleArtifactExtensionSerializer(String id, JpsElementChildRole<JpsGradleArtifactExtension> role) {
            super(id, role);
        }

        public JpsGradleArtifactExtension loadExtension(@Nullable Element optionsTag) {
            GradleArtifactExtensionProperties properties = optionsTag != null ? (GradleArtifactExtensionProperties)XmlSerializer.deserialize((Element)optionsTag, GradleArtifactExtensionProperties.class) : null;
            return new JpsGradleArtifactExtensionImpl(properties != null ? properties : null);
        }

        public void saveExtension(@NotNull JpsGradleArtifactExtension extension, @NotNull Element optionsTag) {
            if (extension == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension$JpsGradleArtifactExtensionSerializer", "saveExtension"));
            }
            if (optionsTag == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "optionsTag", "org/jetbrains/jps/gradle/model/impl/JpsGradleModelSerializationExtension$JpsGradleArtifactExtensionSerializer", "saveExtension"));
            }
            GradleArtifactExtensionProperties properties = extension.getProperties();
            XmlSerializer.serializeInto((Object)properties, (Element)optionsTag, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        }
    }
}

