/*
 * Decompiled with CFR 0.152.
 */
package com.android.repository.impl.manager;

import com.android.repository.api.FallbackLocalRepoLoader;
import com.android.repository.api.License;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.api.Repository;
import com.android.repository.impl.manager.LocalRepoLoader;
import com.android.repository.impl.meta.CommonFactory;
import com.android.repository.impl.meta.LocalPackageImpl;
import com.android.repository.impl.meta.SchemaModuleUtil;
import com.android.repository.io.FileOp;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.bind.JAXBException;

public final class LocalRepoLoaderImpl
implements LocalRepoLoader {
    public static final String PACKAGE_XML_FN = "package.xml";
    private static final int MAX_SCAN_DEPTH = 10;
    private Map<String, LocalPackage> mPackages = null;
    private Set<File> mPackageRoots = null;
    private final File mRoot;
    private final RepoManager mRepoManager;
    private final FileOp mFop;
    private FallbackLocalRepoLoader mFallback;

    public LocalRepoLoaderImpl(File root, RepoManager manager, FallbackLocalRepoLoader fallback, FileOp fop) {
        this.mRoot = root;
        this.mRepoManager = manager;
        this.mFop = fop;
        this.mFallback = fallback;
    }

    @Override
    public byte[] getLocalPackagesHash() {
        Set<File> dirs = this.collectPackages();
        try {
            MessageDigest digester = MessageDigest.getInstance("md5");
            for (File f : dirs) {
                digester.update(f.getAbsolutePath().getBytes());
            }
            return digester.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }

    @Override
    public long getLatestPackageUpdateTime() {
        long latest = 0L;
        for (File f : this.collectPackages()) {
            long t = this.mFop.lastModified(f);
            latest = t > latest ? t : latest;
        }
        return latest;
    }

    @Override
    public Map<String, LocalPackage> getPackages(ProgressIndicator progress) {
        if (this.mPackages == null) {
            Set<File> possiblePackageDirs = this.collectPackages();
            this.mPackages = this.parsePackages(possiblePackageDirs, progress);
        }
        return Collections.unmodifiableMap(this.mPackages);
    }

    private Map<String, LocalPackage> parsePackages(Collection<File> possiblePackageDirs, ProgressIndicator progress) {
        HashMap result = Maps.newHashMap();
        for (File packageDir : possiblePackageDirs) {
            File packageXml = new File(packageDir, PACKAGE_XML_FN);
            LocalPackage p = null;
            if (this.mFop.exists(packageXml)) {
                try {
                    p = this.parsePackage(packageXml, progress);
                }
                catch (Exception e) {
                    progress.logWarning("Found corrupted package.xml at " + packageXml);
                }
            }
            if (p == null && this.mFallback != null) {
                p = this.mFallback.parseLegacyLocalPackage(packageDir, progress);
                if (p != null) {
                    this.writePackage(p, packageXml, progress);
                } else if (this.mFop.exists(packageXml)) {
                    progress.logWarning(String.format("Invalid package.xml found at %1$s and failed to parse using fallback.", packageXml));
                }
            }
            if (p == null) continue;
            this.addPackage(p, result, progress);
        }
        return result;
    }

    private Set<File> collectPackages() {
        if (this.mPackageRoots == null) {
            TreeSet dirs = Sets.newTreeSet();
            this.collectPackages(dirs, this.mRoot, 0);
            this.mPackageRoots = dirs;
        }
        return this.mPackageRoots;
    }

    private void collectPackages(Collection<File> collector, File root, int depth) {
        if (depth > 10) {
            return;
        }
        File packageXml = new File(root, PACKAGE_XML_FN);
        if (this.mFop.exists(packageXml) || this.mFallback != null && this.mFallback.shouldParse(root)) {
            collector.add(root);
        } else {
            for (File f : this.mFop.listFiles(root)) {
                if (!this.mFop.isDirectory(f)) continue;
                this.collectPackages(collector, f, depth + 1);
            }
        }
    }

    private void addPackage(LocalPackage p, Map<String, LocalPackage> collector, ProgressIndicator progress) {
        File actual;
        String filePath = p.getPath().replace(';', File.separatorChar);
        File desired = new File(this.mRoot, filePath);
        if (!desired.equals(actual = p.getLocation())) {
            progress.logWarning(String.format("Observed package id '%1$s' in inconsistent location '%2$s' (Expected '%3$s')", p.getPath(), actual.getPath(), desired.getPath()));
            LocalPackage existing = collector.get(p.getPath());
            if (existing != null) {
                progress.logWarning(String.format("Already observed package id '%1$s' in '%2$s'. Skipping duplicate at '%3$s'", p.getPath(), existing.getLocation().getPath(), actual.getPath()));
                return;
            }
        }
        collector.put(p.getPath(), p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePackage(LocalPackage p, File packageXml, ProgressIndicator progress) {
        LocalPackageImpl impl = LocalPackageImpl.create(p);
        OutputStream fos = null;
        try {
            fos = this.mFop.newFileOutputStream(packageXml);
            Repository repo = impl.createFactory().createRepositoryType();
            repo.setLocalPackage(impl);
            License license = impl.getLicense();
            if (license != null) {
                repo.addLicense(license);
            }
            CommonFactory factory = (CommonFactory)RepoManager.getCommonModule().createLatestFactory();
            SchemaModuleUtil.marshal(factory.generateRepository(repo), this.mRepoManager.getSchemaModules(), fos, this.mRepoManager.getResourceResolver(progress), progress);
        }
        catch (IOException e) {
            progress.logInfo("Exception while marshalling " + packageXml + ". Probably the SDK is read-only");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private LocalPackage parsePackage(File packageXml, ProgressIndicator progress) throws JAXBException {
        Repository repo;
        try {
            progress.logInfo("Parsing " + packageXml);
            repo = (Repository)SchemaModuleUtil.unmarshal(this.mFop.newFileInputStream(packageXml), this.mRepoManager.getSchemaModules(), this.mRepoManager.getResourceResolver(progress), false, progress);
        }
        catch (IOException e) {
            progress.logError(String.format("XML file %s doesn't exist", packageXml), e);
            return null;
        }
        if (repo == null) {
            progress.logWarning(String.format("Failed to parse %s", packageXml));
            return null;
        }
        LocalPackage p = repo.getLocalPackage();
        if (p == null) {
            progress.logWarning("Didn't find any local package in repository");
            return null;
        }
        p.setInstalledPath(packageXml.getParentFile());
        return p;
    }
}

