/*
 * Decompiled with CFR 0.152.
 */
package aQute.maven.nexus.provider;

import aQute.bnd.http.HttpClient;
import aQute.bnd.http.HttpRequest;
import aQute.bnd.service.url.TaggedData;
import aQute.maven.nexus.provider.ContentDTO;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Nexus {
    private URI uri;
    private HttpClient client;

    public Nexus(URI uri, HttpClient client) throws URISyntaxException {
        this.uri = client.makeDir(uri);
        this.client = client;
    }

    public HttpRequest<Object> request() {
        return this.client.build().headers("Accept", "application/json").headers("User-Agent", "bnd");
    }

    public List<URI> files() throws Exception {
        URI uri = new URI(this.uri + "/content/");
        ArrayList<URI> uris = new ArrayList<URI>();
        this.files(uris, uri);
        return uris;
    }

    public void files(List<URI> list, URI uri) throws Exception {
        ContentDTO content = (ContentDTO)((Object)this.request().get(ContentDTO.class).go(uri));
        for (ContentDTO.ItemDTO item : content.data) {
            if (item.sizeOnDisk < 0L) {
                this.files(list, item.resourceURI);
                continue;
            }
            if (!this.isReal(item.resourceURI)) continue;
            list.add(item.resourceURI);
        }
    }

    private boolean isReal(URI uri) {
        return !uri.getPath().endsWith(".sha1") && !uri.getPath().endsWith(".asc") && !uri.getPath().endsWith(".md5");
    }

    public File download(URI uri) throws Exception {
        return (File)this.request().useCache().age(30, TimeUnit.SECONDS).go(uri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void upload(URI uri, byte[] data) throws Exception {
        try (TaggedData tag = (TaggedData)this.request().put().upload((Object)data).asTag().go(uri);){
            switch (tag.getState()) {
                default: {
                    tag.throwIt();
                    return;
                }
                case UNMODIFIED: 
                case UPDATED: 
            }
            return;
        }
    }
}

