/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.flex.build;

import com.intellij.flex.build.FlexResourceBuildTarget;
import com.intellij.flex.model.bc.JpsFlexBuildConfigurationManager;
import com.intellij.flex.model.module.JpsFlexModuleType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.ModuleBasedBuildTargetType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.module.JpsModuleType;
import org.jetbrains.jps.model.module.JpsTypedModule;

public class FlexResourceBuildTargetType
extends ModuleBasedBuildTargetType<FlexResourceBuildTarget> {
    public static final FlexResourceBuildTargetType PRODUCTION = new FlexResourceBuildTargetType("flex-resource-production", false);
    public static final FlexResourceBuildTargetType TEST = new FlexResourceBuildTargetType("flex-resource-test", true);
    private final boolean myIsTests;

    private FlexResourceBuildTargetType(String typeId, boolean isTests) {
        super(typeId);
        this.myIsTests = isTests;
    }

    public boolean isTests() {
        return this.myIsTests;
    }

    @NotNull
    public List<FlexResourceBuildTarget> computeAllTargets(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/flex/build/FlexResourceBuildTargetType", "computeAllTargets"));
        }
        ArrayList<FlexResourceBuildTarget> targets = new ArrayList<FlexResourceBuildTarget>();
        for (JpsTypedModule module : model.getProject().getModules((JpsModuleType)JpsFlexModuleType.INSTANCE)) {
            targets.add(new FlexResourceBuildTarget(this, (JpsTypedModule<JpsFlexBuildConfigurationManager>)module));
        }
        ArrayList<FlexResourceBuildTarget> arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexResourceBuildTargetType", "computeAllTargets"));
        }
        return arrayList;
    }

    @NotNull
    public BuildTargetLoader<FlexResourceBuildTarget> createLoader(@NotNull JpsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/flex/build/FlexResourceBuildTargetType", "createLoader"));
        }
        final HashMap<String, JpsTypedModule> modules = new HashMap<String, JpsTypedModule>();
        for (JpsTypedModule module : model.getProject().getModules((JpsModuleType)JpsFlexModuleType.INSTANCE)) {
            modules.put(module.getName(), module);
        }
        BuildTargetLoader<FlexResourceBuildTarget> buildTargetLoader = new BuildTargetLoader<FlexResourceBuildTarget>(){

            @Nullable
            public FlexResourceBuildTarget createTarget(@NotNull String targetId) {
                if (targetId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "com/intellij/flex/build/FlexResourceBuildTargetType$1", "createTarget"));
                }
                JpsTypedModule module = (JpsTypedModule)modules.get(targetId);
                return module != null ? new FlexResourceBuildTarget(FlexResourceBuildTargetType.this, (JpsTypedModule<JpsFlexBuildConfigurationManager>)module) : null;
            }
        };
        if (buildTargetLoader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/flex/build/FlexResourceBuildTargetType", "createLoader"));
        }
        return buildTargetLoader;
    }
}

