/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.impl.AbstractForwardIndex;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.DiffUpdateData;
import com.intellij.util.indexing.impl.ForwardIndex;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.SimpleUpdateData;
import com.intellij.util.indexing.impl.UpdateData;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Experimental
public abstract class MapReduceIndex<Key, Value, Input>
implements InvertedIndex<Key, Value, Input> {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.indexing.impl.MapReduceIndex");
    @NotNull
    protected final ID<Key, Value> myIndexId;
    @NotNull
    protected final IndexStorage<Key, Value> myStorage;
    protected final DataExternalizer<Value> myValueExternalizer;
    protected final IndexExtension<Key, Value, Input> myExtension;
    private final AtomicLong myModificationStamp;
    private final DataIndexer<Key, Value, Input> myIndexer;
    protected volatile ForwardIndex<Key, Value> myForwardIndex;
    private final boolean myUseDiffUpdate;
    private final ReentrantReadWriteLock myLock;
    private volatile boolean myDisposed;
    private final LowMemoryWatcher myLowMemoryFlusher;
    private final UpdateData.RemovedKeyProcessor<Key> myRemovedKeyProcessor;
    private final UpdateData.KeyValueUpdateProcessor<Key, Value> myAddedKeyProcessor;
    private final UpdateData.KeyValueUpdateProcessor<Key, Value> myUpdatedKeyProcessor;

    protected MapReduceIndex(@NotNull IndexExtension<Key, Value, Input> extension, @NotNull IndexStorage<Key, Value> storage, ForwardIndex<Key, Value> forwardIndex) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/util/indexing/impl/MapReduceIndex", "<init>"));
        }
        if (storage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storage", "com/intellij/util/indexing/impl/MapReduceIndex", "<init>"));
        }
        this.myModificationStamp = new AtomicLong();
        this.myLock = new ReentrantReadWriteLock();
        this.myLowMemoryFlusher = LowMemoryWatcher.register(new Runnable(){

            @Override
            public void run() {
                try {
                    Lock writeLock = MapReduceIndex.this.getWriteLock();
                    if (writeLock.tryLock()) {
                        try {
                            MapReduceIndex.this.myStorage.clearCaches();
                        }
                        finally {
                            writeLock.unlock();
                        }
                    }
                    MapReduceIndex.this.flush();
                }
                catch (StorageException e) {
                    LOG.info(e);
                    MapReduceIndex.this.requestRebuild(e);
                }
            }
        });
        this.myRemovedKeyProcessor = new UpdateData.RemovedKeyProcessor<Key>(){

            @Override
            public void process(Key key, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
            }
        };
        this.myAddedKeyProcessor = new UpdateData.KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myUpdatedKeyProcessor = new UpdateData.KeyValueUpdateProcessor<Key, Value>(){

            @Override
            public void process(Key key, Value value, int inputId) throws StorageException {
                MapReduceIndex.this.myModificationStamp.incrementAndGet();
                MapReduceIndex.this.myStorage.removeAllValues(key, inputId);
                MapReduceIndex.this.myStorage.addValue(key, inputId, value);
            }
        };
        this.myIndexId = extension.getName();
        this.myExtension = extension;
        this.myIndexer = this.myExtension.getIndexer();
        this.myStorage = storage;
        this.myValueExternalizer = extension.getValueExternalizer();
        this.myForwardIndex = forwardIndex;
        this.myUseDiffUpdate = DiffUpdateData.ourDiffUpdateEnabled && (forwardIndex == null || this.myForwardIndex instanceof AbstractForwardIndex && !((AbstractForwardIndex)this.myForwardIndex).hasOnlyKeysData());
    }

    @NotNull
    public IndexStorage<Key, Value> getStorage() {
        IndexStorage<Key, Value> indexStorage = this.myStorage;
        if (indexStorage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "getStorage"));
        }
        return indexStorage;
    }

    @Override
    public void clear() throws StorageException {
        try {
            this.getWriteLock().lock();
            this.myStorage.clear();
            if (this.myForwardIndex != null) {
                this.myForwardIndex.clear();
            }
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        catch (IOException e) {
            LOG.error(e);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    @Override
    public void flush() throws StorageException {
        try {
            this.getReadLock().lock();
            if (this.myForwardIndex != null) {
                this.myForwardIndex.flush();
            }
            this.myStorage.flush();
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StorageException || cause instanceof IOException) {
                throw new StorageException(cause);
            }
            throw e;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.myLowMemoryFlusher.stop();
        Lock lock = this.getWriteLock();
        try {
            lock.lock();
            try {
                this.myStorage.close();
            }
            finally {
                try {
                    if (this.myForwardIndex != null) {
                        this.myForwardIndex.close();
                    }
                }
                catch (IOException e) {
                    LOG.error(e);
                }
            }
        }
        catch (StorageException e) {
            LOG.error(e);
        }
        finally {
            this.myDisposed = true;
            lock.unlock();
        }
    }

    @NotNull
    public final Lock getReadLock() {
        ReentrantReadWriteLock.ReadLock readLock = this.myLock.readLock();
        if (readLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "getReadLock"));
        }
        return readLock;
    }

    @NotNull
    public final Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "getWriteLock"));
        }
        return writeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @NotNull
    public ValueContainer<Value> getData(@NotNull Key key) throws StorageException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/util/indexing/impl/MapReduceIndex", "getData"));
        }
        Lock lock = this.getReadLock();
        lock.lock();
        if (this.myDisposed) {
            ValueContainerImpl valueContainerImpl = new ValueContainerImpl();
            ValueContainerImpl valueContainerImpl2 = valueContainerImpl;
            if (valueContainerImpl2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "getData"));
            }
            return valueContainerImpl2;
        }
        ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
        ValueContainer<Value> valueContainer = this.myStorage.read(key);
        ValueContainer<Value> valueContainer2 = valueContainer;
        if (valueContainer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "getData"));
        }
        return valueContainer2;
        finally {
            ValueContainerImpl.ourDebugIndexInfo.set(null);
            lock.unlock();
        }
    }

    @Override
    @NotNull
    public final Computable<Boolean> update(final int inputId, @Nullable Input content) {
        final UpdateData<Key, Value> updateData = this.calculateUpdateData(inputId, content);
        Computable<Boolean> computable = new Computable<Boolean>(){

            @Override
            public Boolean compute() {
                try {
                    MapReduceIndex.this.updateWithMap(inputId, updateData);
                }
                catch (StorageException ex) {
                    LOG.info("Exception during updateWithMap:" + ex);
                    MapReduceIndex.this.requestRebuild(ex);
                    return Boolean.FALSE;
                }
                catch (ProcessCanceledException ex) {
                    LOG.info("Exception during updateWithMap:" + ex);
                    MapReduceIndex.this.requestRebuild(ex);
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
        };
        if (computable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "update"));
        }
        return computable;
    }

    @NotNull
    protected UpdateData<Key, Value> calculateUpdateData(final int inputId, @Nullable Input content) {
        final Map<Key, Value> data = this.mapInput(content);
        UpdateData<Key, Value> updateData = this.createUpdateData(data, new ThrowableComputable<ForwardIndex.InputKeyIterator<Key, Value>, IOException>(){

            @Override
            public ForwardIndex.InputKeyIterator<Key, Value> compute() throws IOException {
                return MapReduceIndex.this.readInputKeys(inputId);
            }
        }, new ThrowableRunnable<IOException>(){

            @Override
            public void run() throws IOException {
                MapReduceIndex.this.myForwardIndex.putInputData(inputId, data);
            }
        });
        if (updateData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "calculateUpdateData"));
        }
        return updateData;
    }

    @NotNull
    protected ForwardIndex.InputKeyIterator<Key, Value> readInputKeys(int inputId) throws IOException {
        ForwardIndex.InputKeyIterator<Key, Value> inputKeyIterator = this.myForwardIndex.getInputKeys(inputId);
        if (inputKeyIterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "readInputKeys"));
        }
        return inputKeyIterator;
    }

    @NotNull
    protected UpdateData<Key, Value> createUpdateData(Map<Key, Value> data, ThrowableComputable<ForwardIndex.InputKeyIterator<Key, Value>, IOException> keys, ThrowableRunnable<IOException> forwardIndexUpdate) {
        UpdateData updateData = this.myUseDiffUpdate ? new DiffUpdateData<Key, Value>(data, keys, this.myIndexId, forwardIndexUpdate) : new SimpleUpdateData<Key, Value>(data, keys, this.myIndexId, forwardIndexUpdate);
        if (updateData == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/indexing/impl/MapReduceIndex", "createUpdateData"));
        }
        return updateData;
    }

    protected Map<Key, Value> mapInput(Input content) {
        if (content == null) {
            return Collections.emptyMap();
        }
        Map<Key, Value> data = this.myIndexer.map(content);
        MapReduceIndex.checkValuesHaveProperEqualsAndHashCode(data, this.myIndexId, this.myValueExternalizer);
        this.checkCanceled();
        return data;
    }

    public abstract void checkCanceled();

    protected abstract void requestRebuild(Exception var1);

    public long getModificationStamp() {
        return this.myModificationStamp.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateWithMap(int inputId, @NotNull UpdateData<Key, Value> updateData) throws StorageException {
        if (updateData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updateData", "com/intellij/util/indexing/impl/MapReduceIndex", "updateWithMap"));
        }
        this.getWriteLock().lock();
        try {
            try {
                ValueContainerImpl.ourDebugIndexInfo.set(this.myIndexId);
                updateData.iterateKeys(inputId, this.myAddedKeyProcessor, this.myUpdatedKeyProcessor, this.myRemovedKeyProcessor);
                updateData.updateForwardIndex();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new StorageException(e);
            }
            finally {
                ValueContainerImpl.ourDebugIndexInfo.set(null);
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    public static <Key, Value> void checkValuesHaveProperEqualsAndHashCode(@NotNull Map<Key, Value> data, @NotNull ID<Key, Value> indexId, @NotNull DataExternalizer<Value> valueExternalizer) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/util/indexing/impl/MapReduceIndex", "checkValuesHaveProperEqualsAndHashCode"));
        }
        if (indexId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexId", "com/intellij/util/indexing/impl/MapReduceIndex", "checkValuesHaveProperEqualsAndHashCode"));
        }
        if (valueExternalizer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueExternalizer", "com/intellij/util/indexing/impl/MapReduceIndex", "checkValuesHaveProperEqualsAndHashCode"));
        }
        if (DebugAssertions.DEBUG) {
            for (Map.Entry<Key, Value> e : data.entrySet()) {
                Value value = e.getValue();
                if (!Comparing.equal(value, value) || value != null && value.hashCode() != value.hashCode()) {
                    LOG.error("Index " + indexId.toString() + " violates equals / hashCode contract for Value parameter");
                }
                try {
                    BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream();
                    DataOutputStream outputStream = new DataOutputStream(out);
                    valueExternalizer.save(outputStream, value);
                    outputStream.close();
                    Value deserializedValue = valueExternalizer.read(new DataInputStream(new UnsyncByteArrayInputStream(out.getInternalBuffer(), 0, out.size())));
                    if (Comparing.equal(value, deserializedValue) && (value == null || value.hashCode() == deserializedValue.hashCode())) continue;
                    LOG.error("Index " + indexId.toString() + " deserialization violates equals / hashCode contract for Value parameter");
                }
                catch (IOException ex) {
                    LOG.error(ex);
                }
            }
        }
    }
}

