/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.backwardRefs;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.backwardRefs.BackwardReferenceIndexWriter;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;

public class BackwardReferenceIndexBuilder
extends ModuleLevelBuilder {
    public BackwardReferenceIndexBuilder() {
        super(BuilderCategory.INITIAL);
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if ("backward-references indexer" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/backwardRefs/BackwardReferenceIndexBuilder", "getPresentableName"));
        }
        return "backward-references indexer";
    }

    @Override
    public void buildStarted(CompileContext context) {
        BackwardReferenceIndexWriter.initialize(context);
    }

    @Override
    public void buildFinished(CompileContext context) {
        BackwardReferenceIndexWriter.closeIfNeed();
    }

    @Override
    public List<String> getCompilableFileExtensions() {
        return Collections.emptyList();
    }

    @Override
    public ModuleLevelBuilder.ExitCode build(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, ModuleLevelBuilder.OutputConsumer outputConsumer) throws ProjectBuildException, IOException {
        BackwardReferenceIndexWriter writer;
        if (dirtyFilesHolder.hasRemovedFiles() && (writer = BackwardReferenceIndexWriter.getInstance()) != null) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                Collection<String> files = dirtyFilesHolder.getRemovedFiles(target);
                writer.processDeletedFiles(files);
            }
        }
        return null;
    }
}

