/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac.ast;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.Consumer;
import com.intellij.util.ReflectionUtil;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import com.sun.tools.javac.util.ClientCodeException;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaCompiler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.javac.ast.JavacTreeRefScanner;
import org.jetbrains.jps.javac.ast.api.JavacDef;
import org.jetbrains.jps.javac.ast.api.JavacFileData;
import org.jetbrains.jps.javac.ast.api.JavacNameTable;
import org.jetbrains.jps.javac.ast.api.JavacRef;

final class JavacReferenceCollectorListener
implements TaskListener {
    private final boolean myDivideImportRefs;
    private final Consumer<JavacFileData> myDataConsumer;
    private final JavacTreeRefScanner myAstScanner;
    private final Elements myElementUtility;
    private final Types myTypeUtility;
    private final Trees myTreeUtility;
    private final JavacNameTable myNameTableCache;
    private NotNullLazyValue<Name> myAsterisk = new NotNullLazyValue<Name>(){

        @NotNull
        protected Name compute() {
            Name name = JavacReferenceCollectorListener.this.myElementUtility.getName("*");
            if (name == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/javac/ast/JavacReferenceCollectorListener$1", "compute"));
            }
            return name;
        }
    };
    private final Map<String, ReferenceCollector> myIncompletelyProcessedFiles = new THashMap(10);

    static void installOn(JavaCompiler.CompilationTask task, boolean divideImportRefs, Consumer<JavacFileData> dataConsumer) {
        JavacTask javacTask = (JavacTask)task;
        Method addTaskMethod = ReflectionUtil.getMethod(JavacTask.class, (String)"addTaskListener", (Class[])new Class[]{TaskListener.class});
        JavacReferenceCollectorListener taskListener = new JavacReferenceCollectorListener(divideImportRefs, dataConsumer, javacTask.getElements(), javacTask.getTypes(), Trees.instance(javacTask));
        if (addTaskMethod != null) {
            try {
                addTaskMethod.invoke((Object)task, taskListener);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        } else {
            javacTask.setTaskListener(taskListener);
        }
    }

    private JavacReferenceCollectorListener(boolean divideImportRefs, Consumer<JavacFileData> dataConsumer, Elements elementUtility, Types typeUtility, Trees treeUtility) {
        this.myDivideImportRefs = divideImportRefs;
        this.myDataConsumer = dataConsumer;
        this.myElementUtility = elementUtility;
        this.myTypeUtility = typeUtility;
        this.myTreeUtility = treeUtility;
        this.myAstScanner = JavacTreeRefScanner.createASTScanner();
        this.myNameTableCache = new JavacNameTable(elementUtility);
    }

    @Override
    public void started(TaskEvent e) {
    }

    @Override
    public void finished(TaskEvent e) {
        try {
            if (e.getKind() == TaskEvent.Kind.ANALYZE) {
                boolean isFileDataComplete;
                boolean collectImportsData;
                CompilationUnitTree unit = e.getCompilationUnit();
                String fileName = e.getSourceFile().getName();
                ClassTree declarationToProcess = this.myTreeUtility.getTree(e.getTypeElement());
                boolean addedToCache = true;
                ReferenceCollector incompletelyProcessedFile = this.myIncompletelyProcessedFiles.get(fileName);
                if (incompletelyProcessedFile == null) {
                    int declarationCount = unit.getTypeDecls().size();
                    incompletelyProcessedFile = new ReferenceCollector(declarationCount, fileName, unit);
                    if (declarationCount == 1 && declarationToProcess != null) {
                        addedToCache = false;
                    } else {
                        this.myIncompletelyProcessedFiles.put(fileName, incompletelyProcessedFile);
                    }
                    collectImportsData = true;
                } else {
                    collectImportsData = false;
                }
                if (incompletelyProcessedFile.decrementRemainDeclarationsAndGet(declarationToProcess) == 0) {
                    if (addedToCache) {
                        this.myIncompletelyProcessedFiles.remove(fileName);
                    }
                    isFileDataComplete = true;
                } else {
                    isFileDataComplete = false;
                }
                if (collectImportsData) {
                    this.scanImports(unit, incompletelyProcessedFile.myFileData.getRefs(), incompletelyProcessedFile);
                    if (this.myDivideImportRefs) {
                        this.scanImports(unit, incompletelyProcessedFile.myFileData.getImportRefs(), incompletelyProcessedFile);
                    }
                }
                this.myAstScanner.scan(declarationToProcess, incompletelyProcessedFile);
                if (isFileDataComplete) {
                    for (AnnotationTree annotationTree : unit.getPackageAnnotations()) {
                        this.myAstScanner.scan(annotationTree, incompletelyProcessedFile);
                    }
                    this.myDataConsumer.consume((Object)incompletelyProcessedFile.myFileData);
                }
            }
        }
        catch (Exception ex) {
            throw new ClientCodeException(ex);
        }
    }

    private void scanImports(CompilationUnitTree compilationUnit, Collection<JavacRef> elements, ReferenceCollector incompletelyProcessedFile) {
        for (ImportTree importTree : compilationUnit.getImports()) {
            MemberSelectTree id = (MemberSelectTree)importTree.getQualifiedIdentifier();
            Element element = incompletelyProcessedFile.getReferencedElement(id);
            if (element == null) {
                ExpressionTree qExpr = id.getExpression();
                if (!(qExpr instanceof MemberSelectTree)) continue;
                MemberSelectTree classImport = (MemberSelectTree)qExpr;
                Element ownerElement = incompletelyProcessedFile.getReferencedElement(classImport);
                Name name = id.getIdentifier();
                if (name != this.myAsterisk.getValue()) {
                    for (Element element2 : this.myElementUtility.getAllMembers((TypeElement)ownerElement)) {
                        if (element2.getSimpleName() != name) continue;
                        elements.add(JavacRef.JavacElementRefBase.fromElement(element2, this.myNameTableCache));
                    }
                }
                this.collectClassImports(ownerElement, elements);
                continue;
            }
            this.collectClassImports(element, elements);
        }
    }

    private void collectClassImports(Element baseImport, Collection<JavacRef> collector) {
        for (Element element = baseImport; element != null && element.getKind() != ElementKind.PACKAGE; element = element.getEnclosingElement()) {
            collector.add(JavacRef.JavacElementRefBase.fromElement(element, this.myNameTableCache));
        }
    }

    private static Set<JavacRef> createReferenceHolder() {
        return new THashSet((TObjectHashingStrategy)new TObjectHashingStrategy<JavacRef>(){

            public int computeHashCode(JavacRef ref) {
                return ((JavacRef.JavacElementRefBase)ref).getOriginalElement().hashCode();
            }

            public boolean equals(JavacRef r1, JavacRef r2) {
                return ((JavacRef.JavacElementRefBase)r1).getOriginalElement() == ((JavacRef.JavacElementRefBase)r2).getOriginalElement();
            }
        });
    }

    private static List<JavacDef> createDefinitionHolder() {
        return new ArrayList<JavacDef>();
    }

    private static class JavacTreeHelper {
        private final TreePath myUnitPath;
        private final Trees myTreeUtil;

        private JavacTreeHelper(CompilationUnitTree unit, Trees treeUtil) {
            this.myUnitPath = new TreePath(unit);
            this.myTreeUtil = treeUtil;
        }

        private Element getReferencedElement(Tree tree) {
            return this.myTreeUtil.getElement(new TreePath(this.myUnitPath, tree));
        }

        public TypeMirror getType(Tree tree) {
            return this.myTreeUtil.getTypeMirror(new TreePath(this.myUnitPath, tree));
        }
    }

    class ReferenceCollector {
        private final JavacFileData myFileData;
        private final JavacTreeHelper myTreeHelper;
        private int myRemainDeclarations;

        private ReferenceCollector(int remainDeclarations, String filePath, CompilationUnitTree unitTree) {
            this.myRemainDeclarations = remainDeclarations;
            this.myFileData = new JavacFileData(filePath, JavacReferenceCollectorListener.createReferenceHolder(), (Collection<JavacRef>)(JavacReferenceCollectorListener.this.myDivideImportRefs ? JavacReferenceCollectorListener.createReferenceHolder() : Collections.emptyList()), JavacReferenceCollectorListener.createDefinitionHolder());
            this.myTreeHelper = new JavacTreeHelper(unitTree, JavacReferenceCollectorListener.this.myTreeUtility);
        }

        void sinkReference(JavacRef.JavacElementRefBase ref) {
            this.myFileData.getRefs().add(ref);
        }

        void sinkDeclaration(JavacDef def) {
            this.myFileData.getDefs().add(def);
        }

        JavacRef.JavacElementRefBase asJavacRef(Element element) {
            return JavacRef.JavacElementRefBase.fromElement(element, JavacReferenceCollectorListener.this.myNameTableCache);
        }

        Element getReferencedElement(Tree tree) {
            return this.myTreeHelper.getReferencedElement(tree);
        }

        TypeMirror getType(Tree tree) {
            return this.myTreeHelper.getType(tree);
        }

        Types getTypeUtility() {
            return JavacReferenceCollectorListener.this.myTypeUtility;
        }

        private int decrementRemainDeclarationsAndGet(Tree declarationToProcess) {
            return declarationToProcess == null ? this.myRemainDeclarations : (this.myRemainDeclarations = this.myRemainDeclarations - 1);
        }
    }
}

